/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins.watermarker;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.IOException;

class Writer {
    private PdfReader reader;
    private PdfStamper stamp;
    private String text;
    private int fontsize;
    private float opacity;
    private Color color;
    private BaseFont font;

    Writer(PdfReader reader, PdfStamper stamp, String text, int fontsize, float opacity, Color color) {
        this.reader = reader;
        this.stamp = stamp;
        this.text = text;
        this.fontsize = fontsize;
        this.opacity = opacity;
        this.color = color;
    }

    Writer withFont(BaseFont font) {
        this.font = font;
        return this;
    }

    void write() throws IOException, DocumentException {
        BaseFont bf = this.font != null ? this.font : BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        int pagecount = this.reader.getNumberOfPages();
        PdfGState gs1 = new PdfGState();
        gs1.setFillOpacity(this.opacity);
        float txtwidth = bf.getWidthPoint(this.text, (float)this.fontsize);
        for (int i = 1; i <= pagecount; ++i) {
            PdfContentByte seitex = this.stamp.getOverContent(i);
            Rectangle recc = this.reader.getCropBox(i);
            recc.normalize();
            float winkel = (float)Math.atan(recc.getHeight() / recc.getWidth());
            float m1 = (float)Math.cos(winkel);
            float m2 = (float)(-Math.sin(winkel));
            float m3 = (float)Math.sin(winkel);
            float m4 = (float)Math.cos(winkel);
            float xoff = (float)(-Math.cos(winkel) * (double)txtwidth / 2.0 - Math.sin(winkel) * (double)this.fontsize / 2.0);
            float yoff = (float)(Math.sin(winkel) * (double)txtwidth / 2.0 - Math.cos(winkel) * (double)this.fontsize / 2.0);
            seitex.saveState();
            seitex.setGState(gs1);
            seitex.beginText();
            seitex.setFontAndSize(bf, (float)this.fontsize);
            seitex.setColorFill(this.color);
            seitex.setTextMatrix(m1, m2, m3, m4, xoff + recc.getWidth() / 2.0f, yoff + recc.getHeight() / 2.0f);
            seitex.showText(this.text);
            seitex.endText();
            seitex.restoreState();
        }
        this.stamp.close();
    }
}

