/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.view.itext;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.model.ObjectLoader;
import com.lowagie.rups.model.TreeNodeFactory;
import com.lowagie.rups.view.icons.IconTreeCellRenderer;
import com.lowagie.rups.view.itext.treenodes.OutlineTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.text.pdf.PdfName;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class OutlineTree
extends JTree
implements TreeSelectionListener,
Observer {
    private static final long serialVersionUID = 5646572654823301007L;
    protected PdfReaderController controller;

    public OutlineTree(PdfReaderController controller) {
        this.controller = controller;
        this.setCellRenderer(new IconTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
        this.addTreeSelectionListener(this);
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (obj == null) {
            this.setModel(new DefaultTreeModel(new OutlineTreeNode()));
            this.repaint();
            return;
        }
        if (obj instanceof ObjectLoader) {
            PdfTrailerTreeNode trailer;
            PdfObjectTreeNode catalog;
            ObjectLoader loader = (ObjectLoader)obj;
            TreeNodeFactory factory = loader.getNodes();
            PdfObjectTreeNode outline = factory.getChildNode(catalog = factory.getChildNode(trailer = this.controller.getPdfTree().getRoot(), PdfName.ROOT), PdfName.OUTLINES);
            if (outline == null) {
                return;
            }
            OutlineTreeNode root = new OutlineTreeNode();
            this.loadOutline(factory, root, factory.getChildNode(outline, PdfName.FIRST));
            this.setModel(new DefaultTreeModel(root));
        }
    }

    private void loadOutline(TreeNodeFactory factory, OutlineTreeNode parent, PdfObjectTreeNode child) {
        PdfObjectTreeNode next;
        OutlineTreeNode childnode = new OutlineTreeNode(child);
        parent.add(childnode);
        PdfObjectTreeNode first = factory.getChildNode(child, PdfName.FIRST);
        if (first != null) {
            this.loadOutline(factory, childnode, first);
        }
        if ((next = factory.getChildNode(child, PdfName.NEXT)) != null) {
            this.loadOutline(factory, parent, next);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        if (this.controller == null) {
            return;
        }
        OutlineTreeNode selectednode = (OutlineTreeNode)this.getLastSelectedPathComponent();
        PdfObjectTreeNode node = selectednode.getCorrespondingPdfObjectNode();
        if (node != null) {
            this.controller.selectNode(node);
        }
    }
}

