/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.ctrlwords;

import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordHandler;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordListener;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordMap;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;

public final class RtfCtrlWordMgr {
    public static final boolean debug = false;
    public static final boolean debugFound = false;
    public static final boolean debugNotFound = true;
    private final PushbackInputStream reader;
    private final RtfParser rtfParser;
    private final RtfCtrlWordMap ctrlWordMap;
    private final List<RtfCtrlWordListener> listeners = new ArrayList<RtfCtrlWordListener>();

    public RtfCtrlWordMgr(RtfParser rtfParser, PushbackInputStream reader) {
        this.rtfParser = rtfParser;
        this.reader = reader;
        this.ctrlWordMap = new RtfCtrlWordMap(rtfParser);
    }

    public int handleKeyword(RtfCtrlWordData ctrlWordData, int groupLevel) {
        this.beforeCtrlWord(ctrlWordData);
        int result = this.dispatchKeyword(ctrlWordData, groupLevel);
        this.afterCtrlWord(ctrlWordData);
        return result;
    }

    private int dispatchKeyword(RtfCtrlWordData ctrlWordData, int groupLevel) {
        int result = 0;
        if (ctrlWordData != null) {
            RtfCtrlWordHandler ctrlWord = this.ctrlWordMap.getCtrlWordHandler(ctrlWordData.ctrlWord);
            if (ctrlWord != null) {
                ctrlWord.handleControlword(ctrlWordData);
            } else {
                result = -8;
            }
        }
        return result;
    }

    public void addRtfCtrlWordListener(RtfCtrlWordListener listener) {
        this.listeners.add(listener);
    }

    public void removeRtfCtrlWordListener(RtfCtrlWordListener listener) {
        this.listeners.remove(listener);
    }

    private boolean beforeCtrlWord(RtfCtrlWordData ctrlWordData) {
        for (RtfCtrlWordListener listener : this.listeners) {
            listener.beforeCtrlWord(ctrlWordData);
        }
        return true;
    }

    private boolean onCtrlWord(RtfCtrlWordData ctrlWordData) {
        for (RtfCtrlWordListener listener : this.listeners) {
            listener.onCtrlWord(ctrlWordData);
        }
        return true;
    }

    private boolean afterCtrlWord(RtfCtrlWordData ctrlWordData) {
        for (RtfCtrlWordListener listener : this.listeners) {
            listener.afterCtrlWord(ctrlWordData);
        }
        return true;
    }
}

