/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.openpdf.text.ExceptionConverter;
import org.openpdf.text.Image;
import org.openpdf.text.ImgWMF;
import org.openpdf.text.Jpeg;
import org.openpdf.text.Jpeg2000;
import org.openpdf.text.Utilities;

public class ImageLoader {
    public static Image getPngImage(URL url) {
        Image image;
        block8: {
            InputStream is = url.openStream();
            try {
                BufferedImage bufferedImage = ImageIO.read(is);
                image = ImageLoader.getImage(bufferedImage, 2);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            is.close();
        }
        return image;
    }

    public static Image getWMFImage(URL url) {
        try {
            return new ImgWMF(url);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getGifImage(URL url) {
        Image image;
        block8: {
            InputStream is = url.openStream();
            try {
                BufferedImage bufferedImage = ImageIO.read(is);
                image = ImageLoader.getImage(bufferedImage, 3);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            is.close();
        }
        return image;
    }

    public static Image getTiffImage(URL url) {
        Image image;
        block8: {
            InputStream is = url.openStream();
            try {
                BufferedImage bufferedImage = ImageIO.read(is);
                image = ImageLoader.getImage(bufferedImage, 5);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            is.close();
        }
        return image;
    }

    public static Image getBmpImage(URL url) {
        Image image;
        block8: {
            InputStream is = url.openStream();
            try {
                BufferedImage bufferedImage = ImageIO.read(is);
                image = ImageLoader.getImage(bufferedImage, 4);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            is.close();
        }
        return image;
    }

    public static Image getJpegImage(URL url) {
        Jpeg jpeg;
        block8: {
            InputStream is = url.openStream();
            try {
                byte[] imageBytes = Utilities.toByteArray(is);
                jpeg = new Jpeg(imageBytes);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            is.close();
        }
        return jpeg;
    }

    public static Image getJpeg2000Image(URL url) {
        Jpeg2000 jpeg2000;
        block8: {
            InputStream is = url.openStream();
            try {
                byte[] imageBytes = Utilities.toByteArray(is);
                jpeg2000 = new Jpeg2000(imageBytes);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            is.close();
        }
        return jpeg2000;
    }

    public static Image getGifImage(byte[] imageData) {
        Image image;
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            image = ImageLoader.getImage(bufferedImage, 3);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        ((InputStream)is).close();
        return image;
    }

    public static Image getPngImage(byte[] imageData) {
        Image image;
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            image = ImageLoader.getImage(bufferedImage, 2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        ((InputStream)is).close();
        return image;
    }

    public static Image getWMFImage(byte[] imageData) {
        try {
            return new ImgWMF(imageData);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getBmpImage(byte[] imageData) {
        Image image;
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            image = ImageLoader.getImage(bufferedImage, 4);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        ((InputStream)is).close();
        return image;
    }

    public static Image getTiffImage(byte[] imageData) {
        Image image;
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            image = ImageLoader.getImage(bufferedImage, 5);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
        }
        ((InputStream)is).close();
        return image;
    }

    public static Image getJpegImage(byte[] imageData) {
        try {
            return new Jpeg(imageData);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static Image getJpeg2000Image(byte[] imageData) {
        try {
            return new Jpeg2000(imageData);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private static Image getImage(BufferedImage bufferedImage, int originalType) throws IOException {
        Image image = Image.getInstance(bufferedImage, null, false);
        image.setOriginalType(originalType);
        return image;
    }
}

