/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fop.fonts.apps.TTFReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TTFCache {
    private static Map<String, TTFFile> ttfFileMap = new ConcurrentHashMap<String, TTFFile>();

    public static TTFFile getTTFFile(String fileName, TrueTypeFontUnicode ttu) {
        if (ttfFileMap.containsKey(fileName)) {
            return ttfFileMap.get(fileName);
        }
        TTFReader app = new TTFReader();
        TTFFile ttf = null;
        try {
            ttf = TTFCache.loadTTF(app, fileName, ttu);
            ttfFileMap.put(fileName, ttf);
            return ttf;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TTFFile loadTTF(TTFReader app, String fileName, TrueTypeFontUnicode ttu) throws IOException {
        try {
            return app.loadTTF(fileName, null, true, true);
        }
        catch (IOException e) {
            TTFFile ttfFile = new TTFFile(true, true);
            try (InputStream stream = BaseFont.getResourceStream(fileName, null);){
                if (stream == null) {
                    stream = TTFCache.getStreamFromFont(ttu);
                }
                FontFileReader reader = new FontFileReader(stream);
                String fontName = null;
                ttfFile.readFont(reader, fontName);
            }
            if (ttfFile.isCFF()) {
                throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
            }
            return ttfFile;
        }
    }

    private static InputStream getStreamFromFont(TrueTypeFontUnicode ttu) throws IOException {
        return new ByteArrayInputStream(ttu.getFullFont());
    }
}

