/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.colorspace;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import org.openpdf.renderer.BaseWatchable;

public class CMYKColorSpace
extends ColorSpace {
    private ICC_Profile icc;
    private ICC_ColorSpace icc_cs;

    public CMYKColorSpace() {
        super(9, 4);
        try {
            String resourcePath = "/ch/randelshofer/media/jpeg/Generic_CMYK_Profile.icc";
            InputStream iccStream = CMYKColorSpace.class.getResourceAsStream(resourcePath);
            if (iccStream == null) {
                throw new IOException("ICC profile not found in classpath at " + resourcePath);
            }
            this.icc = ICC_Profile.getInstance(iccStream);
            this.icc_cs = new ICC_ColorSpace(this.icc);
            iccStream.close();
        }
        catch (IOException e) {
            BaseWatchable.getErrorHandler().publishException(e);
        }
    }

    @Override
    public float[] fromCIEXYZ(float[] p_colorvalue) {
        if (this.icc_cs != null) {
            return this.icc_cs.fromCIEXYZ(p_colorvalue);
        }
        ColorSpace l_cs = ColorSpace.getInstance(5);
        float[] l_rgb = l_cs.toCIEXYZ(p_colorvalue);
        return this.fromRGB(l_rgb);
    }

    @Override
    public float[] fromRGB(float[] p_rgbvalue) {
        if (this.icc_cs != null) {
            return this.icc_cs.fromRGB(p_rgbvalue);
        }
        float[] l_res = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (p_rgbvalue.length >= 3) {
            l_res[0] = 1.0f - p_rgbvalue[0];
            l_res[1] = 1.0f - p_rgbvalue[1];
            l_res[2] = 1.0f - p_rgbvalue[2];
        }
        return this.normalize(l_res);
    }

    @Override
    public float[] toCIEXYZ(float[] p_colorvalue) {
        if (this.icc_cs != null) {
            return this.icc_cs.toCIEXYZ(p_colorvalue);
        }
        float[] l_rgb = this.toRGB(p_colorvalue);
        ColorSpace l_cs = ColorSpace.getInstance(5);
        return l_cs.toCIEXYZ(l_rgb);
    }

    @Override
    public float[] toRGB(float[] p_colorvalue) {
        if (this.icc_cs != null) {
            return this.icc_cs.toRGB(p_colorvalue);
        }
        float[] l_res = new float[]{0.0f, 0.0f, 0.0f};
        if (p_colorvalue.length >= 4) {
            float l_black = 1.0f - p_colorvalue[3];
            l_res[0] = l_black * (1.0f - p_colorvalue[0]);
            l_res[1] = l_black * (1.0f - p_colorvalue[1]);
            l_res[2] = l_black * (1.0f - p_colorvalue[2]);
        }
        return this.normalize(l_res);
    }

    public float[] normalize(float[] p_colors) {
        for (int l_i = 0; l_i < p_colors.length; ++l_i) {
            if (p_colors[l_i] > 1.0f) {
                p_colors[l_i] = 1.0f;
                continue;
            }
            if (!(p_colors[l_i] < 0.0f)) continue;
            p_colors[l_i] = 0.0f;
        }
        return p_colors;
    }
}

