/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.annotation;

import java.io.IOException;
import org.openpdf.renderer.PDFDestination;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFParseException;
import org.openpdf.renderer.action.GoToAction;
import org.openpdf.renderer.action.PDFAction;
import org.openpdf.renderer.annotation.AnnotationType;
import org.openpdf.renderer.annotation.PDFAnnotation;

public class LinkAnnotation
extends PDFAnnotation {
    private PDFAction action = null;

    public LinkAnnotation(PDFObject annotObject) throws IOException {
        super(annotObject, AnnotationType.LINK);
        PDFObject actionObj = annotObject.getDictRef("A");
        if (actionObj != null) {
            this.action = PDFAction.getAction(actionObj, annotObject.getRoot());
        } else {
            PDFObject dest = annotObject.getDictRef("Dest");
            if (dest == null) {
                dest = annotObject.getDictRef("DEST");
            }
            if (dest != null) {
                this.action = new GoToAction(PDFDestination.getDestination(dest, annotObject.getRoot()));
            } else {
                throw new PDFParseException("Could not parse link annotation (no Action or Destination found): " + annotObject.toString());
            }
        }
    }

    public PDFAction getAction() {
        return this.action;
    }
}

