/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.font;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFRenderer;
import org.openpdf.renderer.font.FontSupport;
import org.openpdf.renderer.font.PDFFont;
import org.openpdf.renderer.font.PDFGlyph;
import org.openpdf.renderer.font.Type0Font;
import org.openpdf.renderer.font.cid.PDFCMap;

public class PDFFontEncoding {
    private static final int TYPE_ENCODING = 0;
    private static final int TYPE_CMAP = 1;
    private int[] baseEncoding;
    private Map<Character, String> differences;
    private PDFCMap cmap;
    private int type;
    private PDFObject mapName;

    public PDFFontEncoding(PDFCMap cmap) {
        this.type = 1;
        this.cmap = cmap;
    }

    public PDFFontEncoding(String fontType, PDFObject encoding) throws IOException {
        if (encoding.getType() == 4) {
            if (fontType.equals("Type0")) {
                this.type = 1;
                this.cmap = PDFCMap.getCMap(encoding.getStringValue());
            } else {
                this.type = 0;
                this.differences = new HashMap<Character, String>();
                this.baseEncoding = this.getBaseEncoding(encoding.getStringValue());
            }
        } else {
            String typeStr = encoding.getDictRef("Type").getStringValue();
            if (typeStr.equals("Encoding")) {
                this.type = 0;
                this.parseEncoding(encoding);
            } else if (typeStr.equals("CMap")) {
                this.type = 1;
                this.cmap = PDFCMap.getCMap(encoding);
                this.mapName = encoding.getDictRef("CMapName");
            } else {
                throw new IllegalArgumentException("Uknown encoding type: " + this.type);
            }
        }
    }

    public List<PDFGlyph> getGlyphs(PDFFont font, String text) {
        ArrayList<PDFGlyph> outList = new ArrayList<PDFGlyph>(text.length());
        char[] arry = text.toCharArray();
        block4: for (int i = 0; i < arry.length; ++i) {
            switch (this.type) {
                case 0: {
                    outList.add(this.getGlyphFromEncoding(font, arry[i]));
                    continue block4;
                }
                case 1: {
                    char c = (char)((arry[i] & 0xFF) << 8);
                    if (i < arry.length - 1) {
                        c = (char)(c | (char)(arry[++i] & 0xFF));
                    }
                    outList.add(this.getGlyphFromCMap(font, c));
                }
            }
        }
        return outList;
    }

    private PDFGlyph getGlyphFromEncoding(PDFFont font, char src) {
        String charName = null;
        if (this.differences.containsKey(Character.valueOf(src = (char)(src & 0xFF)))) {
            charName = this.differences.get(Character.valueOf(src));
        } else if (this.baseEncoding != null) {
            int charID = this.baseEncoding[src];
            charName = FontSupport.getName(charID);
        }
        return font.getCachedGlyph(src, charName);
    }

    private PDFGlyph getGlyphFromCMap(PDFFont font, char src) {
        int fontID = this.cmap.getFontID(src);
        char charID = this.cmap.map(src);
        if (font instanceof Type0Font) {
            font = ((Type0Font)font).getDescendantFont(fontID);
        }
        return font.getCachedGlyph(charID, null);
    }

    public void parseEncoding(PDFObject encoding) throws IOException {
        PDFObject diffArrayObj;
        this.differences = new HashMap<Character, String>();
        PDFObject baseEncObj = encoding.getDictRef("BaseEncoding");
        if (baseEncObj != null) {
            this.baseEncoding = this.getBaseEncoding(baseEncObj.getStringValue());
        }
        if ((diffArrayObj = encoding.getDictRef("Differences")) != null) {
            PDFObject[] diffArray = diffArrayObj.getArray();
            int curPosition = -1;
            for (int i = 0; i < diffArray.length; ++i) {
                if (diffArray[i].getType() == 2) {
                    curPosition = diffArray[i].getIntValue();
                    continue;
                }
                if (diffArray[i].getType() == 4) {
                    Character key = Character.valueOf((char)curPosition);
                    this.differences.put(key, diffArray[i].getStringValue());
                    ++curPosition;
                    continue;
                }
                throw new IllegalArgumentException("Unexpected type in diff array: " + String.valueOf(diffArray[i]));
            }
        }
    }

    private int[] getBaseEncoding(String encodingName) {
        if (encodingName.equals("MacRomanEncoding")) {
            return FontSupport.macRomanEncoding;
        }
        if (encodingName.equals("MacExpertEncoding")) {
            return FontSupport.type1CExpertCharset;
        }
        if (encodingName.equals("WinAnsiEncoding")) {
            return FontSupport.winAnsiEncoding;
        }
        if (encodingName.equals("StandardEncoding")) {
            return FontSupport.standardEncoding;
        }
        if (encodingName.equals("SymbolSetEncoding")) {
            return FontSupport.symbolSetEncoding;
        }
        throw new IllegalArgumentException("Unknown encoding: " + encodingName);
    }

    public boolean isOneByteIdentity() {
        if (this.mapName != null) {
            try {
                return "OneByteIdentityH".equals(this.mapName.getStringValue());
            }
            catch (IOException e) {
                PDFRenderer.getErrorHandler().publishException(e);
            }
        }
        return false;
    }
}

