/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.annotation;

import com.sun.pdfview.PDFObject;
import java.io.IOException;

public class AnnotationBorderStyle {
    private Integer width;
    private BorderStyle borderStyle;
    private int[] dashArray;

    public static AnnotationBorderStyle parseFromDictionary(PDFObject bs) throws IOException {
        AnnotationBorderStyle result = new AnnotationBorderStyle();
        result.width = bs.getDictRefAsInt("W");
        result.borderStyle = BorderStyle.fromCode(bs.getDictRefAsString("S"));
        result.dashArray = bs.getDictRefAsIntArray("D");
        return result;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public Integer getWidth() {
        return this.width;
    }

    public int[] getDashArray() {
        return this.dashArray;
    }

    public static enum BorderStyle {
        SOLID("S"),
        DASHED("D"),
        BEVELED("B"),
        INSET("I"),
        UNDERLINE("U");

        private String code;

        private BorderStyle(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static BorderStyle fromCode(String code) {
            for (BorderStyle bs : BorderStyle.values()) {
                if (!bs.getCode().equals(code)) continue;
                return bs;
            }
            return SOLID;
        }
    }
}

