/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.openpdf.util.XRLog;

public class FontUtil {
    @CheckReturnValue
    public static boolean isEmbeddedBase64Font(@Nullable String uri) {
        return uri != null && uri.startsWith("data:font/");
    }

    @CheckReturnValue
    public static @Nullable InputStream getEmbeddedBase64Data(@Nullable String uri) {
        int b64Index;
        int n = b64Index = uri != null ? uri.indexOf("base64,") : -1;
        if (b64Index != -1) {
            String b64encoded = uri.substring(b64Index + "base64,".length());
            if (b64encoded.contains("%")) {
                b64encoded = URLDecoder.decode(b64encoded, StandardCharsets.US_ASCII);
            }
            return new ByteArrayInputStream(Base64.getDecoder().decode(b64encoded));
        }
        XRLog.load(Level.SEVERE, "Embedded css fonts must be encoded in base 64.");
        return null;
    }
}

