/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.swing;

import java.util.LinkedList;
import java.util.logging.Level;
import org.openpdf.swing.ImageLoadItem;
import org.openpdf.swing.ImageResourceLoader;
import org.openpdf.swing.MutableFSImage;
import org.openpdf.util.XRLog;

class ImageLoadQueue {
    private static final ImageLoadItem KILL_SWITCH = new ImageLoadItem(null, null, null, -1, -1);
    private final LinkedList<ImageLoadItem> _loadQueue = new LinkedList();

    ImageLoadQueue() {
    }

    public synchronized void addToQueue(ImageResourceLoader imageResourceLoader, String uri, MutableFSImage mfsi, int width, int height) {
        XRLog.general(Level.FINE, "Queueing load for image uri " + uri);
        this._loadQueue.addLast(new ImageLoadItem(imageResourceLoader, uri, mfsi, width, height));
        this.notifyAll();
    }

    public synchronized ImageLoadItem getTask() throws InterruptedException {
        while (this._loadQueue.isEmpty()) {
            this.wait();
        }
        if (this._loadQueue.getLast() == KILL_SWITCH) {
            XRLog.general(Level.FINE, "Thread " + Thread.currentThread().getName() + " requested item, but queue is shutting down; returning kill switch.");
            return KILL_SWITCH;
        }
        ImageLoadItem item = this._loadQueue.removeLast();
        XRLog.general(Level.FINE, "Thread " + Thread.currentThread().getName() + " pulled item " + item._uri + " from queue, " + (this._loadQueue.size() - 1) + " remaining");
        return item;
    }

    public synchronized void reset() {
        this._loadQueue.clear();
    }

    public synchronized void kill() {
        this._loadQueue.addLast(KILL_SWITCH);
        this.notifyAll();
    }

    public static boolean isKillSwitch(Object queueItem) {
        return queueItem == KILL_SWITCH;
    }

    public int size() {
        return this._loadQueue.size();
    }
}

