/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.simple.extend.form;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.parser.FSColor;
import org.openpdf.css.parser.FSRGBColor;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.css.style.FSDerivedValue;
import org.openpdf.css.style.derived.LengthValue;
import org.openpdf.extend.UserAgentCallback;
import org.openpdf.layout.LayoutContext;
import org.openpdf.render.BlockBox;
import org.openpdf.render.FSFont;
import org.openpdf.simple.extend.URLUTF8Encoder;
import org.openpdf.simple.extend.XhtmlForm;
import org.openpdf.simple.extend.form.FormFieldState;
import org.openpdf.swing.AWTFSFont;
import org.w3c.dom.Element;

public abstract class FormField {
    private final XhtmlForm _parentForm;
    private final Element _element;
    private @Nullable FormFieldState _originalState;
    private JComponent _component;
    private final LayoutContext context;
    private final BlockBox box;
    protected @Nullable Integer intrinsicWidth;
    protected @Nullable Integer intrinsicHeight;

    protected FormField(Element e, XhtmlForm form, LayoutContext context, BlockBox box) {
        this._element = e;
        this._parentForm = form;
        this.context = context;
        this.box = box;
        this.initialize();
    }

    protected Element getElement() {
        return this._element;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public XhtmlForm getParentForm() {
        return this._parentForm;
    }

    @CheckReturnValue
    public Dimension getIntrinsicSize() {
        int width = this.intrinsicWidth == null ? 0 : this.intrinsicWidth;
        int height = this.intrinsicHeight == null ? 0 : this.intrinsicHeight;
        return new Dimension(width, height);
    }

    public void reset() {
        this.applyOriginalState();
    }

    protected UserAgentCallback getUserAgentCallback() {
        return this._parentForm.getUserAgentCallback();
    }

    protected FormFieldState getOriginalState() {
        if (this._originalState == null) {
            this._originalState = this.loadOriginalState();
        }
        return this._originalState;
    }

    protected boolean hasAttribute(String attributeName) {
        return !this.getElement().getAttribute(attributeName).isEmpty();
    }

    protected String getAttribute(String attributeName) {
        return this.getElement().getAttribute(attributeName);
    }

    private void initialize() {
        this._component = this.create();
        if (this._component != null) {
            if (this.intrinsicWidth == null) {
                this.intrinsicWidth = this._component.getPreferredSize().width;
            }
            if (this.intrinsicHeight == null) {
                this.intrinsicHeight = this._component.getPreferredSize().height;
            }
            this._component.setSize(this.getIntrinsicSize());
            String d = this._element.getAttribute("disabled");
            if (d.equalsIgnoreCase("disabled")) {
                this._component.setEnabled(false);
            }
        }
        this.applyOriginalState();
    }

    public abstract @Nullable JComponent create();

    protected FormFieldState loadOriginalState() {
        return FormFieldState.fromString("");
    }

    protected void applyOriginalState() {
    }

    public boolean includeInSubmission(JComponent source) {
        return true;
    }

    public Collection<String> getFormDataStrings() {
        if (!this.hasAttribute("name")) {
            return Collections.emptyList();
        }
        String name = this.getAttribute("name");
        String[] values = this.getFieldValues();
        return Stream.of(values).map(rawValue -> URLUTF8Encoder.encode(name) + "=" + URLUTF8Encoder.encode(rawValue)).collect(Collectors.toList());
    }

    protected abstract String[] getFieldValues();

    public BlockBox getBox() {
        return this.box;
    }

    public LayoutContext getContext() {
        return this.context;
    }

    public CalculatedStyle getStyle() {
        return this.getBox().getStyle();
    }

    protected void applyComponentStyle(JComponent comp) {
        FSColor background;
        CalculatedStyle style;
        FSColor foreground;
        Font font = this.getFont();
        if (font != null) {
            comp.setFont(font);
        }
        if ((foreground = (style = this.getStyle()).getColor()) != null) {
            comp.setForeground(FormField.toColor(foreground));
        }
        if ((background = style.getBackgroundColor()) != null) {
            comp.setBackground(FormField.toColor(background));
        }
    }

    private static Color toColor(FSColor color) {
        if (color instanceof FSRGBColor) {
            FSRGBColor rgb = (FSRGBColor)color;
            return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
        }
        throw new RuntimeException("internal error: unsupported color class " + color.getClass().getName());
    }

    public Font getFont() {
        FSFont font = this.getStyle().getFSFont(this.getContext());
        if (font instanceof AWTFSFont) {
            return ((AWTFSFont)font).getAWTFont();
        }
        return null;
    }

    protected static Integer getLengthValue(CalculatedStyle style, CSSName cssName) {
        FSDerivedValue widthValue = style.valueByName(cssName);
        if (widthValue instanceof LengthValue) {
            return (int)widthValue.asFloat();
        }
        return null;
    }
}

