/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.resource;

import org.jspecify.annotations.Nullable;

public final class HtmlParserConfig {
    public static final String CASE_UPPER = "upper";
    public static final String CASE_LOWER = "lower";
    public static final String CASE_DEFAULT = "default";
    private static final HtmlParserConfig DEFAULT_CONFIG = new Builder().build();
    private final boolean reportErrors;
    private final boolean allowSelfClosingTags;
    private final boolean allowSelfClosingIframe;
    private final boolean parseNoScriptContent;
    private final boolean scriptStripCommentDelims;
    private final boolean styleStripCommentDelims;
    private final @Nullable String elementNameCase;
    private final @Nullable String attributeNameCase;
    private final @Nullable String encoding;

    private HtmlParserConfig(Builder builder) {
        this.reportErrors = builder.reportErrors;
        this.allowSelfClosingTags = builder.allowSelfClosingTags;
        this.allowSelfClosingIframe = builder.allowSelfClosingIframe;
        this.parseNoScriptContent = builder.parseNoScriptContent;
        this.scriptStripCommentDelims = builder.scriptStripCommentDelims;
        this.styleStripCommentDelims = builder.styleStripCommentDelims;
        this.elementNameCase = builder.elementNameCase;
        this.attributeNameCase = builder.attributeNameCase;
        this.encoding = builder.encoding;
    }

    public static HtmlParserConfig defaults() {
        return DEFAULT_CONFIG;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public boolean isAllowSelfClosingTags() {
        return this.allowSelfClosingTags;
    }

    public boolean isAllowSelfClosingIframe() {
        return this.allowSelfClosingIframe;
    }

    public boolean isParseNoScriptContent() {
        return this.parseNoScriptContent;
    }

    public boolean isScriptStripCommentDelims() {
        return this.scriptStripCommentDelims;
    }

    public boolean isStyleStripCommentDelims() {
        return this.styleStripCommentDelims;
    }

    public @Nullable String getElementNameCase() {
        return this.elementNameCase;
    }

    public @Nullable String getAttributeNameCase() {
        return this.attributeNameCase;
    }

    public @Nullable String getEncoding() {
        return this.encoding;
    }

    public static final class Builder {
        private boolean reportErrors = false;
        private boolean allowSelfClosingTags = false;
        private boolean allowSelfClosingIframe = false;
        private boolean parseNoScriptContent = true;
        private boolean scriptStripCommentDelims = false;
        private boolean styleStripCommentDelims = false;
        private @Nullable String elementNameCase = null;
        private @Nullable String attributeNameCase = null;
        private @Nullable String encoding = null;

        private Builder() {
        }

        public Builder reportErrors(boolean reportErrors) {
            this.reportErrors = reportErrors;
            return this;
        }

        public Builder allowSelfClosingTags(boolean allowSelfClosingTags) {
            this.allowSelfClosingTags = allowSelfClosingTags;
            return this;
        }

        public Builder allowSelfClosingIframe(boolean allowSelfClosingIframe) {
            this.allowSelfClosingIframe = allowSelfClosingIframe;
            return this;
        }

        public Builder parseNoScriptContent(boolean parseNoScriptContent) {
            this.parseNoScriptContent = parseNoScriptContent;
            return this;
        }

        public Builder scriptStripCommentDelims(boolean scriptStripCommentDelims) {
            this.scriptStripCommentDelims = scriptStripCommentDelims;
            return this;
        }

        public Builder styleStripCommentDelims(boolean styleStripCommentDelims) {
            this.styleStripCommentDelims = styleStripCommentDelims;
            return this;
        }

        public Builder elementNameCase(@Nullable String elementNameCase) {
            this.elementNameCase = elementNameCase;
            return this;
        }

        public Builder attributeNameCase(@Nullable String attributeNameCase) {
            this.attributeNameCase = attributeNameCase;
            return this;
        }

        public Builder encoding(@Nullable String encoding) {
            this.encoding = encoding;
            return this;
        }

        public HtmlParserConfig build() {
            return new HtmlParserConfig(this);
        }
    }
}

