/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.render;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.css.style.CssContext;
import org.openpdf.layout.LayoutContext;
import org.openpdf.layout.Styleable;
import org.openpdf.render.BlockBox;
import org.openpdf.render.Box;
import org.openpdf.render.InlineBox;
import org.w3c.dom.Element;

public final class AnonymousBlockBox
extends BlockBox {
    private final List<InlineBox> _openInlineBoxes;

    public AnonymousBlockBox(Element element, CalculatedStyle style, List<InlineBox> savedParents, List<Styleable> inlineContent) {
        super(element, style, true);
        this._openInlineBoxes = savedParents;
        this.setChildrenContentType(BlockBox.ContentType.INLINE);
        this.setInlineContent(inlineContent);
    }

    @Override
    public void layout(LayoutContext c) {
        this.layoutInlineChildren(c, 0, this.calcInitialBreakAtLine(c), true);
    }

    @Override
    public int getContentWidth() {
        return this.getContainingBlock().getContentWidth();
    }

    @Override
    @CheckReturnValue
    public @Nullable Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        Box result = super.find(cssCtx, absX, absY, findAnonymous);
        if (!findAnonymous && result == this) {
            return this.getParent();
        }
        return result;
    }

    public List<InlineBox> getOpenInlineBoxes() {
        return this._openInlineBoxes;
    }

    @Override
    public boolean isSkipWhenCollapsingMargins() {
        for (Styleable styleable : this.getInlineContent()) {
            CalculatedStyle style = styleable.getStyle();
            if (style.isFloated() || style.isAbsolute() || style.isFixed() || style.isRunning()) continue;
            return false;
        }
        return true;
    }

    public void provideSiblingMarginToFloats(int margin) {
        for (Styleable styleable : this.getInlineContent()) {
            BlockBox b;
            if (!(styleable instanceof BlockBox) || !(b = (BlockBox)styleable).isFloated()) continue;
            b.getFloatedBoxData().setMarginFromSibling(margin);
        }
    }

    @Override
    public boolean isMayCollapseMarginsWithChildren() {
        return false;
    }

    @Override
    public void styleText(LayoutContext c) {
        this.styleText(c, this.getParent().getStyle());
    }

    @Override
    public BlockBox copyOf() {
        throw new IllegalArgumentException("cannot be copied");
    }
}

