/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.parser.property;

import java.util.ArrayList;
import java.util.List;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.parser.CSSParseException;
import org.openpdf.css.parser.PropertyValue;
import org.openpdf.css.parser.property.AbstractPropertyBuilder;
import org.openpdf.css.parser.property.PrimitivePropertyBuilders;
import org.openpdf.css.sheet.PropertyDeclaration;
import org.openpdf.css.sheet.StylesheetInfo;
import org.w3c.dom.css.CSSPrimitiveValue;

public class ListStylePropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.LIST_STYLE_TYPE, CSSName.LIST_STYLE_POSITION, CSSName.LIST_STYLE_IMAGE};

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<? extends CSSPrimitiveValue> values, StylesheetInfo.Origin origin, boolean important, boolean inheritAllowed) {
        List<PropertyDeclaration> inherited = this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
        if (inherited != null) {
            return inherited;
        }
        PropertyDeclaration listStyleType = null;
        PropertyDeclaration listStylePosition = null;
        PropertyDeclaration listStyleImage = null;
        for (CSSPrimitiveValue cSSPrimitiveValue : values) {
            PropertyValue value = (PropertyValue)cSSPrimitiveValue;
            this.checkInheritAllowed(value, false);
            short type = value.getPrimitiveType();
            if (type == 21) {
                IdentValue ident = this.checkIdent(value);
                if (ident == IdentValue.NONE) {
                    if (listStyleType == null) {
                        listStyleType = new PropertyDeclaration(CSSName.LIST_STYLE_TYPE, value, important, origin);
                    }
                    if (listStyleImage != null) continue;
                    listStyleImage = new PropertyDeclaration(CSSName.LIST_STYLE_IMAGE, value, important, origin);
                    continue;
                }
                if (PrimitivePropertyBuilders.LIST_STYLE_POSITIONS.get(ident.FS_ID)) {
                    if (listStylePosition != null) {
                        throw new CSSParseException("A list-style-position value cannot be set twice", -1);
                    }
                    listStylePosition = new PropertyDeclaration(CSSName.LIST_STYLE_POSITION, value, important, origin);
                    continue;
                }
                if (!PrimitivePropertyBuilders.LIST_STYLE_TYPES.get(ident.FS_ID)) continue;
                if (listStyleType != null) {
                    throw new CSSParseException("A list-style-type value cannot be set twice", -1);
                }
                listStyleType = new PropertyDeclaration(CSSName.LIST_STYLE_TYPE, value, important, origin);
                continue;
            }
            if (type != 20) continue;
            if (listStyleImage != null) {
                throw new CSSParseException("A list-style-image value cannot be set twice", -1);
            }
            listStyleImage = new PropertyDeclaration(CSSName.LIST_STYLE_IMAGE, value, important, origin);
        }
        ArrayList<PropertyDeclaration> result = new ArrayList<PropertyDeclaration>(3);
        if (listStyleType != null) {
            result.add(listStyleType);
        }
        if (listStylePosition != null) {
            result.add(listStylePosition);
        }
        if (listStyleImage != null) {
            result.add(listStyleImage);
        }
        return result;
    }
}

