/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.pdf;

import java.awt.Rectangle;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.parser.FSColor;
import org.openpdf.css.parser.FSRGBColor;
import org.openpdf.layout.LayoutContext;
import org.openpdf.pdf.AbstractFormField;
import org.openpdf.pdf.ITextOutputDevice;
import org.openpdf.pdf.ITextReplacedElementFactory;
import org.openpdf.render.BlockBox;
import org.openpdf.render.Box;
import org.openpdf.render.PageBox;
import org.openpdf.render.RenderingContext;
import org.openpdf.text.pdf.PdfAnnotation;
import org.openpdf.text.pdf.PdfAppearance;
import org.openpdf.text.pdf.PdfBorderDictionary;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfFormField;
import org.openpdf.text.pdf.PdfTemplate;
import org.openpdf.text.pdf.PdfWriter;
import org.w3c.dom.Element;

public final class RadioButtonFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "RadioButton";
    private final ITextReplacedElementFactory _factory;
    private final Box _box;

    @Override
    protected String getFieldType() {
        return FIELD_TYPE;
    }

    public RadioButtonFormField(ITextReplacedElementFactory factory, LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this._factory = factory;
        this._box = box;
        this.initDimensions(c, box, cssWidth, cssHeight);
    }

    @Override
    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        String fieldName = this.getFieldName(outputDevice, box.getElement());
        List<RadioButtonFormField> radioBoxes = this._factory.getRadioButtons(fieldName);
        if (radioBoxes == null) {
            return;
        }
        PdfContentByte cb = outputDevice.getCurrentPage();
        PdfWriter writer = outputDevice.getWriter();
        PdfFormField group = PdfFormField.createRadioButton((PdfWriter)writer, (boolean)true);
        group.setFieldName(fieldName);
        RadioButtonFormField checked = this.getChecked(radioBoxes);
        if (checked != null) {
            group.setValueAsString(this.getValue(checked.getBox().getElement()));
        }
        for (RadioButtonFormField fieldElem : radioBoxes) {
            this.createField(c, outputDevice, cb, writer, group, fieldElem, checked);
        }
        writer.addAnnotation((PdfAnnotation)group);
        this._factory.remove(fieldName);
    }

    private @Nullable RadioButtonFormField getChecked(List<RadioButtonFormField> fields) {
        for (RadioButtonFormField f : fields) {
            if (!this.isChecked(f.getBox().getElement())) continue;
            return f;
        }
        return null;
    }

    private void createField(RenderingContext c, ITextOutputDevice outputDevice, PdfContentByte cb, PdfWriter writer, PdfFormField group, RadioButtonFormField fieldElem, RadioButtonFormField checked) {
        Box box = fieldElem.getBox();
        Element e = box.getElement();
        String onValue = this.getValue(e);
        float width = outputDevice.getDeviceLength(fieldElem.getWidth());
        float height = outputDevice.getDeviceLength(fieldElem.getHeight());
        PdfFormField field = PdfFormField.createEmpty((PdfWriter)writer);
        FSColor color = box.getStyle().getColor();
        FSRGBColor darker = new FSRGBColor(255, 255, 255);
        this.createAppearances(cb, field, onValue, width, height, true, color, darker);
        this.createAppearances(cb, field, onValue, width, height, false, color, darker);
        field.setWidget(outputDevice.createTargetArea(c, box), PdfAnnotation.HIGHLIGHT_INVERT);
        Rectangle bounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), c);
        PageBox page = c.getRootLayer().getPage(c, bounds.y);
        field.setPlaceInPage(page.getPageNo() + 1);
        field.setBorderStyle(new PdfBorderDictionary(0.0f, 0));
        field.setAppearanceState(fieldElem == checked ? onValue : "Off");
        if (this.isReadOnly(e)) {
            field.setFieldFlags(1);
        }
        group.addKid(field);
    }

    private void createAppearances(PdfContentByte cb, PdfFormField field, String onValue, float width, float height, boolean normal, FSColor color, FSColor darker) {
        PdfAppearance tpOff = cb.createAppearance(width, height);
        PdfAppearance tpOn = cb.createAppearance(width, height);
        float diameter = Math.min(width, height);
        this.setStrokeColor((PdfTemplate)tpOff, color);
        this.setStrokeColor((PdfTemplate)tpOn, color);
        if (!normal) {
            this.setStrokeColor((PdfTemplate)tpOff, darker);
            this.setStrokeColor((PdfTemplate)tpOn, darker);
        }
        float strokeWidth = Math.max(1.0f, this.reduce(diameter));
        tpOff.setLineWidth(strokeWidth);
        tpOn.setLineWidth(strokeWidth);
        tpOff.circle(width / 2.0f, height / 2.0f, diameter / 2.0f - strokeWidth / 2.0f);
        tpOn.circle(width / 2.0f, height / 2.0f, diameter / 2.0f - strokeWidth / 2.0f);
        if (!normal) {
            tpOff.fillStroke();
            tpOn.fillStroke();
        } else {
            tpOff.stroke();
            tpOn.stroke();
        }
        this.setFillColor((PdfTemplate)tpOn, color);
        if (!normal) {
            tpOn.circle(width / 2.0f, height / 2.0f, diameter * 0.23f);
        } else {
            tpOn.circle(width / 2.0f, height / 2.0f, diameter * 0.2f);
        }
        tpOn.fill();
        if (normal) {
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", (PdfTemplate)tpOff);
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, onValue, (PdfTemplate)tpOn);
        } else {
            field.setAppearance(PdfAnnotation.APPEARANCE_DOWN, "Off", (PdfTemplate)tpOff);
            field.setAppearance(PdfAnnotation.APPEARANCE_DOWN, onValue, (PdfTemplate)tpOn);
        }
    }

    private float reduce(float value) {
        return Math.min(value, Math.max(1.0f, 0.05f * value));
    }

    @Override
    public void detach(LayoutContext c) {
        super.detach(c);
        this._factory.remove(this._box.getElement());
    }

    public Box getBox() {
        return this._box;
    }

    @Override
    public int getBaseline() {
        return 0;
    }

    @Override
    public boolean hasBaseline() {
        return false;
    }
}

