/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.render;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Rectangle;
import org.jspecify.annotations.Nullable;
import org.openpdf.context.StyleReference;
import org.openpdf.css.style.CssContext;
import org.openpdf.css.value.FontSpecification;
import org.openpdf.extend.FSCanvas;
import org.openpdf.extend.FontContext;
import org.openpdf.extend.FontResolver;
import org.openpdf.extend.OutputDevice;
import org.openpdf.extend.TextRenderer;
import org.openpdf.extend.UserAgentCallback;
import org.openpdf.layout.Layer;
import org.openpdf.layout.SharedContext;
import org.openpdf.render.Box;
import org.openpdf.render.FSFont;
import org.openpdf.render.FSFontMetrics;
import org.openpdf.render.PageBox;

public class RenderingContext
implements CssContext {
    protected final SharedContext sharedContext;
    private final OutputDevice outputDevice;
    private final FontContext fontContext;
    private int pageCount;
    private int pageNo;
    private @Nullable PageBox page;
    private final @Nullable Layer rootLayer;
    private final int initialPageNo;

    public RenderingContext(SharedContext sharedContext, OutputDevice outputDevice, FontContext fontContext, @Nullable Layer rootLayer, int initialPageNo) {
        this.sharedContext = sharedContext;
        this.outputDevice = outputDevice;
        this.fontContext = fontContext;
        this.rootLayer = rootLayer;
        this.initialPageNo = initialPageNo;
    }

    public UserAgentCallback getUac() {
        return this.sharedContext.getUac();
    }

    public String getBaseURL() {
        return this.sharedContext.getBaseURL();
    }

    public float getDPI() {
        return this.sharedContext.getDPI();
    }

    @Override
    public float getMmPerDot() {
        return this.sharedContext.getMmPerPx();
    }

    @Override
    public int getDotsPerPixel() {
        return this.sharedContext.getDotsPerPixel();
    }

    @Override
    public float getFontSize2D(FontSpecification font) {
        return this.sharedContext.getFont(font).getSize2D();
    }

    @Override
    public float getXHeight(FontSpecification parentFont) {
        return this.sharedContext.getXHeight(this.getFontContext(), parentFont);
    }

    public TextRenderer getTextRenderer() {
        return this.sharedContext.getTextRenderer();
    }

    public boolean isPaged() {
        return this.sharedContext.isPaged();
    }

    public FontResolver getFontResolver() {
        return this.sharedContext.getFontResolver();
    }

    @Override
    @CheckReturnValue
    public @Nullable FSFont getFont(FontSpecification font) {
        return this.sharedContext.getFont(font);
    }

    @CheckReturnValue
    public @Nullable FSCanvas getCanvas() {
        return this.sharedContext.getCanvas();
    }

    public Rectangle getFixedRectangle() {
        Rectangle result = this.isPrint() ? new Rectangle(0, -this.page.getTop(), this.page.getContentWidth(this), this.page.getContentHeight(this) - 1) : this.sharedContext.getFixedRectangle();
        result.translate(-1, -1);
        return result;
    }

    public Rectangle getViewportRectangle() {
        Rectangle result = new Rectangle(this.getFixedRectangle());
        result.y *= -1;
        return result;
    }

    public boolean debugDrawBoxes() {
        return this.sharedContext.debugDrawBoxes();
    }

    public boolean debugDrawLineBoxes() {
        return this.sharedContext.debugDrawLineBoxes();
    }

    public boolean debugDrawInlineBoxes() {
        return this.sharedContext.debugDrawInlineBoxes();
    }

    public boolean debugDrawFontMetrics() {
        return this.sharedContext.debugDrawFontMetrics();
    }

    public boolean isInteractive() {
        return this.sharedContext.isInteractive();
    }

    public boolean isPrint() {
        return this.sharedContext.isPrint();
    }

    public OutputDevice getOutputDevice() {
        return this.outputDevice;
    }

    public FontContext getFontContext() {
        return this.fontContext;
    }

    public void setPage(int pageNo, PageBox page) {
        this.pageNo = pageNo;
        this.page = page;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public @Nullable PageBox getPage() {
        return this.page;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    @Override
    @CheckReturnValue
    public StyleReference getCss() {
        return this.sharedContext.getCss();
    }

    @Override
    @CheckReturnValue
    public FSFontMetrics getFSFontMetrics(FSFont font) {
        return this.getTextRenderer().getFSFontMetrics(this.getFontContext(), font, "");
    }

    public @Nullable Layer getRootLayer() {
        return this.rootLayer;
    }

    public int getInitialPageNo() {
        return this.initialPageNo;
    }

    @CheckReturnValue
    public @Nullable Box getBoxById(String id) {
        return this.sharedContext.getBoxById(id);
    }
}

