/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.style.derived;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.parser.FSColor;
import org.openpdf.css.parser.FSFunction;
import org.openpdf.css.parser.FSRGBColor;
import org.openpdf.css.parser.PropertyValue;
import org.openpdf.css.parser.property.BuilderUtil;
import org.openpdf.css.parser.property.Conversions;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.css.style.CssContext;
import org.openpdf.css.style.derived.LengthValue;
import org.openpdf.util.GeneralUtil;

public class FSLinearGradient {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private final List<StopValue> stopPoints = new ArrayList<StopValue>(2);

    public List<StopValue> getStopPoints() {
        return this.stopPoints;
    }

    private float deg2rad(float deg) {
        return (float)Math.toRadians(deg);
    }

    private float rad2deg(float rad) {
        return (float)Math.toDegrees(rad);
    }

    private void endPointsFromAngle(float angleDeg, int w, int h) {
        float yEnd;
        float xEnd;
        if ((angleDeg %= 360.0f) < 0.0f) {
            angleDeg += 360.0f;
        }
        if (angleDeg == 0.0f) {
            this.x1 = 0;
            this.y1 = h;
            this.x2 = 0;
            this.y2 = 0;
            return;
        }
        if (angleDeg == 90.0f) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = w;
            this.y2 = 0;
            return;
        }
        if (angleDeg == 180.0f) {
            this.x1 = 0;
            this.y1 = 0;
            this.x2 = 0;
            this.y2 = h;
            return;
        }
        if (angleDeg == 270.0f) {
            this.x1 = w;
            this.y1 = 0;
            this.x2 = 0;
            this.y2 = 0;
            return;
        }
        float slope = (float)Math.tan(this.deg2rad(90.0f - angleDeg));
        float perpendicularSlope = -1.0f / slope;
        float halfHeight = (float)h / 2.0f;
        float halfWidth = (float)w / 2.0f;
        if (angleDeg < 90.0f) {
            xEnd = halfWidth;
            yEnd = halfHeight;
        } else if (angleDeg < 180.0f) {
            xEnd = halfWidth;
            yEnd = -halfHeight;
        } else if (angleDeg < 270.0f) {
            xEnd = -halfWidth;
            yEnd = -halfHeight;
        } else {
            xEnd = -halfWidth;
            yEnd = halfHeight;
        }
        float c = yEnd - perpendicularSlope * xEnd;
        float endX = c / (slope - perpendicularSlope);
        float endY = perpendicularSlope * endX + c;
        this.x2 = (int)(halfWidth + endX);
        this.y2 = (int)(halfHeight - endY);
        this.x1 = (int)(halfWidth - endX);
        this.y1 = (int)(halfHeight + endY);
    }

    private void constructZero() {
        this.x1 = 0;
        this.y1 = 0;
        this.x2 = 1;
        this.y2 = 0;
        this.stopPoints.clear();
        this.stopPoints.add(new StopValue(new FSRGBColor(0, 0, 0, 0.0f)));
        this.stopPoints.add(new StopValue(new FSRGBColor(0, 0, 0, 1.0E-4f)));
        this.stopPoints.get((int)0).dotsValue = Float.valueOf(0.0f);
        this.stopPoints.get((int)1).dotsValue = Float.valueOf(1.0f);
    }

    public static boolean looksLikeALength(String val) {
        String[] units;
        if (val.isEmpty()) {
            return false;
        }
        if ("0".equals(val = val.trim())) {
            return true;
        }
        for (String unit : units = new String[]{"em", "ex", "px", "cm", "mm", "in", "pt", "pc", "%"}) {
            if (!val.endsWith(unit)) continue;
            String numberPart = val.substring(0, val.length() - unit.length());
            try {
                Double.parseDouble(numberPart);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean looksLikeABGPosition(String val) {
        ArrayList<String> BACKGROUND_POSITIONS_IDENTS = new ArrayList<String>();
        BACKGROUND_POSITIONS_IDENTS.add("top");
        BACKGROUND_POSITIONS_IDENTS.add("center");
        BACKGROUND_POSITIONS_IDENTS.add("bottom");
        BACKGROUND_POSITIONS_IDENTS.add("right");
        BACKGROUND_POSITIONS_IDENTS.add("left");
        return BACKGROUND_POSITIONS_IDENTS.contains(val) || FSLinearGradient.looksLikeALength(val);
    }

    /*
     * Enabled aggressive block sorting
     */
    public FSLinearGradient(FSFunction func, CalculatedStyle style, int width, int height, CssContext ctx) {
        int i;
        List<PropertyValue> params = func.getParameters();
        if (params.isEmpty()) {
            this.constructZero();
            return;
        }
        if (!GeneralUtil.ciEquals(params.get(0).getStringValue(), "to")) {
            if (params.get(0).getPrimitiveType() == 11) {
                this.endPointsFromAngle(params.get(0).getFloatValue(), width, height);
            } else {
                if (params.get(0).getPrimitiveType() != 12) {
                    this.constructZero();
                    return;
                }
                this.endPointsFromAngle(this.rad2deg(params.get(0).getFloatValue()), width, height);
            }
        } else {
            for (i = 1; i < params.size() && params.get(i).getStringValue() != null && FSLinearGradient.looksLikeABGPosition(params.get(i).getStringValue()); ++i) {
            }
            List<Object> positions = Collections.emptyList();
            if (i == 2) {
                positions = Collections.singletonList(params.get(1).getStringValue().toLowerCase(Locale.US));
            } else if (i == 3) {
                positions = Arrays.asList(params.get(1).getStringValue().toLowerCase(Locale.US), params.get(2).getStringValue().toLowerCase(Locale.US));
            }
            if (positions.contains("top") && positions.contains("left")) {
                this.x1 = width;
                this.y1 = height;
                this.x2 = 0;
                this.y2 = 0;
            } else if (positions.contains("top") && positions.contains("right")) {
                this.x1 = 0;
                this.y1 = height;
                this.x2 = width;
                this.y2 = 0;
            } else if (positions.contains("bottom") && positions.contains("left")) {
                this.x1 = width;
                this.y1 = 0;
                this.x2 = 0;
                this.y2 = height;
            } else if (positions.contains("bottom") && positions.contains("right")) {
                this.x1 = 0;
                this.y1 = 0;
                this.x2 = width;
                this.y2 = height;
            } else if (positions.contains("bottom")) {
                this.x1 = 0;
                this.y1 = 0;
                this.x2 = 0;
                this.y2 = height;
            } else if (positions.contains("top")) {
                this.x1 = 0;
                this.y1 = height;
                this.x2 = 0;
                this.y2 = 0;
            } else if (positions.contains("left")) {
                this.x1 = width;
                this.y1 = 0;
                this.x2 = 0;
                this.y2 = 0;
            } else {
                if (!positions.contains("right")) {
                    this.constructZero();
                    return;
                }
                this.x1 = 0;
                this.y1 = 0;
                this.x2 = width;
                this.y2 = 0;
            }
        }
        if (params.size() - i < 2) {
            this.constructZero();
            return;
        }
        while (i < params.size()) {
            FSRGBColor color;
            PropertyValue value = params.get(i);
            switch (value.getPrimitiveType()) {
                case 21: {
                    FSRGBColor fSRGBColor = Conversions.getColor(value.getStringValue());
                    break;
                }
                default: {
                    FSRGBColor fSRGBColor = color = (FSRGBColor)value.getFSColor();
                }
            }
            if (color == null) {
                this.constructZero();
                return;
            }
            if (i + 1 < params.size() && (BuilderUtil.isLength(params.get(i + 1)) || params.get(i + 1).getPrimitiveType() == 2)) {
                PropertyValue val2 = params.get(i + 1);
                this.stopPoints.add(new StopValue(color, Float.valueOf(val2.getFloatValue()), val2.getPrimitiveType()));
                ++i;
            } else {
                this.stopPoints.add(new StopValue(color));
            }
            ++i;
        }
        for (int m = 0; m < this.stopPoints.size(); ++m) {
            StopValue pt = this.stopPoints.get(m);
            if (pt.length != null) {
                pt.dotsValue = Float.valueOf(LengthValue.calcFloatProportionalValue(style, CSSName.BACKGROUND_IMAGE, "", pt.length.floatValue(), pt.lengthType, width, ctx));
                continue;
            }
            if (m == 0) {
                pt.dotsValue = Float.valueOf(0.0f);
                continue;
            }
            if (m != this.stopPoints.size() - 1) continue;
            pt.dotsValue = Float.valueOf(LengthValue.calcFloatProportionalValue(style, CSSName.BACKGROUND_IMAGE, "100%", 100.0f, (short)2, width, ctx));
        }
        float lastValue = 0.0f;
        float nextValue = 100.0f;
        float increment = 0.0f;
        int j = 1;
        while (true) {
            if (j >= this.stopPoints.size()) break;
            if (j + 1 < this.stopPoints.size() && this.stopPoints.get((int)j).dotsValue == null && increment == 0.0f) {
                int k;
                for (k = j + 1; k < this.stopPoints.size(); ++k) {
                    if (this.stopPoints.get((int)k).dotsValue == null) continue;
                    nextValue = this.stopPoints.get((int)k).dotsValue.floatValue();
                    break;
                }
                increment = (nextValue - lastValue) / (float)k;
            }
            if (this.stopPoints.get((int)j).dotsValue != null) {
                increment = 0.0f;
            } else {
                this.stopPoints.get((int)j).dotsValue = Float.valueOf(lastValue + increment);
            }
            lastValue = this.stopPoints.get((int)j).dotsValue.floatValue();
            ++j;
        }
        Collections.sort(this.stopPoints);
        int b = 0;
        while (b < this.stopPoints.size() - 1) {
            if (this.stopPoints.get((int)b).dotsValue.equals(this.stopPoints.get((int)(b + 1)).dotsValue)) {
                this.constructZero();
                return;
            }
            ++b;
        }
        return;
    }

    public int getStartX() {
        return this.x1;
    }

    public int getEndX() {
        return this.x2;
    }

    public int getStartY() {
        return this.y1;
    }

    public int getEndY() {
        return this.y2;
    }

    public String toString() {
        return "[%d, %d] to [%d, %d](%s)".formatted(this.x1, this.y1, this.x2, this.y2, this.stopPoints);
    }

    public static class StopValue
    implements Comparable<StopValue> {
        private final FSColor color;
        private final short lengthType;
        private final @Nullable Float length;
        private @Nullable Float dotsValue;

        private StopValue(FSColor color, Float value, short lengthType) {
            this.color = color;
            this.length = value;
            this.lengthType = lengthType;
        }

        private StopValue(FSColor color) {
            this.color = color;
            this.length = null;
            this.lengthType = 0;
        }

        public FSColor getColor() {
            return this.color;
        }

        public @Nullable Float getLength() {
            return this.length;
        }

        public @Nullable Float getDotsValue() {
            return this.dotsValue;
        }

        public String toString() {
            return "[" + String.valueOf(this.color) + "](" + this.dotsValue + ")";
        }

        @Override
        public int compareTo(StopValue arg0) {
            if (Objects.equals(this.dotsValue, arg0.dotsValue)) {
                return 0;
            }
            if (this.dotsValue.floatValue() < arg0.dotsValue.floatValue()) {
                return -1;
            }
            return 1;
        }
    }
}

