/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.ashley.core;

import com.badlogic.ashley.core.EntitySystem;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.Comparator;

class SystemManager {
    private SystemComparator systemComparator = new SystemComparator();
    private Array<EntitySystem> systems = new Array(true, 16);
    private ImmutableArray<EntitySystem> immutableSystems = new ImmutableArray<EntitySystem>(this.systems);
    private ObjectMap<Class<?>, EntitySystem> systemsByClass = new ObjectMap();
    private SystemListener listener;

    public SystemManager(SystemListener listener) {
        this.listener = listener;
    }

    public void addSystem(EntitySystem system) {
        Class<?> systemType = system.getClass();
        Object oldSytem = this.getSystem(systemType);
        if (oldSytem != null) {
            this.removeSystem((EntitySystem)oldSytem);
        }
        this.systems.add((Object)system);
        this.systemsByClass.put(systemType, (Object)system);
        this.systems.sort((Comparator)this.systemComparator);
        this.listener.systemAdded(system);
    }

    public void removeSystem(EntitySystem system) {
        if (this.systems.removeValue((Object)system, true)) {
            this.systemsByClass.remove(system.getClass());
            this.listener.systemRemoved(system);
        }
    }

    public void removeAllSystems() {
        while (this.systems.size > 0) {
            this.removeSystem((EntitySystem)this.systems.first());
        }
    }

    public <T extends EntitySystem> T getSystem(Class<T> systemType) {
        return (T)((EntitySystem)this.systemsByClass.get(systemType));
    }

    public ImmutableArray<EntitySystem> getSystems() {
        return this.immutableSystems;
    }

    static interface SystemListener {
        public void systemAdded(EntitySystem var1);

        public void systemRemoved(EntitySystem var1);
    }

    private static class SystemComparator
    implements Comparator<EntitySystem> {
        private SystemComparator() {
        }

        @Override
        public int compare(EntitySystem a, EntitySystem b) {
            return a.priority > b.priority ? 1 : (a.priority == b.priority ? 0 : -1);
        }
    }
}

