/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaomengge.service.base_framework.listener;

import com.github.liaomengge.base_common.support.misc.consts.ToolConst;
import com.github.liaomengge.service.base_framework.helper.EndpointHelper;
import com.github.liaomengge.service.base_framework.util.PrintLayoutUtil;
import com.taobao.text.ui.TableElement;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class BaseWebServerInitializedListener {
    private static final String INFO_ENDPOINT = "info";
    private static final String HTTP_PREFIX = "http://";
    private final EndpointHelper endpointHelper;

    @Order(value=-2147483648)
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterWebInitialize(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        if (this.isDevOrTestEnv(context)) {
            List<String> endpoints;
            ServerProperties serverProperties = (ServerProperties)context.getBean(ServerProperties.class);
            WebEndpointProperties webEndpointProperties = (WebEndpointProperties)context.getBean(WebEndpointProperties.class);
            String serverContextPath = (String)StringUtils.defaultIfBlank((CharSequence)serverProperties.getServlet().getContextPath(), (CharSequence)"");
            String endpointBasePath = (String)StringUtils.defaultIfBlank((CharSequence)webEndpointProperties.getBasePath(), (CharSequence)"");
            String applicationName = context.getEnvironment().getProperty("spring.application.name");
            Object[] activeProfiles = context.getEnvironment().getActiveProfiles();
            if (ArrayUtils.isEmpty((Object[])activeProfiles)) {
                activeProfiles = context.getEnvironment().getDefaultProfiles();
            }
            if (CollectionUtils.isNotEmpty(endpoints = this.endpointHelper.discoverEndpoints())) {
                System.out.println("ENABLED ENDPOINTS ===> " + ToolConst.JOINER.join(endpoints));
            }
            StringBuilder sBuilder = new StringBuilder(16);
            sBuilder.append("\n");
            sBuilder.append("---------------------------------------------------------------------------").append("\n");
            TableElement tableElement = PrintLayoutUtil.buildTableStyle();
            PrintLayoutUtil.addRowElement(tableElement, "APPLICATION NAME: ", applicationName);
            PrintLayoutUtil.addRowElement(tableElement, "ACTIVE PROFILES: ", ToolConst.JOINER.join(activeProfiles));
            if (endpoints.contains(INFO_ENDPOINT)) {
                String infoUrl = HTTP_PREFIX + this.getIpAndPort(event) + serverContextPath + endpointBasePath + "/info";
                PrintLayoutUtil.addRowElement(tableElement, "INFO URL: ", infoUrl);
            }
            if (ClassUtils.isPresent((String)"springfox.documentation.spring.web.plugins.Docket", null)) {
                String swaggerUrl = HTTP_PREFIX + this.getIpAndPort(event) + serverContextPath + "/doc.html";
                PrintLayoutUtil.addRowElement(tableElement, "SWAGGER URL: ", swaggerUrl);
            }
            sBuilder.append(PrintLayoutUtil.render(tableElement));
            sBuilder.append("---------------------------------------------------------------------------").append("\n");
            System.out.println(sBuilder.toString());
        }
    }

    private String getIpAndPort(WebServerInitializedEvent event) {
        int port = event.getWebServer().getPort();
        String hostAddress = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostAddress = address.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostAddress = (String)StringUtils.defaultIfBlank((CharSequence)hostAddress, (CharSequence)"localhost");
        return hostAddress + ":" + port;
    }

    private boolean isDevOrTestEnv(WebServerApplicationContext ctx) {
        Object[] activeProfiles = ctx.getEnvironment().getActiveProfiles();
        if (ArrayUtils.isNotEmpty((Object[])activeProfiles)) {
            return Arrays.stream(activeProfiles).anyMatch(val -> StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"dev") || StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"test") || StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)"fat"));
        }
        return true;
    }

    public BaseWebServerInitializedListener(EndpointHelper endpointHelper) {
        this.endpointHelper = endpointHelper;
    }
}

