/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.context.Hyperlink;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XSSFSheetPreXMLHandler
extends DefaultHandler {
    private final XSSFPreData xssfPreData = new XSSFPreData();
    private final SaxExcelReader.ReadConfig<?> readConfig;
    private final SaxExcelReader.XSSFReadContext xssfReadContext;

    public XSSFSheetPreXMLHandler(SaxExcelReader.ReadConfig<?> readConfig, SaxExcelReader.XSSFReadContext xssfReadContext) {
        this.readConfig = readConfig;
        this.xssfReadContext = xssfReadContext;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.readConfig.detectedMerge) {
            this.doProcessMerge(uri, localName, attributes);
        }
        if (this.readConfig.detectedHyperlink()) {
            this.doProcessHyperlink(attributes);
        }
    }

    private void doProcessMerge(String uri, String localName, Attributes attributes) {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("mergeCell".equals(localName) || "x:mergeCell".equals(localName)) {
            String range = attributes.getValue("ref");
            Iterator iterator = CellRangeAddress.valueOf((String)range).iterator();
            CellAddress firstCellAddress = null;
            while (iterator.hasNext()) {
                CellAddress cellAddress = (CellAddress)iterator.next();
                if (firstCellAddress == null) {
                    firstCellAddress = cellAddress;
                    continue;
                }
                this.xssfPreData.mergeCellMapping.put(cellAddress, firstCellAddress);
            }
        }
    }

    private void doProcessHyperlink(Attributes attributes) {
        String ref = attributes.getValue("ref");
        if (StringUtils.isEmpty((CharSequence)ref)) {
            return;
        }
        String location = attributes.getValue("location");
        if (location != null) {
            Hyperlink hyperlink = new Hyperlink(location, null, null);
            this.xssfPreData.hyperlinkMapping.put(new CellAddress(ref), hyperlink);
            return;
        }
        String rId = attributes.getValue("r:id");
        if (rId == null || this.xssfReadContext.packageRelationshipCollection == null) {
            return;
        }
        Optional.ofNullable(this.xssfReadContext.packageRelationshipCollection.getRelationshipByID(rId)).map(PackageRelationship::getTargetURI).ifPresent(uri -> {
            Hyperlink hyperlink = new Hyperlink(uri.toString(), null, null);
            this.xssfPreData.hyperlinkMapping.put(new CellAddress(ref), hyperlink);
        });
    }

    public XSSFPreData getXssfPreData() {
        return this.xssfPreData;
    }

    public static class XSSFPreData {
        public Map<CellAddress, CellAddress> mergeCellMapping = new HashMap<CellAddress, CellAddress>();
        public Map<CellAddress, Hyperlink> hyperlinkMapping = new HashMap<CellAddress, Hyperlink>();
    }
}

