/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelFactory;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.parser.StyleParser;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.utils.FileExportUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HtmlToExcelStreamFactory
extends AbstractExcelFactory {
    private static final Tr STOP_FLAG = new Tr(-1, 0);
    private static final Logger log = LoggerFactory.getLogger(HtmlToExcelStreamFactory.class);
    private int maxRowCountOfSheet = 0x100000;
    private Sheet sheet;
    private boolean stop;
    private volatile boolean exception;
    private long startTime;
    private String sheetName = "Sheet";
    private Map<Integer, Integer> colWidthMap = new HashMap<Integer, Integer>();
    private int rowNum;
    private int sheetNum;
    private int maxColIndex;
    private int count;
    private List<Tr> titles;
    private final List<Path> tempFilePaths = new ArrayList<Path>();
    private final List<CompletableFuture<Void>> futures = new LinkedList<CompletableFuture<Void>>();
    volatile Thread receiveThread;
    private final HtmlToExcelStreamFactoryContext context;
    private volatile boolean consumeFinished = false;

    public HtmlToExcelStreamFactory(HtmlToExcelStreamFactoryContext context) {
        this.context = context;
    }

    public void start(Table table, Workbook workbook) {
        log.info("Start build excel");
        if (workbook != null) {
            this.workbook = workbook;
        }
        this.startTime = System.currentTimeMillis();
        if (table != null && table.caption != null) {
            this.sheetName = table.caption;
        }
        Thread thread = new Thread(this::receive);
        thread.setName("myexcel-exec-" + thread.getId());
        thread.start();
    }

    public void appendTitles(List<Tr> trList) {
        this.titles = trList;
        trList.forEach(this::append);
    }

    public void append(Tr tr) {
        if (this.exception) {
            log.error("Received a termination command,an exception occurred while processing");
            throw new UnsupportedOperationException("Received a termination command");
        }
        if (this.stop) {
            log.error("Received a termination command,the build method has been called");
            throw new UnsupportedOperationException("Received a termination command");
        }
        if (tr == null) {
            log.warn("This tr is null and will be discarded");
            return;
        }
        this.putTrToQueue(tr);
    }

    private void receive() {
        try {
            if (this.workbook == null) {
                this.workbookType(WorkbookType.SXLSX);
            }
            if (this.isHssf) {
                this.maxRowCountOfSheet = 65536;
            }
            this.initCellStyle(this.workbook);
            this.receiveThread = Thread.currentThread();
            this.sheet = this.workbook.getSheet(this.sheetName);
            if (this.sheet == null) {
                this.sheet = this.createSheet(this.sheetName);
            } else {
                this.rowNum = this.count = this.sheet.getLastRowNum() + 1;
                if (this.rowNum > 0) {
                    this.context.trWaitQueue.clear();
                }
            }
            Tr tr = this.getTrFromQueue();
            if (this.maxColIndex == 0) {
                int tdSize = tr.tdList.size();
                this.maxColIndex = tdSize > 0 ? tdSize - 1 : 0;
            }
            tr.colWidthMap.forEach((key, value) -> {
                int contentLength = value << 1;
                if (contentLength > 255) {
                    contentLength = 255;
                }
                this.sheet.setColumnWidth(key.intValue(), contentLength << 8);
            });
            this.createNameManager();
            int totalSize = 0;
            while (tr != STOP_FLAG) {
                if (this.context.capacity > 0 && this.count == this.context.capacity) {
                    this.storeToTempFile();
                    this.initNewWorkbook();
                }
                this.createNextSheet();
                this.setTdStyle(tr);
                this.appendRow(tr);
                ++totalSize;
                tr.colWidthMap.forEach((k, v) -> {
                    Integer val = this.colWidthMap.get(k);
                    if (val == null || v > val) {
                        this.colWidthMap.put((Integer)k, (Integer)v);
                    }
                });
                tr = this.getTrFromQueue();
            }
            this.consumeFinished = true;
            log.info("Total size:{}", (Object)totalSize);
        }
        catch (Exception e) {
            this.exception = true;
            this.context.trWaitQueue.clear();
            this.context.trWaitQueue = null;
            this.clear();
            log.error("An exception occurred while processing", (Throwable)e);
            throw new ExcelBuildException("An exception occurred while processing", e);
        }
    }

    private void createNextSheet() {
        if (this.rowNum >= this.maxRowCountOfSheet) {
            ++this.sheetNum;
            this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
            this.colWidthMap = new HashMap<Integer, Integer>();
            this.sheet = this.workbook.getSheet(this.sheetName + " (" + this.sheetNum + ")");
            if (this.sheet == null) {
                this.sheet = this.createSheet(this.sheetName + " (" + this.sheetNum + ")");
                this.rowNum = 0;
                this.setTitles();
            } else {
                this.rowNum = this.sheet.getLastRowNum() + 1;
                this.count += this.rowNum;
                if (this.rowNum == 0) {
                    this.setTitles();
                }
                this.createNextSheet();
            }
        }
    }

    private void setTdStyle(Tr tr) {
        if (tr.fromTemplate) {
            return;
        }
        this.context.styleParser.toggle();
        boolean isCustomWidth = !Objects.equals(tr.colWidthMap, Collections.emptyMap());
        int size = tr.tdList.size();
        for (int i = 0; i < size; ++i) {
            String width;
            Td td = tr.tdList.get(i);
            td.style = td.th ? this.context.styleParser.getTitleStyle("title&" + td.col) : this.context.styleParser.getCellStyle(i, td.tdContentType, td.format);
            if (!isCustomWidth || !StringUtil.isNotBlank(width = td.style.get("width"))) continue;
            tr.colWidthMap.put(i, TdUtil.getValue(width));
        }
    }

    private Tr getTrFromQueue() throws InterruptedException {
        Tr tr = this.context.trWaitQueue.poll(15L, TimeUnit.MINUTES);
        if (tr == null) {
            throw new IllegalStateException("Get tr failure,timeout 15 minutes.");
        }
        return tr;
    }

    @Override
    public Workbook build() {
        this.waiting();
        this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
        log.info("Build Excel success,takes {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        return this.workbook;
    }

    List<Path> buildAsPaths() {
        this.waiting();
        this.storeToTempFile();
        this.futures.forEach(CompletableFuture::join);
        log.info("Build Excel success,takes {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        return this.tempFilePaths.stream().filter(path -> Objects.nonNull(path) && path.toFile().exists()).collect(Collectors.toList());
    }

    protected void waiting() {
        if (this.exception) {
            throw new IllegalStateException("An exception occurred while processing");
        }
        this.stop = true;
        this.putTrToQueue(STOP_FLAG);
        while (!this.consumeFinished) {
            if (!this.exception) continue;
            throw new IllegalThreadStateException("An exception occurred while processing");
        }
    }

    private void putTrToQueue(Tr tr) {
        try {
            boolean putSuccess = this.context.trWaitQueue.offer(tr, 1L, TimeUnit.HOURS);
            if (!putSuccess) {
                throw new IllegalStateException("Put tr to queue failure,timeout 1 hour.");
            }
        }
        catch (InterruptedException e) {
            if (this.receiveThread != null) {
                this.receiveThread.interrupt();
            }
            throw new ExcelBuildException("Put tr to queue failure", e);
        }
    }

    private void storeToTempFile() {
        String suffix = this.isHssf ? ".xls" : ".xlsx";
        Path path = TempFileOperator.createTempFile("s_t_r_p", suffix);
        this.tempFilePaths.add(path);
        try {
            if (this.context.executorService != null) {
                Workbook tempWorkbook = this.workbook;
                Sheet tempSheet = this.sheet;
                Map<Integer, Integer> tempColWidthMap = this.colWidthMap;
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    this.setColWidth(tempColWidthMap, tempSheet, this.maxColIndex);
                    try {
                        this.createEmptySheetIfAbsent(tempWorkbook);
                        FileExportUtil.export(tempWorkbook, path.toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.context.pathConsumer != null) {
                        this.context.pathConsumer.accept(path);
                    }
                }, this.context.executorService);
                this.futures.add(future);
            } else {
                this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
                this.createEmptySheetIfAbsent(this.workbook);
                FileExportUtil.export(this.workbook, path.toFile());
                if (Objects.nonNull(this.context.pathConsumer)) {
                    this.context.pathConsumer.accept(path);
                }
            }
        }
        catch (IOException e) {
            this.clear();
            throw new RuntimeException(e);
        }
    }

    private void createEmptySheetIfAbsent(Workbook tempWorkbook) {
        if (tempWorkbook.getNumberOfSheets() == 0) {
            this.createSheet(this.sheetName);
        }
    }

    private void freezePane(Sheet sheet) {
        if (this.context.fixedTitles && this.titles != null) {
            sheet.createFreezePane(0, this.titles.size());
        }
        if (this.context.freezePane != null) {
            sheet.createFreezePane(this.context.freezePane.colSplit, this.context.freezePane.rowSplit);
        }
    }

    private void initNewWorkbook() {
        this.workbook = null;
        this.workbookType(this.isHssf ? WorkbookType.XLS : WorkbookType.SXLSX);
        this.sheetNum = 0;
        this.rowNum = 0;
        this.count = 0;
        this.colWidthMap = new HashMap<Integer, Integer>();
        this.clearCache();
        this.initCellStyle(this.workbook);
        this.sheet = this.createSheet(this.sheetName);
        if (this.titles == null) {
            return;
        }
        this.setTitles();
    }

    private void setTitles() {
        for (Tr titleTr : this.titles) {
            this.appendRow(titleTr);
        }
    }

    private Sheet createSheet(String sheetName) {
        Sheet sheet = this.workbook.createSheet(sheetName);
        this.freezePane(sheet);
        PrintSetup ps = sheet.getPrintSetup();
        ps.setFitHeight((short)1);
        ps.setFitWidth((short)1);
        this.context.startSheetConsumer.accept(sheet);
        return sheet;
    }

    private void appendRow(Tr tr) {
        tr.index = this.rowNum++;
        tr.tdList.forEach(td -> {
            td.row = this.rowNum;
        });
        ++this.count;
        this.createRow(tr, this.sheet);
    }

    Path buildAsZip(String fileName) {
        this.waiting();
        this.storeToTempFile();
        this.futures.forEach(CompletableFuture::join);
        String suffix = this.isHssf ? ".xls" : ".xlsx";
        Path zipFile = TempFileOperator.createTempFile(fileName, ".zip");
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            int size = this.tempFilePaths.size();
            for (int i = 1; i <= size; ++i) {
                Path path = this.tempFilePaths.get(i - 1);
                ZipEntry zipEntry = new ZipEntry(fileName + " (" + i + ")" + suffix);
                out.putNextEntry(zipEntry);
                out.write(Files.readAllBytes(path));
                out.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
            this.tempFilePaths.clear();
        }
        this.tempFilePaths.add(zipFile);
        return zipFile;
    }

    public void cancel() {
        this.waiting();
        this.clear();
    }

    public void clear() {
        if (this.receiveThread != null && this.receiveThread.isAlive()) {
            this.receiveThread.interrupt();
        }
        this.closeWorkbook();
        TempFileOperator.deleteTempFiles(this.tempFilePaths);
    }

    static class HtmlToExcelStreamFactoryContext {
        BlockingQueue<Tr> trWaitQueue = new LinkedBlockingQueue<Tr>(Math.max(Runtime.getRuntime().availableProcessors() * 10, 100));
        ExecutorService executorService;
        int capacity;
        Consumer<Path> pathConsumer;
        boolean fixedTitles;
        StyleParser styleParser;
        Consumer<Sheet> startSheetConsumer = sheet -> {};
        FreezePane freezePane;

        HtmlToExcelStreamFactoryContext() {
        }
    }
}

