/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ClassFieldContainer {
    private Class<?> clazz;
    private final List<Field> declaredFields = new ArrayList<Field>();
    private final Map<String, Field> fieldMap = new HashMap<String, Field>();
    private ClassFieldContainer parent;

    public Field getFieldByName(String fieldName) {
        return this.getFieldByName(fieldName, this);
    }

    @SafeVarargs
    public final List<Field> getFieldsByAnnotation(Class<? extends Annotation> ... annotationClazzs) {
        Objects.requireNonNull(annotationClazzs);
        ArrayList<Field> annotationFields = new ArrayList<Field>();
        this.getFieldsByAnnotation(this, annotationFields, annotationClazzs);
        return annotationFields;
    }

    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getFieldsByContainer(this, fields);
        return fields;
    }

    private void getFieldsByContainer(ClassFieldContainer classFieldContainer, List<Field> fields) {
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (parentContainer != null) {
            this.getFieldsByContainer(parentContainer, fields);
        }
        this.filterFields(classFieldContainer.getDeclaredFields(), fields);
    }

    @SafeVarargs
    private final void getFieldsByAnnotation(ClassFieldContainer classFieldContainer, List<Field> annotationFieldContainer, Class<? extends Annotation> ... annotationClazzs) {
        ClassFieldContainer parentContainer = classFieldContainer.getParent();
        if (parentContainer != null) {
            this.getFieldsByAnnotation(parentContainer, annotationFieldContainer, annotationClazzs);
        }
        List<Field> annotationFields = classFieldContainer.declaredFields.stream().filter(field -> {
            for (Class annotationClazz : annotationClazzs) {
                boolean isAnnotationPresent = field.isAnnotationPresent(annotationClazz);
                if (!isAnnotationPresent) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        this.filterFields(annotationFields, annotationFieldContainer);
    }

    private void filterFields(List<Field> declaredFields, List<Field> fieldContainer) {
        block0: for (Field field : declaredFields) {
            for (int j = 0; j < fieldContainer.size(); ++j) {
                Field f = fieldContainer.get(j);
                if (!f.getName().equals(field.getName())) continue;
                fieldContainer.set(j, field);
                continue block0;
            }
            fieldContainer.add(field);
        }
    }

    private Field getFieldByName(String fieldName, ClassFieldContainer container) {
        Field field = container.getFieldMap().get(fieldName);
        if (field != null) {
            return field;
        }
        ClassFieldContainer parentContainer = container.getParent();
        if (parentContainer == null) {
            return null;
        }
        return this.getFieldByName(fieldName, parentContainer);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<Field> getDeclaredFields() {
        return this.declaredFields;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public ClassFieldContainer getParent() {
        return this.parent;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setParent(ClassFieldContainer parent) {
        this.parent = parent;
    }
}

