/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractHSSFReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.context.Hyperlink;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.util.CellAddress;

class HSSFPreReadHandler
extends AbstractHSSFReadHandler {
    private final HSSFPreData hssfPreData = new HSSFPreData();

    public HSSFPreReadHandler(File file, SaxExcelReader.ReadConfig<?> readConfig) throws IOException {
        this.readConfig = readConfig;
        this.fs = new POIFSFileSystem(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                ++this.sheetIndex;
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition((List)this.boundSheetRecords);
                }
                this.sheetName = this.orderedBSRs[this.sheetIndex].getSheetname();
                break;
            }
            case 229: {
                if (!this.isSelectedSheet()) {
                    return;
                }
                MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)record;
                int numAreas = mergeCellsRecord.getNumAreas();
                Map mergeCellMapping = this.hssfPreData.mergeCellIndexMapping.computeIfAbsent(this.sheetIndex, k -> new HashMap());
                for (int i = 0; i < numAreas; ++i) {
                    Iterator iterator = mergeCellsRecord.getAreaAt(i).iterator();
                    CellAddress firstCellAddress = null;
                    while (iterator.hasNext()) {
                        CellAddress cellAddress = (CellAddress)iterator.next();
                        if (firstCellAddress == null) {
                            firstCellAddress = cellAddress;
                            continue;
                        }
                        mergeCellMapping.put(cellAddress, firstCellAddress);
                    }
                }
                break;
            }
            case 440: {
                HyperlinkRecord hr = (HyperlinkRecord)record;
                Map hyperlinkMapping = this.hssfPreData.hyperlinkMapping.computeIfAbsent(this.sheetIndex, k -> new HashMap());
                hyperlinkMapping.put(new CellAddress(hr.getFirstRow(), hr.getLastColumn()), new Hyperlink(hr.getAddress(), hr.getLabel(), hr));
                break;
            }
        }
    }

    private boolean isSelectedSheet() {
        if (this.readConfig.readAllSheet) {
            return true;
        }
        if (!this.readConfig.sheetNames.isEmpty()) {
            return this.readConfig.sheetNames.contains(this.sheetName);
        }
        return this.readConfig.sheetIndexs.contains(this.sheetIndex);
    }

    public HSSFPreData getHssfPreData() {
        return this.hssfPreData;
    }

    public static class HSSFPreData {
        public Map<Integer, Map<CellAddress, CellAddress>> mergeCellIndexMapping = new HashMap<Integer, Map<CellAddress, CellAddress>>();
        public Map<Integer, Map<CellAddress, Hyperlink>> hyperlinkMapping = new HashMap<Integer, Map<CellAddress, Hyperlink>>();
    }
}

