/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ExcelFactory;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.DropDownLists;
import com.github.liaochong.myexcel.core.parser.Font;
import com.github.liaochong.myexcel.core.parser.HtmlTableParser;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.strategy.SheetStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.core.style.BackgroundStyle;
import com.github.liaochong.myexcel.core.style.BorderStyle;
import com.github.liaochong.myexcel.core.style.CustomColor;
import com.github.liaochong.myexcel.core.style.FontStyle;
import com.github.liaochong.myexcel.core.style.LinkDefaultCellStyle;
import com.github.liaochong.myexcel.core.style.TdDefaultCellStyle;
import com.github.liaochong.myexcel.core.style.TextAlignStyle;
import com.github.liaochong.myexcel.core.style.ThDefaultCellStyle;
import com.github.liaochong.myexcel.core.style.WordBreakStyle;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import com.github.liaochong.myexcel.utils.ColorUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelFactory
implements ExcelFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExcelFactory.class);
    protected static final int XLSX_MAX_ROW_COUNT = 0x100000;
    protected static final int XLS_MAX_ROW_COUNT = 65536;
    private static Map<String, String> DEFAULT_TD_STYLE;
    private static Map<String, String> DEFAULT_TH_STYLE;
    private static Map<String, String> DEFAULT_LINK_STYLE;
    protected Workbook workbook;
    protected boolean isHssf;
    private Map<Integer, Short> maxTdHeightMap = new HashMap<Integer, Short>();
    private boolean useDefaultStyle;
    private boolean applyDefaultStyle;
    private CustomColor customColor;
    private Map<Map<String, String>, CellStyle> cellStyleMap = new HashMap<Map<String, String>, CellStyle>();
    private Map<HtmlTableParser.HtmlTag, CellStyle> defaultCellStyleMap;
    private Map<String, org.apache.poi.ss.usermodel.Font> fontMap = new HashMap<String, org.apache.poi.ss.usermodel.Font>();
    private FreezePane[] freezePanes;
    protected WidthStrategy widthStrategy = WidthStrategy.NO_AUTO;
    protected SheetStrategy sheetStrategy = SheetStrategy.MULTI_SHEET;
    protected List<Td> stagingTds = new LinkedList<Td>();
    private CreationHelper createHelper;
    private DataFormat format;
    private Map<String, Integer> imageMapping;

    @Override
    public ExcelFactory useDefaultStyle() {
        this.useDefaultStyle = true;
        return this;
    }

    @Override
    public ExcelFactory applyDefaultStyle() {
        this.applyDefaultStyle = true;
        if (DEFAULT_TD_STYLE == null) {
            DEFAULT_TD_STYLE = new HashMap<String, String>(){
                {
                    this.put("text-align", "center");
                    this.put("vertical-align", "center");
                    this.put("border-style", "thin");
                }
            };
            DEFAULT_TH_STYLE = new HashMap<String, String>(DEFAULT_TD_STYLE){
                {
                    this.put("font-weight", "bold");
                }
            };
            DEFAULT_LINK_STYLE = new HashMap<String, String>(DEFAULT_TD_STYLE){
                {
                    this.put("text-decoration", "underline");
                    this.put("color", "blue");
                }
            };
        }
        return this;
    }

    @Override
    public ExcelFactory freezePanes(FreezePane ... freezePanes) {
        this.freezePanes = freezePanes;
        return this;
    }

    @Override
    public ExcelFactory workbookType(WorkbookType workbookType) {
        if (Objects.nonNull(this.workbook)) {
            return this;
        }
        switch (workbookType) {
            case XLS: {
                this.workbook = new HSSFWorkbook();
                this.isHssf = true;
                break;
            }
            case SXLSX: {
                this.workbook = new SXSSFWorkbook(1);
                break;
            }
            default: {
                this.workbook = new XSSFWorkbook();
            }
        }
        return this;
    }

    @Override
    public ExcelFactory widthStrategy(WidthStrategy widthStrategy) {
        this.widthStrategy = widthStrategy;
        return this;
    }

    @Override
    public ExcelFactory sheetStrategy(SheetStrategy sheetStrategy) {
        this.sheetStrategy = sheetStrategy;
        return this;
    }

    protected String getRealSheetName(String sheetName) {
        if (sheetName == null) {
            sheetName = "Sheet";
        }
        Sheet sheet = this.workbook.getSheet(sheetName);
        int sort = 1;
        String realSheetName = sheetName;
        while (sheet != null) {
            realSheetName = sheetName + " (" + sort + ")";
            sheet = this.workbook.getSheet(realSheetName);
            ++sort;
        }
        return realSheetName;
    }

    protected void createRow(Tr tr, Sheet sheet) {
        Row row = sheet.createRow(tr.index);
        if (!tr.visibility) {
            row.setZeroHeight(true);
        }
        this.stagingTds.stream().filter(blankTd -> Objects.equals(blankTd.row, tr.index)).forEach(td -> {
            if (tr.tdList == Collections.EMPTY_LIST) {
                tr.tdList = new LinkedList<Td>();
            }
            tr.tdList.add((Td)td);
        });
        for (Td td2 : tr.tdList) {
            this.createCell(td2, sheet, row);
            if (td2.rowSpan == 0) continue;
            int rowBound = td2.getRowBound();
            for (int i = td2.row + 1; i <= rowBound; ++i) {
                int colBound = td2.getColBound();
                for (int j = td2.col; j <= colBound; ++j) {
                    Td blankTd2 = new Td(i, j);
                    blankTd2.th = td2.th;
                    blankTd2.style = td2.style;
                    this.stagingTds.add(blankTd2);
                }
            }
        }
        this.stagingTds.removeIf(td -> Objects.equals(td.row, tr.index));
        if (tr.height > 0) {
            row.setHeightInPoints((float)tr.height);
        } else if (this.maxTdHeightMap.get(row.getRowNum()) == null) {
            row.setHeightInPoints(row.getHeightInPoints() + 5.0f);
        } else {
            row.setHeightInPoints((float)((short)(this.maxTdHeightMap.get(row.getRowNum()) + 5)));
            this.maxTdHeightMap.remove(row.getRowNum());
        }
    }

    protected void createCell(Td td, Sheet sheet, Row currentRow) {
        Cell cell;
        if (td.formula) {
            cell = currentRow.createCell(td.col, CellType.FORMULA);
            cell.setCellFormula(td.content);
        } else {
            String content = td.content;
            switch (td.tdContentType) {
                case DOUBLE: {
                    cell = currentRow.createCell(td.col, CellType.NUMERIC);
                    if (null == content) break;
                    cell.setCellValue(Double.parseDouble(content));
                    break;
                }
                case DATE: {
                    cell = currentRow.createCell(td.col);
                    if (td.date != null) {
                        cell.setCellValue(td.date);
                        break;
                    }
                    if (td.localDateTime != null) {
                        cell.setCellValue(td.localDateTime);
                        break;
                    }
                    if (td.localDate == null) break;
                    cell.setCellValue(td.localDate);
                    break;
                }
                case BOOLEAN: {
                    cell = currentRow.createCell(td.col, CellType.BOOLEAN);
                    if (null == content) break;
                    cell.setCellValue(Boolean.parseBoolean(content));
                    break;
                }
                case NUMBER_DROP_DOWN_LIST: {
                    cell = currentRow.createCell(td.col, CellType.NUMERIC);
                    String firstEle = this.setDropDownList(td, sheet, content);
                    if (firstEle == null) break;
                    cell.setCellValue(Double.parseDouble(firstEle));
                    break;
                }
                case BOOLEAN_DROP_DOWN_LIST: {
                    cell = currentRow.createCell(td.col, CellType.BOOLEAN);
                    String firstEle = this.setDropDownList(td, sheet, content);
                    if (firstEle == null) break;
                    cell.setCellValue(Boolean.parseBoolean(firstEle));
                    break;
                }
                case DROP_DOWN_LIST: {
                    cell = currentRow.createCell(td.col, CellType.STRING);
                    String firstEle = this.setDropDownList(td, sheet, content);
                    if (firstEle == null) break;
                    cell.setCellValue(firstEle);
                    break;
                }
                case LINK_URL: {
                    cell = this.setLink(td, currentRow, HyperlinkType.URL);
                    break;
                }
                case LINK_EMAIL: {
                    cell = this.setLink(td, currentRow, HyperlinkType.EMAIL);
                    break;
                }
                case IMAGE: {
                    cell = currentRow.createCell(td.col);
                    this.setImage(td, sheet);
                    break;
                }
                default: {
                    cell = currentRow.createCell(td.col, CellType.STRING);
                    cell.setCellValue(content);
                }
            }
            this.setPrompt(td, sheet);
        }
        this.drawingSlant(td, sheet);
        this.setComment(td, sheet, cell);
        this.setCellStyle(currentRow, cell, td);
        if (td.col != td.getColBound()) {
            int colBound = td.getColBound();
            for (int j = td.col + 1; j <= colBound; ++j) {
                cell = currentRow.createCell(j);
                this.setCellStyle(currentRow, cell, td);
            }
        }
        if (td.colSpan > 0 || td.rowSpan > 0) {
            sheet.addMergedRegion(new CellRangeAddress(td.row, td.getRowBound(), td.col, td.getColBound()));
        }
    }

    private void setComment(Td td, Sheet sheet, Cell cell) {
        Drawing drawing;
        if (td.comment == null) {
            return;
        }
        if (this.createHelper == null) {
            this.createHelper = this.workbook.getCreationHelper();
        }
        if ((drawing = sheet.getDrawingPatriarch()) == null) {
            drawing = sheet.createDrawingPatriarch();
        }
        ClientAnchor anchor = this.createHelper.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 2);
        anchor.setRow1(td.row);
        anchor.setRow2(td.getRowBound() + 2);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = this.createHelper.createRichTextString(td.comment.text);
        comment.setString(str);
        comment.setAuthor(td.comment.author);
        cell.setCellComment(comment);
    }

    private void drawingSlant(Td td, Sheet sheet) {
        XSSFDrawing drawing;
        if (td.slant == null) {
            return;
        }
        if (this.isHssf) {
            throw new UnsupportedOperationException("The current workbook does not support setting slashes.");
        }
        if (this.workbook instanceof SXSSFWorkbook) {
            drawing = ((SXSSFSheet)sheet).getDrawingPatriarch();
            if (drawing == null) {
                sheet.createDrawingPatriarch();
                drawing = ((SXSSFSheet)sheet).getDrawingPatriarch();
            }
        } else {
            drawing = ((XSSFSheet)sheet).getDrawingPatriarch();
            if (drawing == null) {
                drawing = ((XSSFSheet)sheet).createDrawingPatriarch();
            }
        }
        if (this.createHelper == null) {
            this.createHelper = this.workbook.getCreationHelper();
        }
        ClientAnchor anchor = this.createHelper.createClientAnchor();
        anchor.setCol1(td.col);
        anchor.setRow1(td.row);
        anchor.setCol2(td.getColBound() + 1);
        anchor.setRow2(td.getRowBound() + 1);
        XSSFSimpleShape shape = drawing.createSimpleShape((XSSFClientAnchor)anchor);
        shape.setShapeType(1);
        shape.setLineWidth(td.slant.lineWidth);
        shape.setLineStyle(td.slant.lineStyle);
        int[] color = ColorUtil.getRGBByColor(td.slant.lineStyleColor);
        shape.setLineStyleColor(color[0], color[1], color[2]);
    }

    private void setPrompt(Td td, Sheet sheet) {
        if (td.promptContainer == null) {
            return;
        }
        if (ContentTypeEnum.isDropdownList(td.tdContentType)) {
            return;
        }
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = dvHelper.createCustomConstraint("BB1");
        CellRangeAddressList addressList = new CellRangeAddressList(td.row, td.getRowBound(), td.col, td.getColBound());
        DataValidation dataValidation = dvHelper.createValidation(constraint, addressList);
        dataValidation.createPromptBox(td.promptContainer.title, td.promptContainer.text);
        dataValidation.setShowPromptBox(true);
        sheet.addValidationData(dataValidation);
    }

    private void setImage(Td td, Sheet sheet) {
        int pictureIdx;
        if (td.file == null && td.fileIs == null) {
            return;
        }
        if (this.createHelper == null) {
            this.createHelper = this.workbook.getCreationHelper();
        }
        if (td.file != null) {
            int format;
            String fileName = td.file.getName();
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
            switch (suffix) {
                case "jpg": 
                case "jpeg": {
                    format = 5;
                    break;
                }
                case "png": {
                    format = 6;
                    break;
                }
                case "dib": {
                    format = 7;
                    break;
                }
                case "emf": {
                    format = 2;
                    break;
                }
                case "pict": {
                    format = 4;
                    break;
                }
                case "wmf": {
                    format = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid image type");
                }
            }
            if (this.imageMapping == null) {
                this.imageMapping = new HashMap<String, Integer>();
            }
            pictureIdx = this.imageMapping.computeIfAbsent(td.file.getAbsolutePath(), s -> {
                try {
                    byte[] bytes = Files.readAllBytes(td.file.toPath());
                    return this.workbook.addPicture(bytes, format);
                }
                catch (IOException e) {
                    logger.error("read image failure", (Throwable)e);
                    throw new ExcelBuildException("read image failure, path:" + td.file.getAbsolutePath(), e);
                }
            });
        } else {
            try {
                InputStream is = FileMagic.prepareToCheckMagic((InputStream)td.fileIs);
                Object object = null;
                try {
                    int format;
                    FileMagic fm = FileMagic.valueOf((InputStream)is);
                    switch (fm) {
                        case JPEG: {
                            format = 5;
                            break;
                        }
                        case PNG: {
                            format = 6;
                            break;
                        }
                        case EMF: {
                            format = 2;
                            break;
                        }
                        case WMF: {
                            format = 3;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid image type");
                        }
                    }
                    pictureIdx = this.workbook.addPicture(IOUtils.toByteArray((InputStream)is), format);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (object != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw new SaxReadException("Fail to get excel magic", throwable);
            }
        }
        ClientAnchor anchor = this.createHelper.createClientAnchor();
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        anchor.setDx1(0);
        anchor.setDy1(0);
        int emuPerMm = 36000;
        anchor.setDx2(this.isHssf ? 1023 : 3600000);
        anchor.setDy2(this.isHssf ? 1023 : 3564000);
        anchor.setCol1(td.col);
        anchor.setRow1(td.row);
        anchor.setCol2(td.getColBound());
        anchor.setRow2(td.getRowBound());
        Drawing drawing = sheet.getDrawingPatriarch();
        if (drawing == null) {
            drawing = sheet.createDrawingPatriarch();
        }
        drawing.createPicture(anchor, pictureIdx);
    }

    private Cell setLink(Td td, Row currentRow, HyperlinkType hyperlinkType) {
        if (StringUtil.isBlank(td.content)) {
            return currentRow.createCell(td.col);
        }
        if (this.createHelper == null) {
            this.createHelper = this.workbook.getCreationHelper();
        }
        Cell cell = currentRow.createCell(td.col, CellType.STRING);
        cell.setCellValue(td.content);
        Hyperlink link = this.createHelper.createHyperlink(hyperlinkType);
        link.setAddress(td.link);
        cell.setHyperlink(link);
        return cell;
    }

    private String setDropDownList(Td td, Sheet sheet, String content) {
        if (content != null && !content.isEmpty()) {
            DataValidation validation;
            String[] list;
            CellRangeAddressList addressList = new CellRangeAddressList(td.row, td.getRowBound(), td.col, td.getColBound());
            DataValidationHelper dvHelper = sheet.getDataValidationHelper();
            if (content.length() <= 250) {
                list = content.split(",");
                DataValidationConstraint dvConstraint = dvHelper.createExplicitListConstraint(list);
                validation = dvHelper.createValidation(dvConstraint, addressList);
            } else {
                DropDownLists.Index index = DropDownLists.getHiddenSheetIndex(content, this.workbook);
                list = new String[]{index.firstLine};
                validation = dvHelper.createValidation(dvHelper.createFormulaListConstraint(index.path), addressList);
            }
            if (td.promptContainer != null) {
                validation.createPromptBox(td.promptContainer.title, td.promptContainer.text);
                validation.setShowPromptBox(true);
            }
            if (validation instanceof XSSFDataValidation) {
                validation.setSuppressDropDownArrow(true);
                validation.setShowErrorBox(true);
            } else {
                validation.setSuppressDropDownArrow(false);
            }
            sheet.addValidationData(validation);
            if (list.length > 0) {
                return list[0];
            }
        }
        return null;
    }

    private void setCellStyle(Row row, Cell cell, Td td) {
        if (this.useDefaultStyle) {
            if (td.th) {
                cell.setCellStyle(this.defaultCellStyleMap.get((Object)HtmlTableParser.HtmlTag.th));
            } else if (ContentTypeEnum.isLink(td.tdContentType)) {
                cell.setCellStyle(this.defaultCellStyleMap.get((Object)HtmlTableParser.HtmlTag.link));
            } else {
                cell.setCellStyle(this.defaultCellStyleMap.get((Object)HtmlTableParser.HtmlTag.td));
            }
        } else {
            short fontSize;
            this.doSetInnerSpan(cell, td);
            if (td.style.isEmpty() && !this.applyDefaultStyle) {
                return;
            }
            String fs = td.style.get("font-size");
            if (fs != null && (fontSize = (short)TdUtil.getValue(fs)) > this.maxTdHeightMap.getOrDefault(row.getRowNum(), (short)12)) {
                this.maxTdHeightMap.put(row.getRowNum(), fontSize);
            }
            if (this.applyDefaultStyle) {
                if (td.th) {
                    DEFAULT_TH_STYLE.forEach((k, v) -> td.style.putIfAbsent((String)k, (String)v));
                } else if (ContentTypeEnum.isLink(td.tdContentType)) {
                    DEFAULT_LINK_STYLE.forEach((k, v) -> td.style.putIfAbsent((String)k, (String)v));
                } else {
                    DEFAULT_TD_STYLE.forEach((k, v) -> td.style.putIfAbsent((String)k, (String)v));
                }
            }
            if (this.cellStyleMap.containsKey(td.style)) {
                cell.setCellStyle(this.cellStyleMap.get(td.style));
                return;
            }
            CellStyle cellStyle = this.workbook.createCellStyle();
            BackgroundStyle.setBackgroundColor(cellStyle, td.style, this.customColor);
            TextAlignStyle.setTextAlign(cellStyle, td.style);
            BorderStyle.setBorder(cellStyle, td.style);
            WordBreakStyle.setWordBreak(cellStyle, td.style);
            String formatStr = td.style.get("format");
            if (formatStr != null) {
                if (this.format == null) {
                    this.format = this.workbook.createDataFormat();
                }
                cellStyle.setDataFormat(this.format.getFormat(formatStr));
            }
            if (td.fonts == null || td.fonts.isEmpty()) {
                FontStyle.setFont(() -> this.workbook.createFont(), cellStyle, td.style, this.fontMap, this.customColor);
            }
            cell.setCellStyle(cellStyle);
            this.cellStyleMap.put(td.style, cellStyle);
        }
    }

    private void doSetInnerSpan(Cell cell, Td td) {
        if (td.fonts == null || td.fonts.isEmpty()) {
            return;
        }
        HSSFRichTextString richText = this.isHssf ? new HSSFRichTextString(td.content) : new XSSFRichTextString(td.content);
        for (Font font : td.fonts) {
            org.apache.poi.ss.usermodel.Font f = FontStyle.getFont(font.style, this.fontMap, () -> this.workbook.createFont(), this.customColor);
            richText.applyFont(font.startIndex, font.endIndex, f);
        }
        cell.setCellValue((RichTextString)richText);
    }

    protected Workbook emptyWorkbook() {
        if (this.workbook == null) {
            this.workbook = new XSSFWorkbook();
        }
        this.workbook.createSheet();
        return this.workbook;
    }

    protected void initCellStyle(Workbook workbook) {
        if (this.useDefaultStyle) {
            this.defaultCellStyleMap = new EnumMap<HtmlTableParser.HtmlTag, CellStyle>(HtmlTableParser.HtmlTag.class);
            this.defaultCellStyleMap.put(HtmlTableParser.HtmlTag.th, new ThDefaultCellStyle().supply(workbook));
            this.defaultCellStyleMap.put(HtmlTableParser.HtmlTag.td, new TdDefaultCellStyle().supply(workbook));
            this.defaultCellStyleMap.put(HtmlTableParser.HtmlTag.link, new LinkDefaultCellStyle().supply(workbook));
        } else if (workbook instanceof HSSFWorkbook) {
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            this.customColor = new CustomColor(true, palette);
        } else {
            this.customColor = new CustomColor();
        }
    }

    protected void freezePane(int tableIndex, Sheet sheet) {
        if (this.freezePanes != null && this.freezePanes.length > tableIndex) {
            FreezePane freezePane = this.freezePanes[tableIndex];
            if (freezePane == null) {
                throw new IllegalStateException("FreezePane is null");
            }
            sheet.createFreezePane(freezePane.colSplit, freezePane.rowSplit);
        }
    }

    protected Map<Integer, Integer> getColMaxWidthMap(List<Tr> trList) {
        if (this.useDefaultStyle) {
            trList.parallelStream().forEach(tr -> tr.tdList.stream().filter(td -> td.th).forEach(th -> {
                int tdWidth = TdUtil.getStringWidth(th.content, 0.25);
                tr.colWidthMap.put(th.col, tdWidth);
            }));
        }
        int mapMaxSize = trList.stream().mapToInt(tr -> tr.colWidthMap.size()).max().orElse(16);
        HashMap<Integer, Integer> colMaxWidthMap = new HashMap<Integer, Integer>(mapMaxSize);
        trList.forEach(tr -> {
            tr.colWidthMap.forEach((k, v) -> {
                Integer width = (Integer)colMaxWidthMap.get(k);
                if (Objects.isNull(width) || v > width) {
                    colMaxWidthMap.put((Integer)k, (Integer)v);
                }
            });
            tr.colWidthMap = null;
        });
        return colMaxWidthMap;
    }

    protected void setColWidth(Map<Integer, Integer> colMaxWidthMap, Sheet sheet, int maxColIndex) {
        if (WidthStrategy.isAutoWidth(this.widthStrategy)) {
            if (sheet instanceof SXSSFSheet) {
                ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
            }
            for (int i = 0; i <= maxColIndex; ++i) {
                sheet.autoSizeColumn(i);
            }
            if (sheet instanceof SXSSFSheet) {
                ((SXSSFSheet)sheet).untrackAllColumnsForAutoSizing();
            }
        } else {
            colMaxWidthMap.forEach((key, value) -> {
                int contentLength = value << 1;
                if (contentLength > 255) {
                    contentLength = 255;
                }
                sheet.setColumnWidth(key.intValue(), contentLength << 8);
            });
        }
    }

    protected void clearCache() {
        this.cellStyleMap = new HashMap<Map<String, String>, CellStyle>();
        this.fontMap = new HashMap<String, org.apache.poi.ss.usermodel.Font>();
        this.maxTdHeightMap = new HashMap<Integer, Short>();
        this.format = null;
        this.createHelper = null;
        this.imageMapping = null;
    }

    protected void closeWorkbook() {
        if (this.workbook == null) {
            return;
        }
        try {
            if (this.workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.workbook).dispose();
            }
            this.workbook.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

