/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.parser;

import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.Font;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.utils.RegexpUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.StyleUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTableParser {
    private static final Logger log = LoggerFactory.getLogger(HtmlTableParser.class);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("^[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE]([-+]?([012]?\\d{1,2}|30[0-7])|-3([01]?[4-9]|[012]?[0-3])))?[dD]?$");
    private static final Pattern LINE_FEED_PATTERN = Pattern.compile("\\\\n");
    private ParseConfig parseConfig;
    private File htmlFile;
    private String html;
    private Map<String, String> defaultLinkStyle = new HashMap<String, String>();
    private XSSFRichTextString spanText;

    private HtmlTableParser() {
        this.defaultLinkStyle.put("color", "blue");
        this.defaultLinkStyle.put("text-decoration", "underline");
    }

    public static HtmlTableParser of(File htmlFile) {
        Objects.requireNonNull(htmlFile);
        HtmlTableParser htmlTableParser = new HtmlTableParser();
        htmlTableParser.htmlFile = htmlFile;
        return htmlTableParser;
    }

    public static HtmlTableParser of(String html) {
        Objects.requireNonNull(html);
        HtmlTableParser htmlTableParser = new HtmlTableParser();
        htmlTableParser.html = html;
        return htmlTableParser;
    }

    public List<Table> getAllTable(ParseConfig parseConfig) throws IOException {
        log.info("Start parsing html file");
        long startTime = System.currentTimeMillis();
        Document document = this.htmlFile != null ? Jsoup.parse((File)this.htmlFile, (String)"UTF-8") : Jsoup.parse((String)this.html, (String)"UTF-8");
        document.outputSettings(new Document.OutputSettings().prettyPrint(false));
        document.select("br").after("\\n");
        document.select("p").before("\\n");
        this.parseConfig = parseConfig;
        Elements tableElements = document.getElementsByTag(HtmlTag.table.name());
        List<Table> result = tableElements.stream().map(tableElement -> {
            Table table = new Table();
            Elements captionElements = tableElement.getElementsByTag(HtmlTag.caption.name());
            if (!captionElements.isEmpty()) {
                table.setCaption(captionElements.first().text());
            }
            this.parseTrOfTable(table, (Element)tableElement, StyleUtil.parseStyle(tableElement));
            return table;
        }).collect(Collectors.toList());
        log.info("Complete html file parsing,takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void parseTrOfTable(Table table, Element tableElement, Map<String, String> tableStyle) {
        ConcurrentHashMap parentStyleMap = new ConcurrentHashMap();
        Elements trElements = tableElement.getElementsByTag(HtmlTag.tr.name());
        HashMap seizeMap = new HashMap();
        List trList = IntStream.range(0, trElements.size()).mapToObj(index -> {
            Map<String, String> upperStyle;
            Element trElement = (Element)trElements.get(index);
            Element parent = trElement.parent();
            if (Objects.equals(parent, tableElement)) {
                upperStyle = tableStyle;
            } else if (parentStyleMap.containsKey(parent)) {
                upperStyle = (Map)parentStyleMap.get(parent);
            } else {
                upperStyle = StyleUtil.mixStyle(tableStyle, StyleUtil.parseStyle(parent));
                parentStyleMap.putIfAbsent(parent, upperStyle);
            }
            Map<String, String> trStyleMap = StyleUtil.mixStyle(upperStyle, StyleUtil.parseStyle(trElement));
            String height = trStyleMap.get("height");
            Tr tr = new Tr(index, TdUtil.getValue(height), true);
            tr.setVisibility(!Objects.equals(trStyleMap.get("visibility"), "hidden"));
            this.parseTdOfTr(tr, trElement, trStyleMap, seizeMap);
            return tr;
        }).collect(Collectors.toCollection(LinkedList::new));
        table.setTrList(trList);
    }

    private void parseTdOfTr(Tr tr, Element trElement, Map<String, String> trStyle, Map<Integer, List<Integer>> seizeMap) {
        Elements tdElements = trElement.children();
        if (tdElements.isEmpty()) {
            tr.setTdList(Collections.emptyList());
            tr.setColWidthMap(Collections.emptyMap());
            return;
        }
        LinkedList<Td> tdList = new LinkedList<Td>();
        HashMap<Integer, Integer> colWidthMap = new HashMap<Integer, Integer>(tdElements.size());
        List seizeOfTr = seizeMap.getOrDefault(tr.getIndex(), Collections.emptyList());
        int shift = 0;
        int size = tdElements.size();
        for (int i = 0; i < size; ++i) {
            int width;
            String widthStr;
            Element tdElement = (Element)tdElements.get(i);
            Td td = new Td(tr.getIndex(), i + shift);
            this.setTdContent(tdElement, td);
            td.setTh(Objects.equals(HtmlTag.th.name(), tdElement.tagName()));
            Map<String, String> tdStyle = StyleUtil.parseStyle(tdElement);
            if (tdStyle.isEmpty() && ContentTypeEnum.isLink(td.getTdContentType())) {
                tdStyle = this.defaultLinkStyle;
            }
            td.setStyle(StyleUtil.mixStyle(trStyle, tdStyle));
            String colSpan = tdElement.attr(HtmlTag.colspan.name());
            td.setColSpan(TdUtil.getSpan(colSpan));
            String rowSpan = tdElement.attr(HtmlTag.rowspan.name());
            td.setRowSpan(TdUtil.getSpan(rowSpan));
            if (!seizeOfTr.isEmpty()) {
                ArrayList checkedPositions = new ArrayList();
                while (true) {
                    List seizePositions = seizeOfTr.stream().filter(s -> td.getCol() >= s).collect(Collectors.toList());
                    if (!checkedPositions.isEmpty()) {
                        seizePositions.removeAll(checkedPositions);
                    }
                    if (seizePositions.isEmpty()) break;
                    td.setCol(td.getCol() + seizePositions.size());
                    checkedPositions.addAll(seizePositions);
                }
            }
            if (td.getRowSpan() > 1) {
                int length = td.getRowSpan();
                for (int j = 1; j < length; ++j) {
                    int rowNum = tr.getIndex() + j;
                    List<Integer> seizePosOfTr = seizeMap.get(rowNum);
                    if (Objects.isNull(seizePosOfTr)) {
                        seizePosOfTr = new ArrayList<Integer>();
                        seizeMap.put(rowNum, seizePosOfTr);
                    }
                    IntStream.rangeClosed(td.getCol(), td.getColBound()).forEach(seizePosOfTr::add);
                }
            }
            if (td.getColSpan() > 0) {
                shift += td.getColSpan() - 1;
            }
            tdList.add(td);
            if (this.parseConfig.isComputeAutoWidth()) {
                int width2 = TdUtil.getStringWidth(td.getContent());
                if (td.getColSpan() > 1) {
                    int realWidth = (int)Math.ceil((double)width2 * 1.0 / (double)td.getColSpan());
                    int span = td.getColSpan();
                    for (int j = 0; j < span; ++j) {
                        int colIndex = td.getCol() + j;
                        Integer colWidth = (Integer)colWidthMap.get(colIndex);
                        if (colWidth != null && colWidth >= realWidth) continue;
                        colWidthMap.put(colIndex, realWidth);
                    }
                } else {
                    colWidthMap.put(td.getCol(), width2);
                }
            }
            if ((widthStr = td.getStyle().get("width")) == null || (width = TdUtil.getValue(widthStr)) < 0) continue;
            colWidthMap.put(td.getCol(), width);
        }
        tr.setTdList(tdList);
        tr.setColWidthMap(colWidthMap);
    }

    private void setTdContent(Element tdElement, Td td) {
        Elements imgs = tdElement.getElementsByTag(HtmlTag.img.name());
        if (imgs != null && !imgs.isEmpty()) {
            String src = ((Element)imgs.get(0)).attr("src");
            td.setFile(new File(src));
            td.setTdContentType(ContentTypeEnum.IMAGE);
            return;
        }
        Elements links = tdElement.getElementsByTag(HtmlTag.a.name());
        if (links != null && !links.isEmpty()) {
            Element a = (Element)links.get(0);
            td.setContent(a.text());
            String href = a.attr("href").trim();
            td.setLink(href);
            td.setTdContentType(href.startsWith("mailto:") ? ContentTypeEnum.LINK_EMAIL : ContentTypeEnum.LINK_URL);
            return;
        }
        String content = this.parseContent(tdElement, td);
        td.setContent(content);
        if (StringUtil.isBlank(content)) {
            return;
        }
        if (tdElement.hasAttr("string")) {
            return;
        }
        if (tdElement.hasAttr("double")) {
            td.setTdContentType(ContentTypeEnum.DOUBLE);
            td.setContent(RegexpUtil.removeComma(td.getContent()));
            return;
        }
        boolean isFormula = tdElement.hasAttr("formula");
        if (isFormula) {
            td.setFormula(true);
            String formula = td.getContent().trim();
            if (formula.startsWith("=")) {
                formula = formula.substring(1);
            }
            td.setContent(formula);
            return;
        }
        if (tdElement.hasAttr("url")) {
            String link = tdElement.attr("url");
            td.setTdContentType(ContentTypeEnum.LINK_URL);
            td.setLink(link);
            return;
        }
        if (tdElement.hasAttr("email")) {
            String link = tdElement.attr("email");
            td.setTdContentType(ContentTypeEnum.LINK_EMAIL);
            td.setLink(link);
            return;
        }
        if (tdElement.hasAttr("dropDownList")) {
            td.setTdContentType(ContentTypeEnum.DROP_DOWN_LIST);
            return;
        }
        if ("true".equals(content) || "false".equals(content)) {
            td.setTdContentType(ContentTypeEnum.BOOLEAN);
            return;
        }
        if (DOUBLE_PATTERN.matcher(content).matches()) {
            td.setTdContentType(ContentTypeEnum.DOUBLE);
        }
    }

    private String parseContent(Element tdElement, Td td) {
        Elements spans = tdElement.getElementsByTag(HtmlTag.span.name());
        if (spans != null && !spans.isEmpty()) {
            td.setFonts(new LinkedList<Font>());
            if (this.spanText == null) {
                this.spanText = new XSSFRichTextString("");
            }
            int startIndex = 0;
            for (Element spanElement : spans) {
                String spanContent = spanElement.text();
                if (spanContent == null) continue;
                spanContent = LINE_FEED_PATTERN.matcher(spanContent).replaceAll("\n");
                this.spanText.setString(spanContent);
                Font font = new Font();
                font.setStartIndex(startIndex);
                font.setEndIndex(startIndex + this.spanText.length());
                Map<String, String> fontStyle = StyleUtil.parseStyle(spanElement);
                if (!fontStyle.isEmpty()) {
                    font.setStyle(fontStyle);
                    td.getFonts().add(font);
                }
                startIndex = font.getEndIndex();
            }
        }
        return LINE_FEED_PATTERN.matcher(tdElement.text()).replaceAll("\n");
    }

    public static enum HtmlTag {
        table,
        caption,
        thead,
        tbody,
        tr,
        th,
        td,
        colspan,
        rowspan,
        link,
        img,
        a,
        span;

    }
}

