/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter;

import com.github.liaochong.myexcel.core.ConvertContext;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.converter.Converter;
import com.github.liaochong.myexcel.core.converter.reader.BigDecimalReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.BoolReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.DateReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.LocalDateReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.LocalDateTimeReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.NumberReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.StringReadConverter;
import com.github.liaochong.myexcel.core.converter.reader.TimestampReadConverter;
import com.github.liaochong.myexcel.exception.ExcelReadException;
import com.github.liaochong.myexcel.exception.SaxReadException;
import com.github.liaochong.myexcel.utils.PropertyUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConverterContext {
    private static final Logger log = LoggerFactory.getLogger(ReadConverterContext.class);
    private static final Map<Class<?>, Converter<String, ?>> READ_CONVERTERS = new HashMap();
    private static final WeakCache<Field, Properties> MAPPING_CACHE = new WeakCache();
    private static final Properties EMPTY_PROPERTIES = new Properties();

    public synchronized ReadConverterContext registering(Class<?> clazz, Converter<String, ?> converter) {
        READ_CONVERTERS.putIfAbsent(clazz, converter);
        return this;
    }

    public static void convert(Object obj, ReadContext context, ConvertContext convertContext, BiFunction<Throwable, ReadContext, Boolean> exceptionFunction) {
        Object value;
        block8: {
            Converter<String, ?> converter = READ_CONVERTERS.get(context.getField().getType());
            if (converter == null) {
                throw new IllegalStateException("No suitable type converter was found.");
            }
            value = null;
            try {
                String mappingVal;
                Properties properties = MAPPING_CACHE.get(context.getField());
                if (properties == null) {
                    ExcelColumnMapping mapping = convertContext.getExcelColumnMappingMap().get(context.getField());
                    properties = mapping != null && !mapping.getMapping().isEmpty() ? PropertyUtil.getReverseProperties(mapping) : EMPTY_PROPERTIES;
                    MAPPING_CACHE.cache(context.getField(), properties);
                }
                if ((mappingVal = properties.getProperty(context.getVal())) != null) {
                    context.setVal(mappingVal);
                }
                value = converter.convert(context.getVal(), context.getField(), convertContext);
            }
            catch (Exception e) {
                Boolean toContinue = exceptionFunction.apply(e, context);
                if (toContinue.booleanValue()) break block8;
                throw new ExcelReadException("Failed to convert content,field:[" + context.getField().getDeclaringClass().getName() + "#" + context.getField().getName() + "],content:[" + context.getVal() + "],rowNum:[" + context.getRowNum() + "]", e);
            }
        }
        if (value == null) {
            return;
        }
        try {
            context.getField().set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new SaxReadException("Failed to set the " + context.getField().getDeclaringClass().getName() + "#" + context.getField().getName() + " field value to " + context.getVal(), e);
        }
    }

    static {
        BoolReadConverter boolReadConverter = new BoolReadConverter();
        READ_CONVERTERS.put(Boolean.class, boolReadConverter);
        READ_CONVERTERS.put(Boolean.TYPE, boolReadConverter);
        READ_CONVERTERS.put(Date.class, new DateReadConverter());
        READ_CONVERTERS.put(LocalDate.class, new LocalDateReadConverter());
        READ_CONVERTERS.put(LocalDateTime.class, new LocalDateTimeReadConverter());
        NumberReadConverter<Double> doubleReadConverter = NumberReadConverter.of(Double::valueOf);
        READ_CONVERTERS.put(Double.class, doubleReadConverter);
        READ_CONVERTERS.put(Double.TYPE, doubleReadConverter);
        NumberReadConverter<Float> floatReadConverter = NumberReadConverter.of(Float::valueOf);
        READ_CONVERTERS.put(Float.class, floatReadConverter);
        READ_CONVERTERS.put(Float.TYPE, floatReadConverter);
        NumberReadConverter<Long> longReadConverter = NumberReadConverter.of(Long::valueOf, true);
        READ_CONVERTERS.put(Long.class, longReadConverter);
        READ_CONVERTERS.put(Long.TYPE, longReadConverter);
        NumberReadConverter<Integer> integerReadConverter = NumberReadConverter.of(Integer::valueOf, true);
        READ_CONVERTERS.put(Integer.class, integerReadConverter);
        READ_CONVERTERS.put(Integer.TYPE, integerReadConverter);
        NumberReadConverter<Short> shortReadConverter = NumberReadConverter.of(Short::valueOf, true);
        READ_CONVERTERS.put(Short.class, shortReadConverter);
        READ_CONVERTERS.put(Short.TYPE, shortReadConverter);
        NumberReadConverter<Byte> byteReadConverter = NumberReadConverter.of(Byte::valueOf, true);
        READ_CONVERTERS.put(Byte.class, byteReadConverter);
        READ_CONVERTERS.put(Byte.TYPE, byteReadConverter);
        READ_CONVERTERS.put(BigDecimal.class, new BigDecimalReadConverter());
        READ_CONVERTERS.put(String.class, new StringReadConverter());
        READ_CONVERTERS.put(Timestamp.class, new TimestampReadConverter());
        NumberReadConverter<BigInteger> bigIntegerReadConverter = NumberReadConverter.of(BigInteger::new, true);
        READ_CONVERTERS.put(BigInteger.class, bigIntegerReadConverter);
    }
}

