/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.ExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.HtmlToExcelFactory;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.core.templatehandler.TemplateHandler;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcelBuilder
implements ExcelBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcelBuilder.class);
    protected TemplateHandler templateHandler;
    protected HtmlToExcelFactory htmlToExcelFactory = new HtmlToExcelFactory();

    AbstractExcelBuilder(Class<? extends TemplateHandler> templateHandlerClass) {
        this.widthStrategy(WidthStrategy.COMPUTE_AUTO_WIDTH);
        this.templateHandler = ReflectUtil.newInstance(templateHandlerClass);
    }

    @Override
    public AbstractExcelBuilder workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        this.htmlToExcelFactory.workbookType(workbookType);
        return this;
    }

    @Override
    public AbstractExcelBuilder useDefaultStyle() {
        this.htmlToExcelFactory.useDefaultStyle();
        return this;
    }

    @Override
    public AbstractExcelBuilder widthStrategy(@NonNull WidthStrategy widthStrategy) {
        if (widthStrategy == null) {
            throw new NullPointerException("widthStrategy is marked non-null but is null");
        }
        this.htmlToExcelFactory.widthStrategy(widthStrategy);
        return this;
    }

    @Override
    @Deprecated
    public AbstractExcelBuilder autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.htmlToExcelFactory.widthStrategy(AutoWidthStrategy.map(autoWidthStrategy));
        return this;
    }

    @Override
    public AbstractExcelBuilder freezePanes(FreezePane ... freezePanes) {
        if (freezePanes == null || freezePanes.length == 0) {
            return this;
        }
        this.htmlToExcelFactory.freezePanes(freezePanes);
        return this;
    }

    @Override
    public <T> Workbook build(Map<String, T> data) {
        String template = this.templateHandler.render(data);
        try {
            return HtmlToExcelFactory.readHtml(template, this.htmlToExcelFactory).build();
        }
        catch (Exception e) {
            throw new ExcelBuildException("Build excel failure", e);
        }
    }

    @Override
    public ExcelBuilder classpathTemplate(String path) {
        this.templateHandler.classpathTemplate(path);
        return this;
    }

    @Override
    @Deprecated
    public ExcelBuilder template(String path) {
        return this.classpathTemplate(path);
    }

    @Override
    public ExcelBuilder fileTemplate(String dirPath, String fileName) {
        this.templateHandler.fileTemplate(dirPath, fileName);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelFactory != null) {
            this.htmlToExcelFactory.closeWorkbook();
        }
    }
}

