/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.exception.ExcelBuildException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileOperator {
    private static final Logger log = LoggerFactory.getLogger(TempFileOperator.class);
    private static final int MAX_CREATE_NO = 9999;
    private static int createNo;
    private static Path templateDir;

    public static Path createTempFile(String prefix, String suffix) {
        try {
            return Files.createTempFile(templateDir, TempFileOperator.getTempFileName(prefix), suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw ExcelBuildException.of("Failed to create temp file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTempFileName(String prefix) {
        long currentTimeMillis = System.currentTimeMillis();
        Class<TempFileOperator> clazz = TempFileOperator.class;
        synchronized (TempFileOperator.class) {
            if (createNo > 9999) {
                createNo = 0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return prefix + "_" + Thread.currentThread().getId() + "_" + currentTimeMillis + "_" + ++createNo;
        }
    }

    public static void deleteTempFiles(List<Path> paths) {
        if (Objects.isNull(paths)) {
            return;
        }
        for (Path path : paths) {
            TempFileOperator.deleteTempFile(path);
        }
    }

    public static void deleteTempFile(Path path) {
        if (Objects.isNull(path)) {
            return;
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            log.warn("Delete temp file failure");
        }
    }

    static {
        try {
            templateDir = Paths.get(new File("").getCanonicalPath(), new String[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

