/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class FileExportUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(Workbook workbook, File file) throws IOException {
        String suffix = ".xlsx";
        if (workbook instanceof HSSFWorkbook) {
            if (file.getName().endsWith(suffix)) {
                String absolutePath = file.getAbsolutePath();
                file = Paths.get(absolutePath.substring(0, absolutePath.length() - 1), new String[0]).toFile();
            }
            suffix = ".xls";
        }
        if (!file.getName().endsWith(suffix)) {
            file = Paths.get(file.getAbsolutePath() + suffix, new String[0]).toFile();
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            workbook.write((OutputStream)os);
        }
        finally {
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
            workbook.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptExport(Workbook workbook, File file, String password) throws Exception {
        if (workbook instanceof HSSFWorkbook) {
            throw new IllegalArgumentException("Document encryption for.xls is not supported");
        }
        String suffix = ".xlsx";
        if (!file.getName().endsWith(suffix)) {
            file = Paths.get(file.getAbsolutePath() + suffix, new String[0]).toFile();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            workbook.write((OutputStream)fos);
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
            POIFSFileSystem fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.standard);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ_WRITE);
                 OutputStream os = enc.getDataStream(fs);){
                opc.save(os);
            }
            var10_12 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fs.writeFilesystem((OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                var10_12 = throwable;
                throw throwable;
            }
        }
        finally {
            workbook.close();
        }
    }

    public static InputStream getInputStream(Workbook workbook) {
        String suffix = ".xlsx";
        if (workbook instanceof HSSFWorkbook) {
            suffix = ".xls";
        }
        Path path = TempFileOperator.createTempFile("tem_outs", suffix);
        try {
            workbook.write(Files.newOutputStream(path, new OpenOption[0]));
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            TempFileOperator.deleteTempFile(path);
        }
    }

    private FileExportUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

