/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.utils;

import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public final class AttachmentExportUtil {
    public static void export(Workbook workbook, String fileName, HttpServletResponse response) {
        try {
            String suffix = ".xlsx";
            if (workbook instanceof HSSFWorkbook) {
                if (fileName.endsWith(suffix)) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                suffix = ".xls";
                response.setContentType("application/vnd.ms-excel");
            } else {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            }
            if (!fileName.endsWith(suffix)) {
                fileName = fileName + suffix;
            }
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void encryptExport(Workbook workbook, String fileName, HttpServletResponse response, String password) {
        if (workbook instanceof HSSFWorkbook) {
            throw new IllegalArgumentException("Document encryption for.xls is not supported");
        }
        Path path = null;
        try {
            String suffix = ".xlsx";
            path = TempFileOperator.createTempFile("encrypt_temp", suffix);
            workbook.write(Files.newOutputStream(path, new OpenOption[0]));
            POIFSFileSystem fs = new POIFSFileSystem();
            EncryptionInfo info = new EncryptionInfo(EncryptionMode.standard);
            Encryptor enc = info.getEncryptor();
            enc.confirmPassword(password);
            try (OPCPackage opc = OPCPackage.open((File)path.toFile(), (PackageAccess)PackageAccess.READ_WRITE);
                 OutputStream os = enc.getDataStream(fs);){
                opc.save(os);
            }
            if (!fileName.endsWith(suffix)) {
                fileName = fileName + suffix;
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            fs.writeFilesystem((OutputStream)response.getOutputStream());
        }
        catch (IOException | GeneralSecurityException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TempFileOperator.deleteTempFile(path);
        }
    }

    public static void export(Path path, String fileName, HttpServletResponse response) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.getOutputStream().write(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            TempFileOperator.deleteTempFile(path);
        }
    }

    private AttachmentExportUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

