/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.style;

import com.github.liaochong.myexcel.core.style.CustomColor;
import com.github.liaochong.myexcel.utils.ColorUtil;
import java.awt.Color;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackgroundStyle {
    private static final Logger log = LoggerFactory.getLogger(BackgroundStyle.class);
    public static final String BACKGROUND_COLOR = "background-color";

    public static void setBackgroundColor(CellStyle style, Map<String, String> tdStyle, CustomColor customColor) {
        if (Objects.isNull(tdStyle)) {
            return;
        }
        String color = tdStyle.get(BACKGROUND_COLOR);
        if (Objects.isNull(color)) {
            return;
        }
        Short colorPredefined = ColorUtil.getPredefinedColorIndex(color);
        if (colorPredefined != null) {
            style.setFillForegroundColor(colorPredefined.shortValue());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            return;
        }
        if (customColor.isXls()) {
            log.warn(".xls does not support custom colors for the time being. Please use predefined colors.");
            return;
        }
        int[] rgb = ColorUtil.getRGBByColor(color);
        BackgroundStyle.setCustomColor(style, rgb, customColor);
    }

    private static void setCustomColor(CellStyle style, int[] rgb, CustomColor customColor) {
        if (Objects.isNull(rgb)) {
            return;
        }
        XSSFCellStyle xssfCellStyle = (XSSFCellStyle)style;
        xssfCellStyle.setFillForegroundColor(new XSSFColor(new Color(rgb[0], rgb[1], rgb[2]), (IndexedColorMap)customColor.getDefaultIndexedColorMap()));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }
}

