/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class LocalDateTimeReadConverter
extends AbstractReadConverter<LocalDateTime> {
    @Override
    public LocalDateTime doConvert(String v, Field field) {
        if (this.isNumber(v)) {
            long time = Long.parseLong(v);
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(time), TimeZone.getDefault().toZoneId());
        }
        DateTimeFormatter dateTimeFormatter = this.getDateFormatFormatter(field);
        return LocalDateTime.parse(v, dateTimeFormatter);
    }
}

