/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.CsvHandler;
import com.github.liaochong.myexcel.core.HSSFSaxHandler;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.SaxHandler;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.parsers.ParserConfigurationException;
import lombok.NonNull;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxExcelReader<T> {
    private static final Logger log = LoggerFactory.getLogger(SaxExcelReader.class);
    private static final int DEFAULT_SHEET_INDEX = 0;
    private OPCPackage xlsxPackage;
    private List<T> result = Collections.emptyList();
    private ReadConfig<T> readConfig = new ReadConfig();

    private SaxExcelReader(Class<T> dataType) {
        ((ReadConfig)this.readConfig).dataType = dataType;
    }

    public static <T> SaxExcelReader<T> of(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return new SaxExcelReader<T>(clazz);
    }

    public SaxExcelReader<T> sheet(int index) {
        ((ReadConfig)this.readConfig).sheetIndex = index;
        return this;
    }

    public SaxExcelReader<T> sheet(String sheetName) {
        ((ReadConfig)this.readConfig).sheetName = sheetName;
        return this;
    }

    public SaxExcelReader<T> rowFilter(Predicate<Row> rowFilter) {
        ((ReadConfig)this.readConfig).rowFilter = rowFilter;
        return this;
    }

    public SaxExcelReader<T> beanFilter(Predicate<T> beanFilter) {
        ((ReadConfig)this.readConfig).beanFilter = beanFilter;
        return this;
    }

    public SaxExcelReader<T> charset(String charset) {
        ((ReadConfig)this.readConfig).charset = charset;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> read(@NonNull InputStream fileInputStream) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        if (!fileInputStream.markSupported()) {
            fileInputStream = new BufferedInputStream(fileInputStream);
        }
        try (OPCPackage p = OPCPackage.open((InputStream)fileInputStream);){
            this.xlsxPackage = p;
            this.process();
            List<T> list = this.result;
            return list;
        }
        catch (OLE2NotOfficeXmlFileException e) {
            try {
                this.result = new LinkedList<T>();
                new HSSFSaxHandler<T>(fileInputStream, this.result, this.readConfig).process();
                return this.result;
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (NotOfficeXmlFileException e) {
            this.result = new LinkedList<T>();
            new CsvHandler<T>(fileInputStream, this.readConfig, this.result).read();
            return this.result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> read(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String fileName = file.getName();
        if (fileName.endsWith(".xls")) {
            this.result = new LinkedList<T>();
            try {
                new HSSFSaxHandler<T>(file, this.result, this.readConfig).process();
                return this.result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!fileName.endsWith(".xlsx")) {
            this.result = new LinkedList<T>();
            new CsvHandler<T>(file, this.readConfig, this.result).read();
            return this.result;
        }
        try (OPCPackage p = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            this.xlsxPackage = p;
            this.process();
            List<T> list = this.result;
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readThen(@NonNull InputStream fileInputStream, Consumer<T> consumer) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        if (!fileInputStream.markSupported()) {
            fileInputStream = new BufferedInputStream(fileInputStream);
        }
        ((ReadConfig)this.readConfig).consumer = consumer;
        try (OPCPackage p = OPCPackage.open((InputStream)fileInputStream);){
            this.xlsxPackage = p;
            this.process();
        }
        catch (OLE2NotOfficeXmlFileException e) {
            try {
                new HSSFSaxHandler<T>(fileInputStream, this.result, this.readConfig).process();
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (NotOfficeXmlFileException e) {
            new CsvHandler<T>(fileInputStream, this.readConfig, this.result).read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readThen(@NonNull File file, Consumer<T> consumer) {
        block19: {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            ((ReadConfig)this.readConfig).consumer = consumer;
            String fileName = file.getName();
            if (fileName.endsWith(".xls")) {
                try {
                    new HSSFSaxHandler<T>(file, this.result, this.readConfig).process();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (fileName.endsWith(".xlsx")) {
                try (OPCPackage p = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
                    this.xlsxPackage = p;
                    this.process();
                    break block19;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.result = new LinkedList<T>();
            new CsvHandler<T>(file, this.readConfig, this.result).read();
        }
    }

    public void readThen(@NonNull InputStream fileInputStream, Function<T, Boolean> function) {
        if (fileInputStream == null) {
            throw new NullPointerException("fileInputStream is marked non-null but is null");
        }
        if (!fileInputStream.markSupported()) {
            fileInputStream = new BufferedInputStream(fileInputStream);
        }
        ((ReadConfig)this.readConfig).function = function;
        try (OPCPackage p2 = OPCPackage.open((InputStream)fileInputStream);){
            this.xlsxPackage = p2;
            this.process();
        }
        catch (StopReadException p2) {
        }
        catch (OLE2NotOfficeXmlFileException e) {
            try {
                new HSSFSaxHandler<T>(fileInputStream, this.result, this.readConfig).process();
            }
            catch (StopReadException stopReadException) {
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (NotOfficeXmlFileException e) {
            try {
                new CsvHandler<T>(fileInputStream, this.readConfig, this.result).read();
            }
            catch (StopReadException stopReadException) {}
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readThen(@NonNull File file, Function<T, Boolean> function) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        ((ReadConfig)this.readConfig).function = function;
        String fileName = file.getName();
        if (fileName.endsWith(".xls")) {
            try {
                new HSSFSaxHandler<T>(file, this.result, this.readConfig).process();
            }
            catch (StopReadException stopReadException) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (fileName.endsWith(".xlsx")) {
            try (OPCPackage p2 = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
                this.xlsxPackage = p2;
                this.process();
            }
            catch (StopReadException p2) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            try {
                new CsvHandler<T>(file, this.readConfig, this.result).read();
            }
            catch (StopReadException stopReadException) {
                // empty catch block
            }
        }
    }

    private void process() throws IOException, OpenXML4JException, SAXException {
        long startTime = System.currentTimeMillis();
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        Map<Integer, Field> fieldMap = ReflectUtil.getFieldMapOfExcelColumn(((ReadConfig)this.readConfig).dataType);
        this.result = new LinkedList<T>();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        if (((ReadConfig)this.readConfig).sheetName != null) {
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                Throwable throwable = null;
                try {
                    if (!((ReadConfig)this.readConfig).sheetName.equals(iter.getSheetName())) continue;
                    this.processSheet((SharedStrings)strings, new SaxHandler<T>(fieldMap, this.result, this.readConfig), stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        } else {
            int index = 0;
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                Throwable throwable = null;
                try {
                    if (index <= ((ReadConfig)this.readConfig).sheetIndex) {
                        if (index == ((ReadConfig)this.readConfig).sheetIndex) {
                            this.processSheet((SharedStrings)strings, new SaxHandler<T>(fieldMap, this.result, this.readConfig), stream);
                        }
                        ++index;
                        continue;
                    }
                    break;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
        log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void processSheet(SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(null, null, strings, sheetHandler, formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public static class ReadConfig<T> {
        private Class<T> dataType;
        private String sheetName;
        private int sheetIndex = 0;
        private Consumer<T> consumer;
        private Function<T, Boolean> function;
        private Predicate<Row> rowFilter = row -> true;
        private Predicate<T> beanFilter = bean -> true;
        private String charset = "UTF-8";

        public Class<T> getDataType() {
            return this.dataType;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public Consumer<T> getConsumer() {
            return this.consumer;
        }

        public Function<T, Boolean> getFunction() {
            return this.function;
        }

        public Predicate<Row> getRowFilter() {
            return this.rowFilter;
        }

        public Predicate<T> getBeanFilter() {
            return this.beanFilter;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setDataType(Class<T> dataType) {
            this.dataType = dataType;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public void setSheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
        }

        public void setConsumer(Consumer<T> consumer) {
            this.consumer = consumer;
        }

        public void setFunction(Function<T, Boolean> function) {
            this.function = function;
        }

        public void setRowFilter(Predicate<Row> rowFilter) {
            this.rowFilter = rowFilter;
        }

        public void setBeanFilter(Predicate<T> beanFilter) {
            this.beanFilter = beanFilter;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadConfig)) {
                return false;
            }
            ReadConfig other = (ReadConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$dataType = this.getDataType();
            Class<T> other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            String this$sheetName = this.getSheetName();
            String other$sheetName = other.getSheetName();
            if (this$sheetName == null ? other$sheetName != null : !this$sheetName.equals(other$sheetName)) {
                return false;
            }
            if (this.getSheetIndex() != other.getSheetIndex()) {
                return false;
            }
            Consumer<T> this$consumer = this.getConsumer();
            Consumer<T> other$consumer = other.getConsumer();
            if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
                return false;
            }
            Function<T, Boolean> this$function = this.getFunction();
            Function<T, Boolean> other$function = other.getFunction();
            if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
                return false;
            }
            Predicate<Row> this$rowFilter = this.getRowFilter();
            Predicate<Row> other$rowFilter = other.getRowFilter();
            if (this$rowFilter == null ? other$rowFilter != null : !this$rowFilter.equals(other$rowFilter)) {
                return false;
            }
            Predicate<T> this$beanFilter = this.getBeanFilter();
            Predicate<T> other$beanFilter = other.getBeanFilter();
            if (this$beanFilter == null ? other$beanFilter != null : !this$beanFilter.equals(other$beanFilter)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReadConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            String $sheetName = this.getSheetName();
            result = result * 59 + ($sheetName == null ? 43 : $sheetName.hashCode());
            result = result * 59 + this.getSheetIndex();
            Consumer<T> $consumer = this.getConsumer();
            result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
            Function<T, Boolean> $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : $function.hashCode());
            Predicate<Row> $rowFilter = this.getRowFilter();
            result = result * 59 + ($rowFilter == null ? 43 : $rowFilter.hashCode());
            Predicate<T> $beanFilter = this.getBeanFilter();
            result = result * 59 + ($beanFilter == null ? 43 : $beanFilter.hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            return result;
        }

        public String toString() {
            return "SaxExcelReader.ReadConfig(dataType=" + this.getDataType() + ", sheetName=" + this.getSheetName() + ", sheetIndex=" + this.getSheetIndex() + ", consumer=" + this.getConsumer() + ", function=" + this.getFunction() + ", rowFilter=" + this.getRowFilter() + ", beanFilter=" + this.getBeanFilter() + ", charset=" + this.getCharset() + ")";
        }
    }
}

