/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CsvHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(CsvHandler.class);
    private final Map<Integer, Field> fieldMap;
    private InputStream is;
    private List<T> result;
    private Class<T> dataType;
    private Consumer<T> consumer;
    private Function<T, Boolean> function;
    private Predicate<Row> rowFilter;
    private Predicate<T> beanFilter;
    private String charset;

    public CsvHandler(InputStream is, SaxExcelReader.ReadConfig<T> readConfig, List<T> result) {
        this.is = is;
        try {
            is.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.result = result;
        this.dataType = readConfig.getDataType();
        this.fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
        this.consumer = readConfig.getConsumer();
        this.function = readConfig.getFunction();
        this.rowFilter = readConfig.getRowFilter();
        this.beanFilter = readConfig.getBeanFilter();
        this.charset = readConfig.getCharset();
    }

    public CsvHandler(File file, SaxExcelReader.ReadConfig<T> readConfig, List<T> result) {
        try {
            this.is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            this.result = result;
            this.dataType = readConfig.getDataType();
            this.fieldMap = ReflectUtil.getFieldMapOfExcelColumn(this.dataType);
            this.consumer = readConfig.getConsumer();
            this.function = readConfig.getFunction();
            this.rowFilter = readConfig.getRowFilter();
            this.beanFilter = readConfig.getBeanFilter();
            this.charset = readConfig.getCharset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void read() {
        if (this.is == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.is, this.charset));){
            String line;
            int lineIndex = 0;
            while ((line = bufferedReader.readLine()) != null) {
                Row row = new Row(lineIndex);
                this.process(line, row);
                ++lineIndex;
            }
            log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (StopReadException e) {
            log.info("Sax import takes {} ms", (Object)(System.currentTimeMillis() - startTime));
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void process(String line, Row row) throws Exception {
        if (!this.rowFilter.test(row)) {
            return;
        }
        T obj = this.dataType.newInstance();
        if (line != null) {
            String[] strArr = line.split(",(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", -1);
            int size = strArr.length;
            for (int i = 0; i < size; ++i) {
                String content = strArr[i];
                Field field = this.fieldMap.get(i);
                if (field == null) continue;
                ReadConverterContext.convert(content, field, obj);
            }
        }
        if (!this.beanFilter.test(obj)) {
            return;
        }
        if (this.consumer != null) {
            this.consumer.accept(obj);
        } else if (this.function != null) {
            Boolean noStop = this.function.apply(obj);
            if (!noStop.booleanValue()) {
                throw new StopReadException();
            }
        } else {
            this.result.add(obj);
        }
    }
}

