/*
 * Decompiled with CFR 0.152.
 */
package com.drake.statelayout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import com.drake.statelayout.R;
import com.drake.statelayout.StateChangedHandler;
import com.drake.statelayout.StateConfig;
import com.drake.statelayout.StateLayout;
import com.drake.statelayout.Status;
import com.drake.statelayout.StatusInfo;
import com.drake.statelayout.ThrottleClickKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010G\u001a\u00020#2\u0006\u0010@\u001a\u00020?2\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J6\u0010!\u001a\u00020\u00002.\u0010H\u001a*\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(0\"\u00a2\u0006\u0002\b)J6\u0010,\u001a\u00020\u00002.\u0010H\u001a*\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(0\"\u00a2\u0006\u0002\b)J6\u0010.\u001a\u00020\u00002.\u0010H\u001a*\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(0\"\u00a2\u0006\u0002\b)J\b\u0010I\u001a\u00020(H\u0014J6\u00100\u001a\u00020\u00002.\u0010H\u001a*\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(0\"\u00a2\u0006\u0002\b)J6\u00102\u001a\u00020\u00002.\u0010H\u001a*\u0012\u0004\u0012\u00020\u0000\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(0\"\u00a2\u0006\u0002\b)J\u0006\u0010J\u001a\u00020(J\u0012\u0010K\u001a\u00020(2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010$J\u0010\u0010L\u001a\u00020(2\u0006\u0010@\u001a\u00020?H\u0002J\u0016\u0010M\u001a\u00020(2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020(0NH\u0002J\u000e\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020#J\u0014\u0010Q\u001a\u00020\u00002\f\b\u0001\u0010R\u001a\u000204\"\u00020\u0007J\u0012\u0010S\u001a\u00020(2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010$J\u0012\u0010T\u001a\u00020(2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010$J\u0012\u0010U\u001a\u00020(2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010$J&\u0010V\u001a\u00020(2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010W\u001a\u00020\u00192\b\b\u0002\u0010J\u001a\u00020\u0019J\u001c\u0010X\u001a\u00020(2\u0006\u0010@\u001a\u00020?2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010$H\u0002J\u0006\u0010F\u001a\u00020\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R@\u0010!\u001a,\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010\"\u00a2\u0006\u0002\b)8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R@\u0010,\u001a,\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010\"\u00a2\u0006\u0002\b)8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R@\u0010.\u001a,\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010\"\u00a2\u0006\u0002\b)8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R@\u00100\u001a,\u0012\u0004\u0012\u00020#\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010\"\u00a2\u0006\u0002\b)8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010+R8\u00102\u001a,\u0012\u0004\u0012\u00020\u0000\u0012\u0015\u0012\u0013\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020(\u0018\u00010\"\u00a2\u0006\u0002\b)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00103\u001a\u0004\u0018\u0001048BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001e\u0010@\u001a\u00020?2\u0006\u0010>\u001a\u00020?@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020E0DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/drake/statelayout/StateLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "clickThrottle", "", "getClickThrottle", "()J", "setClickThrottle", "(J)V", "value", "emptyLayout", "getEmptyLayout", "()I", "setEmptyLayout", "(I)V", "errorLayout", "getErrorLayout", "setErrorLayout", "loaded", "", "getLoaded", "()Z", "setLoaded", "(Z)V", "loadingLayout", "getLoadingLayout", "setLoadingLayout", "onContent", "Lkotlin/Function2;", "Landroid/view/View;", "", "Lkotlin/ParameterName;", "name", "tag", "", "Lkotlin/ExtensionFunctionType;", "getOnContent", "()Lkotlin/jvm/functions/Function2;", "onEmpty", "getOnEmpty", "onError", "getOnError", "onLoading", "getOnLoading", "onRefresh", "retryIds", "", "getRetryIds", "()[I", "stateChanged", "stateChangedHandler", "Lcom/drake/statelayout/StateChangedHandler;", "getStateChangedHandler", "()Lcom/drake/statelayout/StateChangedHandler;", "setStateChangedHandler", "(Lcom/drake/statelayout/StateChangedHandler;)V", "<set-?>", "Lcom/drake/statelayout/Status;", "status", "getStatus", "()Lcom/drake/statelayout/Status;", "statusMap", "Landroid/util/ArrayMap;", "Lcom/drake/statelayout/StatusInfo;", "trigger", "getStatusView", "block", "onFinishInflate", "refresh", "refreshing", "removeStatus", "runMain", "Lkotlin/Function0;", "setContent", "view", "setRetryIds", "ids", "showContent", "showEmpty", "showError", "showLoading", "silent", "showStatus", "statelayout_release"})
public final class StateLayout
extends FrameLayout {
    @NotNull
    private final ArrayMap<Status, StatusInfo> statusMap;
    private boolean stateChanged;
    private boolean trigger;
    @Nullable
    private int[] retryIds;
    @Nullable
    private Function2<? super View, Object, Unit> onEmpty;
    @Nullable
    private Function2<? super View, Object, Unit> onError;
    @Nullable
    private Function2<? super View, Object, Unit> onContent;
    @Nullable
    private Function2<? super View, Object, Unit> onLoading;
    @Nullable
    private Function2<? super StateLayout, Object, Unit> onRefresh;
    @NotNull
    private Status status;
    private boolean loaded;
    private long clickThrottle;
    @NotNull
    private StateChangedHandler stateChangedHandler;
    @LayoutRes
    private int errorLayout;
    @LayoutRes
    private int emptyLayout;
    @LayoutRes
    private int loadingLayout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public StateLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.statusMap = new ArrayMap();
        this.status = Status.CONTENT;
        this.clickThrottle = StateConfig.getClickThrottle();
        this.stateChangedHandler = StateConfig.getStateChangedHandler();
        this.errorLayout = -1;
        this.emptyLayout = -1;
        this.loadingLayout = -1;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StateLayout);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026 R.styleable.StateLayout)");
        TypedArray attributes = typedArray;
        try {
            this.setEmptyLayout(attributes.getResourceId(R.styleable.StateLayout_empty_layout, -1));
            this.setErrorLayout(attributes.getResourceId(R.styleable.StateLayout_error_layout, -1));
            this.setLoadingLayout(attributes.getResourceId(R.styleable.StateLayout_loading_layout, -1));
        }
        finally {
            attributes.recycle();
        }
    }

    public /* synthetic */ StateLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final int[] getRetryIds() {
        int[] nArray = this.retryIds;
        if (this.retryIds == null) {
            nArray = StateConfig.INSTANCE.getRetryIds$statelayout_release();
        }
        return nArray;
    }

    private final Function2<View, Object, Unit> getOnEmpty() {
        Function2<? super View, Object, Unit> function2 = this.onEmpty;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnEmpty$statelayout_release();
        }
        return function2;
    }

    private final Function2<View, Object, Unit> getOnError() {
        Function2<? super View, Object, Unit> function2 = this.onError;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnError$statelayout_release();
        }
        return function2;
    }

    private final Function2<View, Object, Unit> getOnContent() {
        Function2<? super View, Object, Unit> function2 = this.onContent;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnContent$statelayout_release();
        }
        return function2;
    }

    private final Function2<View, Object, Unit> getOnLoading() {
        Function2<? super View, Object, Unit> function2 = this.onLoading;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnLoading$statelayout_release();
        }
        return function2;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final boolean getLoaded() {
        return this.loaded;
    }

    public final void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public final long getClickThrottle() {
        return this.clickThrottle;
    }

    public final void setClickThrottle(long l) {
        this.clickThrottle = l;
    }

    @NotNull
    public final StateChangedHandler getStateChangedHandler() {
        return this.stateChangedHandler;
    }

    public final void setStateChangedHandler(@NotNull StateChangedHandler stateChangedHandler) {
        Intrinsics.checkNotNullParameter((Object)stateChangedHandler, (String)"<set-?>");
        this.stateChangedHandler = stateChangedHandler;
    }

    public final int getErrorLayout() {
        return this.errorLayout == -1 ? StateConfig.getErrorLayout() : this.errorLayout;
    }

    public final void setErrorLayout(int value) {
        if (this.errorLayout != value) {
            this.removeStatus(Status.ERROR);
            this.errorLayout = value;
        }
    }

    public final int getEmptyLayout() {
        return this.emptyLayout == -1 ? StateConfig.getEmptyLayout() : this.emptyLayout;
    }

    public final void setEmptyLayout(int value) {
        if (this.emptyLayout != value) {
            this.removeStatus(Status.EMPTY);
            this.emptyLayout = value;
        }
    }

    public final int getLoadingLayout() {
        return this.loadingLayout == -1 ? StateConfig.getLoadingLayout() : this.loadingLayout;
    }

    public final void setLoadingLayout(int value) {
        if (this.loadingLayout != value) {
            this.removeStatus(Status.LOADING);
            this.loadingLayout = value;
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 1 || this.getChildCount() == 0) {
            throw new UnsupportedOperationException("StateLayout only have one child view");
        }
        if (this.statusMap.size() == 0) {
            View view = this.getChildAt(0);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            this.setContent(view);
        }
    }

    @NotNull
    public final StateLayout onLoading(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onLoading_u24lambda_u2d0 = stateLayout = this;
        boolean bl = false;
        $this$onLoading_u24lambda_u2d0.onLoading = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onEmpty(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onEmpty_u24lambda_u2d1 = stateLayout = this;
        boolean bl = false;
        $this$onEmpty_u24lambda_u2d1.onEmpty = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onError(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onError_u24lambda_u2d2 = stateLayout = this;
        boolean bl = false;
        $this$onError_u24lambda_u2d2.onError = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onRefresh(@NotNull Function2<? super StateLayout, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onRefresh_u24lambda_u2d3 = stateLayout = this;
        boolean bl = false;
        $this$onRefresh_u24lambda_u2d3.onRefresh = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onContent(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onContent_u24lambda_u2d4 = stateLayout = this;
        boolean bl = false;
        $this$onContent_u24lambda_u2d4.onContent = block;
        return stateLayout;
    }

    public final void refresh() {
        StateLayout.showLoading$default(this, null, true, false, 5, null);
    }

    public final void refreshing(@Nullable Object tag) {
        if (this.loaded) {
            this.refresh();
        } else {
            StateLayout.showLoading$default(this, tag, false, false, 6, null);
        }
    }

    public static /* synthetic */ void refreshing$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.refreshing(object);
    }

    public final void showLoading(@Nullable Object tag, boolean silent, boolean refresh) {
        block2: {
            if (!silent) {
                this.showStatus(Status.LOADING, tag);
            }
            if (!refresh) break block2;
            Function2<? super StateLayout, Object, Unit> function2 = this.onRefresh;
            if (function2 != null) {
                function2.invoke((Object)this, tag);
            }
        }
    }

    public static /* synthetic */ void showLoading$default(StateLayout stateLayout, Object object, boolean bl, boolean bl2, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        stateLayout.showLoading(object, bl, bl2);
    }

    public final void showEmpty(@Nullable Object tag) {
        this.showStatus(Status.EMPTY, tag);
    }

    public static /* synthetic */ void showEmpty$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.showEmpty(object);
    }

    public final void showError(@Nullable Object tag) {
        this.showStatus(Status.ERROR, tag);
    }

    public static /* synthetic */ void showError$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.showError(object);
    }

    public final void showContent(@Nullable Object tag) {
        if (this.trigger && this.stateChanged) {
            return;
        }
        this.showStatus(Status.CONTENT, tag);
        this.loaded = true;
    }

    public static /* synthetic */ void showContent$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.showContent(object);
    }

    @NotNull
    public final StateLayout setRetryIds(int ... ids) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        StateLayout $this$setRetryIds_u24lambda_u2d5 = stateLayout = this;
        boolean bl = false;
        $this$setRetryIds_u24lambda_u2d5.retryIds = ids;
        return stateLayout;
    }

    public final boolean trigger() {
        boolean bl = this.trigger = !this.trigger;
        if (!this.trigger) {
            this.stateChanged = false;
        }
        return this.trigger;
    }

    private final void showStatus(Status status, Object tag) {
        if (this.trigger) {
            this.stateChanged = true;
        }
        if (this.status == status) {
            StatusInfo statusInfo = (StatusInfo)this.statusMap.get((Object)this.status);
            if (Intrinsics.areEqual((Object)(statusInfo != null ? statusInfo.getTag() : null), (Object)tag)) {
                return;
            }
        }
        this.runMain((Function0<Unit>)((Function0)new Function0<Unit>(this, status, tag){
            final /* synthetic */ StateLayout this$0;
            final /* synthetic */ Status $status;
            final /* synthetic */ Object $tag;
            {
                this.this$0 = $receiver;
                this.$status = $status;
                this.$tag = $tag;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    void $this$forEach$iv;
                    Iterator<Map.Entry<K, V>> $this$filterTo$iv$iv;
                    Map $this$filter$iv;
                    View targetStatusView = StateLayout.access$getStatusView(this.this$0, this.$status, this.$tag);
                    Map map = (Map)StateLayout.access$getStatusMap$p(this.this$0);
                    Object object = this.$status;
                    boolean $i$f$filter = false;
                    void var5_7 = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl = false;
                        if (!(it.getKey() != object)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    $this$filter$iv = destination$iv$iv;
                    object = this.this$0;
                    boolean $i$f$forEach = false;
                    $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
                    while ($this$filterTo$iv$iv.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = $this$filterTo$iv$iv.next();
                        boolean bl = false;
                        StatusInfo statusInfo = (StatusInfo)it.getValue();
                        if (it.getKey() != ((StateLayout)((Object)object)).getStatus()) continue;
                        StateChangedHandler stateChangedHandler = ((StateLayout)((Object)object)).getStateChangedHandler();
                        View view = statusInfo.getView();
                        K k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                        stateChangedHandler.onRemove((StateLayout)((Object)object), view, (Status)((Object)k), statusInfo.getTag());
                    }
                    this.this$0.getStateChangedHandler().onAdd(this.this$0, targetStatusView, this.$status, this.$tag);
                    if (this.$status == Status.EMPTY || this.$status == Status.ERROR) {
                        int[] nArray = StateLayout.access$getRetryIds(this.this$0);
                        if (nArray != null) {
                            void $this$forEach$iv2;
                            object = nArray;
                            StateLayout stateLayout = this.this$0;
                            boolean $i$f$forEach2 = false;
                            int n = ((void)$this$forEach$iv2).length;
                            for (int i = 0; i < n; ++i) {
                                View view;
                                void element$iv;
                                void it = element$iv = $this$forEach$iv2[i];
                                boolean bl = false;
                                View view2 = view = targetStatusView.findViewById((int)it);
                                if (view2 != null) {
                                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById<View>(it)");
                                    ThrottleClickKt.throttleClick$default(view, stateLayout.getClickThrottle(), null, (Function1)new Function1<View, Unit>(stateLayout){
                                        final /* synthetic */ StateLayout this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull View $this$throttleClick) {
                                            Intrinsics.checkNotNullParameter((Object)$this$throttleClick, (String)"$this$throttleClick");
                                            StatusInfo statusInfo = (StatusInfo)StateLayout.access$getStatusMap$p(this.this$0).get((Object)((Object)Status.LOADING));
                                            StateLayout.showLoading$default(this.this$0, statusInfo != null ? statusInfo.getTag() : null, false, false, 6, null);
                                        }
                                    }, 2, null);
                                }
                            }
                        }
                    }
                    switch (showStatus.WhenMappings.$EnumSwitchMapping$0[this.$status.ordinal()]) {
                        case 1: {
                            Function2 function2 = StateLayout.access$getOnEmpty(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                            }
                            break;
                        }
                        case 2: {
                            Function2 function2 = StateLayout.access$getOnError(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                            }
                            break;
                        }
                        case 3: {
                            Function2 function2 = StateLayout.access$getOnLoading(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                            }
                            break;
                        }
                        case 4: {
                            Function2 function2 = StateLayout.access$getOnContent(this.this$0);
                            if (function2 == null) break;
                            function2.invoke((Object)targetStatusView, this.$tag);
                            break;
                        }
                    }
                    StateLayout.access$setStatus$p(this.this$0, this.$status);
                }
                catch (Exception e) {
                    Log.e((String)((Object)((Object)this.this$0)).getClass().getSimpleName(), (String)"", (Throwable)e);
                }
            }
        }));
    }

    static /* synthetic */ void showStatus$default(StateLayout stateLayout, Status status, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        stateLayout.showStatus(status, object);
    }

    private final void removeStatus(Status status) {
        this.statusMap.remove((Object)status);
    }

    private final View getStatusView(Status status, Object tag) throws NullPointerException {
        int n;
        StatusInfo statusInfo = (StatusInfo)this.statusMap.get((Object)status);
        if (statusInfo != null) {
            StatusInfo it = statusInfo;
            boolean bl = false;
            it.setTag(tag);
            return it.getView();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                n = this.getEmptyLayout();
                break;
            }
            case 2: {
                n = this.getErrorLayout();
                break;
            }
            case 3: {
                n = this.getLoadingLayout();
                break;
            }
            case 4: {
                n = -1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int layoutId = n;
        if (layoutId == -1) {
            switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 2: {
                    throw new Resources.NotFoundException("No StateLayout errorLayout is set");
                }
                case 1: {
                    throw new Resources.NotFoundException("No StateLayout emptyLayout is set");
                }
                case 3: {
                    throw new Resources.NotFoundException("No StateLayout loadingLayout is set");
                }
                case 4: {
                    throw new Resources.NotFoundException("No StateLayout contentView is set");
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutId, (ViewGroup)this, false);
        Map map = (Map)this.statusMap;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        map.put(status, new StatusInfo(view, tag));
        return view;
    }

    public final void setContent(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ((Map)this.statusMap).put(Status.CONTENT, new StatusInfo(view, null));
    }

    private final void runMain(Function0<Unit> block) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            block.invoke();
        } else {
            new Handler(Looper.getMainLooper()).post(() -> StateLayout.runMain$lambda-7(block));
        }
    }

    @JvmOverloads
    public StateLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StateLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void runMain$lambda-7(Function0 $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        $block.invoke();
    }

    public static final /* synthetic */ View access$getStatusView(StateLayout $this, Status status, Object tag) {
        return $this.getStatusView(status, tag);
    }

    public static final /* synthetic */ ArrayMap access$getStatusMap$p(StateLayout $this) {
        return $this.statusMap;
    }

    public static final /* synthetic */ int[] access$getRetryIds(StateLayout $this) {
        return $this.getRetryIds();
    }

    public static final /* synthetic */ Function2 access$getOnEmpty(StateLayout $this) {
        return $this.getOnEmpty();
    }

    public static final /* synthetic */ Function2 access$getOnError(StateLayout $this) {
        return $this.getOnError();
    }

    public static final /* synthetic */ Function2 access$getOnLoading(StateLayout $this) {
        return $this.getOnLoading();
    }

    public static final /* synthetic */ Function2 access$getOnContent(StateLayout $this) {
        return $this.getOnContent();
    }

    public static final /* synthetic */ void access$setStatus$p(StateLayout $this, Status status) {
        $this.status = status;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.EMPTY.ordinal()] = 1;
            nArray[Status.ERROR.ordinal()] = 2;
            nArray[Status.LOADING.ordinal()] = 3;
            nArray[Status.CONTENT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

