/*
 * Decompiled with CFR 0.152.
 */
package com.drake.statelayout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import com.drake.statelayout.R;
import com.drake.statelayout.StateChangedHandler;
import com.drake.statelayout.StateConfig;
import com.drake.statelayout.StateLayout;
import com.drake.statelayout.Status;
import com.drake.statelayout.StatusInfo;
import com.drake.statelayout.ThrottleClickKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010C\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020;2\b\u0010#\u001a\u0004\u0018\u00010 H\u0002J\b\u0010D\u001a\u00020\u0013H\u0002J6\u0010\u001d\u001a\u00020\u00002.\u0010E\u001a*\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$0\u001e\u00a2\u0006\u0002\b%J6\u0010(\u001a\u00020\u00002.\u0010E\u001a*\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$0\u001e\u00a2\u0006\u0002\b%J6\u0010*\u001a\u00020\u00002.\u0010E\u001a*\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$0\u001e\u00a2\u0006\u0002\b%J\b\u0010F\u001a\u00020$H\u0014J6\u0010,\u001a\u00020\u00002.\u0010E\u001a*\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$0\u001e\u00a2\u0006\u0002\b%J6\u0010.\u001a\u00020\u00002.\u0010E\u001a*\u0012\u0004\u0012\u00020\u0000\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$0\u001e\u00a2\u0006\u0002\b%J\u0006\u0010G\u001a\u00020$J\u0012\u0010H\u001a\u00020$2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010 J\u0010\u0010I\u001a\u00020$2\u0006\u0010<\u001a\u00020;H\u0002J\u0016\u0010J\u001a\u00020$2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020$0KH\u0002J\u000e\u0010L\u001a\u00020$2\u0006\u0010M\u001a\u00020\u001fJ\u0014\u0010N\u001a\u00020\u00002\f\b\u0001\u0010O\u001a\u000200\"\u00020\u0007J\u0012\u0010P\u001a\u00020$2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010 J\u0012\u0010Q\u001a\u00020$2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010 J\u0012\u0010R\u001a\u00020$2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010 J&\u0010S\u001a\u00020$2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010T\u001a\u00020\u00132\b\b\u0002\u0010G\u001a\u00020\u0013J\u001c\u0010U\u001a\u00020$2\u0006\u0010<\u001a\u00020;2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010 H\u0002J\u0006\u0010B\u001a\u00020\u0013R&\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R&\u0010\u001a\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00078F@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u000eR@\u0010\u001d\u001a,\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$\u0018\u00010\u001e\u00a2\u0006\u0002\b%8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R@\u0010(\u001a,\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$\u0018\u00010\u001e\u00a2\u0006\u0002\b%8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R@\u0010*\u001a,\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$\u0018\u00010\u001e\u00a2\u0006\u0002\b%8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R@\u0010,\u001a,\u0012\u0004\u0012\u00020\u001f\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$\u0018\u00010\u001e\u00a2\u0006\u0002\b%8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010'R8\u0010.\u001a,\u0012\u0004\u0012\u00020\u0000\u0012\u0015\u0012\u0013\u0018\u00010 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$\u0018\u00010\u001e\u00a2\u0006\u0002\b%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\u0004\u0018\u0001008BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001e\u0010<\u001a\u00020;2\u0006\u0010:\u001a\u00020;@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001a\u0010?\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020A0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/drake/statelayout/StateLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "emptyLayout", "getEmptyLayout", "()I", "setEmptyLayout", "(I)V", "errorLayout", "getErrorLayout", "setErrorLayout", "isNetworkingRetry", "", "()Z", "setNetworkingRetry", "(Z)V", "loaded", "getLoaded", "setLoaded", "loadingLayout", "getLoadingLayout", "setLoadingLayout", "onContent", "Lkotlin/Function2;", "Landroid/view/View;", "", "Lkotlin/ParameterName;", "name", "tag", "", "Lkotlin/ExtensionFunctionType;", "getOnContent", "()Lkotlin/jvm/functions/Function2;", "onEmpty", "getOnEmpty", "onError", "getOnError", "onLoading", "getOnLoading", "onRefresh", "retryIds", "", "getRetryIds", "()[I", "stateChanged", "stateChangedHandler", "Lcom/drake/statelayout/StateChangedHandler;", "getStateChangedHandler", "()Lcom/drake/statelayout/StateChangedHandler;", "setStateChangedHandler", "(Lcom/drake/statelayout/StateChangedHandler;)V", "<set-?>", "Lcom/drake/statelayout/Status;", "status", "getStatus", "()Lcom/drake/statelayout/Status;", "statusContainer", "Landroid/util/ArrayMap;", "Lcom/drake/statelayout/StatusInfo;", "trigger", "getStatusView", "isNetworking", "block", "onFinishInflate", "refresh", "refreshing", "removeStatus", "runMain", "Lkotlin/Function0;", "setContent", "view", "setRetryIds", "ids", "showContent", "showEmpty", "showError", "showLoading", "silent", "showStatus", "statelayout_release"})
public final class StateLayout
extends FrameLayout {
    @NotNull
    private final ArrayMap<Status, StatusInfo> statusContainer;
    private boolean stateChanged;
    private boolean trigger;
    @Nullable
    private int[] retryIds;
    @Nullable
    private Function2<? super View, Object, Unit> onEmpty;
    @Nullable
    private Function2<? super View, Object, Unit> onError;
    @Nullable
    private Function2<? super View, Object, Unit> onContent;
    @Nullable
    private Function2<? super View, Object, Unit> onLoading;
    @Nullable
    private Function2<? super StateLayout, Object, Unit> onRefresh;
    private boolean loaded;
    private boolean isNetworkingRetry;
    @NotNull
    private Status status;
    @LayoutRes
    private int errorLayout;
    @LayoutRes
    private int emptyLayout;
    @LayoutRes
    private int loadingLayout;
    @NotNull
    private StateChangedHandler stateChangedHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public StateLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.statusContainer = new ArrayMap();
        this.isNetworkingRetry = StateConfig.INSTANCE.isNetworkingRetry();
        this.status = Status.CONTENT;
        this.errorLayout = -1;
        this.emptyLayout = -1;
        this.loadingLayout = -1;
        this.stateChangedHandler = StateConfig.getStateChangedHandler();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StateLayout);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026 R.styleable.StateLayout)");
        TypedArray attributes = typedArray;
        try {
            this.setEmptyLayout(attributes.getResourceId(R.styleable.StateLayout_empty_layout, -1));
            this.setErrorLayout(attributes.getResourceId(R.styleable.StateLayout_error_layout, -1));
            this.setLoadingLayout(attributes.getResourceId(R.styleable.StateLayout_loading_layout, -1));
        }
        finally {
            attributes.recycle();
        }
    }

    public /* synthetic */ StateLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final int[] getRetryIds() {
        int[] nArray = this.retryIds;
        if (this.retryIds == null) {
            nArray = StateConfig.INSTANCE.getRetryIds$statelayout_release();
        }
        return nArray;
    }

    private final Function2<View, Object, Unit> getOnEmpty() {
        Function2<? super View, Object, Unit> function2 = this.onEmpty;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnEmpty$statelayout_release();
        }
        return function2;
    }

    private final Function2<View, Object, Unit> getOnError() {
        Function2<? super View, Object, Unit> function2 = this.onError;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnError$statelayout_release();
        }
        return function2;
    }

    private final Function2<View, Object, Unit> getOnContent() {
        Function2<? super View, Object, Unit> function2 = this.onContent;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnContent$statelayout_release();
        }
        return function2;
    }

    private final Function2<View, Object, Unit> getOnLoading() {
        Function2<? super View, Object, Unit> function2 = this.onLoading;
        if (function2 == null) {
            function2 = StateConfig.INSTANCE.getOnLoading$statelayout_release();
        }
        return function2;
    }

    public final boolean getLoaded() {
        return this.loaded;
    }

    public final void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public final boolean isNetworkingRetry() {
        return this.isNetworkingRetry;
    }

    public final void setNetworkingRetry(boolean bl) {
        this.isNetworkingRetry = bl;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final int getErrorLayout() {
        return this.errorLayout == -1 ? StateConfig.getErrorLayout() : this.errorLayout;
    }

    public final void setErrorLayout(int value) {
        if (this.errorLayout != value) {
            this.removeStatus(Status.ERROR);
            this.errorLayout = value;
        }
    }

    public final int getEmptyLayout() {
        return this.emptyLayout == -1 ? StateConfig.getEmptyLayout() : this.emptyLayout;
    }

    public final void setEmptyLayout(int value) {
        if (this.emptyLayout != value) {
            this.removeStatus(Status.EMPTY);
            this.emptyLayout = value;
        }
    }

    public final int getLoadingLayout() {
        return this.loadingLayout == -1 ? StateConfig.getLoadingLayout() : this.loadingLayout;
    }

    public final void setLoadingLayout(int value) {
        if (this.loadingLayout != value) {
            this.removeStatus(Status.LOADING);
            this.loadingLayout = value;
        }
    }

    @NotNull
    public final StateChangedHandler getStateChangedHandler() {
        return this.stateChangedHandler;
    }

    public final void setStateChangedHandler(@NotNull StateChangedHandler stateChangedHandler) {
        Intrinsics.checkNotNullParameter((Object)stateChangedHandler, (String)"<set-?>");
        this.stateChangedHandler = stateChangedHandler;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 1 || this.getChildCount() == 0) {
            throw new UnsupportedOperationException("StateLayout only have one child view");
        }
        if (this.statusContainer.size() == 0) {
            View view = this.getChildAt(0);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            this.setContent(view);
        }
    }

    @NotNull
    public final StateLayout onLoading(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onLoading_u24lambda_u2d0 = stateLayout = this;
        boolean bl = false;
        $this$onLoading_u24lambda_u2d0.onLoading = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onEmpty(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onEmpty_u24lambda_u2d1 = stateLayout = this;
        boolean bl = false;
        $this$onEmpty_u24lambda_u2d1.onEmpty = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onError(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onError_u24lambda_u2d2 = stateLayout = this;
        boolean bl = false;
        $this$onError_u24lambda_u2d2.onError = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onRefresh(@NotNull Function2<? super StateLayout, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onRefresh_u24lambda_u2d3 = stateLayout = this;
        boolean bl = false;
        $this$onRefresh_u24lambda_u2d3.onRefresh = block;
        return stateLayout;
    }

    @NotNull
    public final StateLayout onContent(@NotNull Function2<? super View, Object, Unit> block) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StateLayout $this$onContent_u24lambda_u2d4 = stateLayout = this;
        boolean bl = false;
        $this$onContent_u24lambda_u2d4.onContent = block;
        return stateLayout;
    }

    public final void showLoading(@Nullable Object tag, boolean silent, boolean refresh) {
        block5: {
            if (silent && refresh) {
                Function2<? super StateLayout, Object, Unit> function2 = this.onRefresh;
                if (function2 != null) {
                    function2.invoke((Object)this, tag);
                }
                return;
            }
            if (this.status == Status.LOADING) {
                Function2<View, Object, Unit> function2 = this.getOnLoading();
                if (function2 != null) {
                    function2.invoke((Object)this.getStatusView(Status.LOADING, tag), tag);
                }
                return;
            }
            this.showStatus(Status.LOADING, tag);
            if (!refresh) break block5;
            Function2<? super StateLayout, Object, Unit> function2 = this.onRefresh;
            if (function2 != null) {
                function2.invoke((Object)this, tag);
            }
        }
    }

    public static /* synthetic */ void showLoading$default(StateLayout stateLayout, Object object, boolean bl, boolean bl2, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        stateLayout.showLoading(object, bl, bl2);
    }

    public final void refresh() {
        StateLayout.showLoading$default(this, null, true, false, 5, null);
    }

    public final void refreshing(@Nullable Object tag) {
        if (this.loaded) {
            this.refresh();
        } else {
            StateLayout.showLoading$default(this, tag, false, false, 6, null);
        }
    }

    public static /* synthetic */ void refreshing$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.refreshing(object);
    }

    public final void showEmpty(@Nullable Object tag) {
        this.showStatus(Status.EMPTY, tag);
    }

    public static /* synthetic */ void showEmpty$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.showEmpty(object);
    }

    public final void showError(@Nullable Object tag) {
        this.showStatus(Status.ERROR, tag);
    }

    public static /* synthetic */ void showError$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.showError(object);
    }

    public final void showContent(@Nullable Object tag) {
        if (this.trigger && this.stateChanged) {
            return;
        }
        this.showStatus(Status.CONTENT, tag);
        this.loaded = true;
    }

    public static /* synthetic */ void showContent$default(StateLayout stateLayout, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        stateLayout.showContent(object);
    }

    @NotNull
    public final StateLayout setRetryIds(int ... ids) {
        StateLayout stateLayout;
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        StateLayout $this$setRetryIds_u24lambda_u2d5 = stateLayout = this;
        boolean bl = false;
        $this$setRetryIds_u24lambda_u2d5.retryIds = ids;
        return stateLayout;
    }

    public final boolean trigger() {
        boolean bl = this.trigger = !this.trigger;
        if (!this.trigger) {
            this.stateChanged = false;
        }
        return this.trigger;
    }

    private final void showStatus(Status status, Object tag) {
        if (this.trigger) {
            this.stateChanged = true;
        }
        if (this.status == status) {
            return;
        }
        Status previousStatus = this.status;
        this.status = status;
        this.runMain((Function0<Unit>)((Function0)new Function0<Unit>(this, status, tag, previousStatus){
            final /* synthetic */ StateLayout this$0;
            final /* synthetic */ Status $status;
            final /* synthetic */ Object $tag;
            final /* synthetic */ Status $previousStatus;
            {
                this.this$0 = $receiver;
                this.$status = $status;
                this.$tag = $tag;
                this.$previousStatus = $previousStatus;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Map $this$filter$iv;
                    View targetStatusView = StateLayout.access$getStatusView(this.this$0, this.$status, this.$tag);
                    Map map = (Map)StateLayout.access$getStatusContainer$p(this.this$0);
                    Object object = this.$status;
                    boolean $i$f$filter = false;
                    void var5_7 = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$filterTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv$iv;
                        Map.Entry<K, V> it = element$iv$iv = iterator.next();
                        boolean bl = false;
                        if (!(it.getKey() != object)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    $this$filter$iv = destination$iv$iv;
                    object = this.$previousStatus;
                    StateLayout stateLayout = this.this$0;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = iterator2.next();
                        boolean bl = false;
                        StatusInfo statusBundle = (StatusInfo)it.getValue();
                        if (it.getKey() != object) continue;
                        StateChangedHandler stateChangedHandler = stateLayout.getStateChangedHandler();
                        View view = statusBundle.getView();
                        K k = it.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                        stateChangedHandler.onRemove(stateLayout, view, (Status)((Object)k), statusBundle.getTag());
                    }
                    this.this$0.getStateChangedHandler().onAdd(this.this$0, targetStatusView, this.$status, this.$tag);
                    if (this.$status == Status.EMPTY || this.$status == Status.ERROR) {
                        int[] nArray = StateLayout.access$getRetryIds(this.this$0);
                        if (nArray != null) {
                            void $this$forEach$iv2;
                            object = nArray;
                            stateLayout = this.this$0;
                            $i$f$forEach = false;
                            int n = ((void)$this$forEach$iv2).length;
                            for (int i = 0; i < n; ++i) {
                                View view;
                                void element$iv;
                                void it = element$iv = $this$forEach$iv2[i];
                                boolean bl = false;
                                View view2 = view = targetStatusView.findViewById((int)it);
                                if (view2 != null) {
                                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById<View>(it)");
                                    ThrottleClickKt.throttleClick$default(view, 0L, null, (Function1)new Function1<View, Unit>(stateLayout){
                                        final /* synthetic */ StateLayout this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull View $this$throttleClick) {
                                            Intrinsics.checkNotNullParameter((Object)$this$throttleClick, (String)"$this$throttleClick");
                                            StatusInfo statusInfo = (StatusInfo)StateLayout.access$getStatusContainer$p(this.this$0).get((Object)((Object)Status.LOADING));
                                            StateLayout.showLoading$default(this.this$0, statusInfo != null ? statusInfo.getTag() : null, this.this$0.isNetworkingRetry() && !StateLayout.access$isNetworking(this.this$0), false, 4, null);
                                        }
                                    }, 3, null);
                                }
                            }
                        }
                    }
                    switch (showStatus.WhenMappings.$EnumSwitchMapping$0[this.$status.ordinal()]) {
                        case 1: {
                            Function2 function2 = StateLayout.access$getOnEmpty(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                            }
                            break;
                        }
                        case 2: {
                            Function2 function2 = StateLayout.access$getOnError(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                            }
                            break;
                        }
                        case 3: {
                            Function2 function2 = StateLayout.access$getOnLoading(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                            }
                            break;
                        }
                        case 4: {
                            Function2 function2 = StateLayout.access$getOnContent(this.this$0);
                            if (function2 != null) {
                                function2.invoke((Object)targetStatusView, this.$tag);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.e((String)((Object)((Object)this.this$0)).getClass().getSimpleName(), (String)"", (Throwable)e);
                }
            }
        }));
    }

    static /* synthetic */ void showStatus$default(StateLayout stateLayout, Status status, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        stateLayout.showStatus(status, object);
    }

    private final void removeStatus(Status status) {
        this.statusContainer.remove((Object)status);
    }

    private final View getStatusView(Status status, Object tag) throws NullPointerException {
        int n;
        StatusInfo statusInfo = (StatusInfo)this.statusContainer.get((Object)status);
        if (statusInfo != null) {
            StatusInfo it = statusInfo;
            boolean bl = false;
            it.setTag(tag);
            return it.getView();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                n = this.getEmptyLayout();
                break;
            }
            case 2: {
                n = this.getErrorLayout();
                break;
            }
            case 3: {
                n = this.getLoadingLayout();
                break;
            }
            case 4: {
                n = -1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int layoutId = n;
        if (layoutId == -1) {
            switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 2: {
                    throw new Resources.NotFoundException("No StateLayout errorLayout is set");
                }
                case 1: {
                    throw new Resources.NotFoundException("No StateLayout emptyLayout is set");
                }
                case 3: {
                    throw new Resources.NotFoundException("No StateLayout loadingLayout is set");
                }
                case 4: {
                    throw new Resources.NotFoundException("No StateLayout contentView is set");
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(layoutId, (ViewGroup)this, false);
        Map map = (Map)this.statusContainer;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        map.put(status, new StatusInfo(view, tag));
        return view;
    }

    public final void setContent(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ((Map)this.statusContainer).put(Status.CONTENT, new StatusInfo(view, null));
    }

    private final boolean isNetworking() {
        boolean bl;
        Object object = this.getContext().getApplicationContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        try {
            boolean bl2;
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                if (network == null) {
                    return false;
                }
                Network network2 = network;
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network2);
                if (networkCapabilities == null) {
                    return false;
                }
                NetworkCapabilities actNw = networkCapabilities;
                bl2 = actNw.hasTransport(1) ? true : (actNw.hasTransport(0) ? true : actNw.hasTransport(3));
            } else {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                bl2 = networkInfo != null ? networkInfo.isConnected() : false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            bl = true;
        }
        return bl;
    }

    private final void runMain(Function0<Unit> block) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            block.invoke();
        } else {
            new Handler(Looper.getMainLooper()).post(() -> StateLayout.runMain$lambda-7(block));
        }
    }

    @JvmOverloads
    public StateLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StateLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void runMain$lambda-7(Function0 $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        $block.invoke();
    }

    public static final /* synthetic */ View access$getStatusView(StateLayout $this, Status status, Object tag) {
        return $this.getStatusView(status, tag);
    }

    public static final /* synthetic */ ArrayMap access$getStatusContainer$p(StateLayout $this) {
        return $this.statusContainer;
    }

    public static final /* synthetic */ int[] access$getRetryIds(StateLayout $this) {
        return $this.getRetryIds();
    }

    public static final /* synthetic */ Function2 access$getOnEmpty(StateLayout $this) {
        return $this.getOnEmpty();
    }

    public static final /* synthetic */ Function2 access$getOnError(StateLayout $this) {
        return $this.getOnError();
    }

    public static final /* synthetic */ Function2 access$getOnLoading(StateLayout $this) {
        return $this.getOnLoading();
    }

    public static final /* synthetic */ Function2 access$getOnContent(StateLayout $this) {
        return $this.getOnContent();
    }

    public static final /* synthetic */ boolean access$isNetworking(StateLayout $this) {
        return $this.isNetworking();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.EMPTY.ordinal()] = 1;
            nArray[Status.ERROR.ordinal()] = 2;
            nArray[Status.LOADING.ordinal()] = 3;
            nArray[Status.CONTENT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

