/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.utils;

import com.drake.net.Net;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u001d\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a)\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\u0010\f\u001a-\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\u0003\"\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"chooseTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustManagers", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)Ljavax/net/ssl/X509TrustManager;", "prepareKeyManager", "Ljavax/net/ssl/KeyManager;", "bksFile", "Ljava/io/InputStream;", "password", "", "(Ljava/io/InputStream;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "prepareTrustManager", "certificates", "([Ljava/io/InputStream;)[Ljavax/net/ssl/TrustManager;", "net_release"})
public final class HttpsKt {
    @Nullable
    public static final KeyManager[] prepareKeyManager(@Nullable InputStream bksFile, @Nullable String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            clientKeyStore.load(bksFile, cArray);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] cArray2 = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
            kmf.init(clientKeyStore, cArray2);
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            Net.debug(e);
            return null;
        }
    }

    @Nullable
    public static final TrustManager[] prepareTrustManager(InputStream ... certificates) {
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        if (certificates.length == 0) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            int n = certificates.length;
            for (int i = 0; i < n; ++i) {
                int index = i;
                InputStream certStream = certificates[i];
                String certificateAlias = String.valueOf(index);
                Certificate cert = certificateFactory.generateCertificate(certStream);
                keyStore.setCertificateEntry(certificateAlias, cert);
                try {
                    InputStream inputStream = certStream;
                    if (inputStream == null) continue;
                    inputStream.close();
                    continue;
                }
                catch (IOException e) {
                    Net.debug(e);
                }
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            Net.debug(e);
            return null;
        }
    }

    @Nullable
    public static final X509TrustManager chooseTrustManager(@NotNull TrustManager[] trustManagers) {
        Intrinsics.checkNotNullParameter((Object)trustManagers, (String)"trustManagers");
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }
}

