/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.interceptor;

import androidx.annotation.IntRange;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Lcom/drake/net/interceptor/RetryInterceptor;", "Lokhttp3/Interceptor;", "retryCount", "", "(I)V", "getRetryCount", "()I", "setRetryCount", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "net_release"})
public final class RetryInterceptor
implements Interceptor {
    private int retryCount;

    public RetryInterceptor(@IntRange(from=1L) int retryCount) {
        this.retryCount = retryCount;
    }

    public /* synthetic */ RetryInterceptor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n);
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final void setRetryCount(int n) {
        this.retryCount = n;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = chain.proceed(request);
        for (int retryCount = 0; !response.isSuccessful() && retryCount < this.retryCount; ++retryCount) {
            Util.closeQuietly((Closeable)((Closeable)response));
            response = chain.proceed(request);
        }
        return response;
    }

    public RetryInterceptor() {
        this(0, 1, null);
    }
}

