/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.component;

import android.content.Context;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.text.format.Formatter;
import com.drake.net.NetConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020\u001fJ\b\u0010&\u001a\u00020\u001fH\u0016J\u0006\u0010'\u001a\u00020\u001fJ\u0006\u0010(\u001a\u00020\u001fJ\u0006\u0010)\u001a\u00020\u0004R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001c\u0010\u0016\u001a\u00020\u00048FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007R$\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0007\"\u0004\b\u001d\u0010\t\u00a8\u0006*"}, d2={"Lcom/drake/net/component/Progress;", "", "()V", "<set-?>", "", "currentByteCount", "getCurrentByteCount", "()J", "setCurrentByteCount$net_release", "(J)V", "", "finish", "getFinish", "()Z", "setFinish$net_release", "(Z)V", "intervalByteCount", "getIntervalByteCount", "setIntervalByteCount$net_release", "intervalTime", "getIntervalTime", "setIntervalTime$net_release", "speedBytes", "getSpeedBytes", "setSpeedBytes", "startElapsedRealtime", "getStartElapsedRealtime", "totalByteCount", "getTotalByteCount", "setTotalByteCount$net_release", "currentSize", "", "progress", "", "remainSize", "remainTime", "remainTimeSeconds", "speedSize", "toString", "totalSize", "useTime", "useTimeSeconds", "net_release"})
public final class Progress {
    private long currentByteCount;
    private long totalByteCount;
    private long intervalByteCount;
    private long intervalTime;
    private boolean finish;
    private final long startElapsedRealtime = SystemClock.elapsedRealtime();
    private long speedBytes;

    public final long getCurrentByteCount() {
        return this.currentByteCount;
    }

    public final void setCurrentByteCount$net_release(long l) {
        this.currentByteCount = l;
    }

    public final long getTotalByteCount() {
        return this.totalByteCount;
    }

    public final void setTotalByteCount$net_release(long l) {
        this.totalByteCount = l;
    }

    public final long getIntervalByteCount() {
        return this.intervalByteCount;
    }

    public final void setIntervalByteCount$net_release(long l) {
        this.intervalByteCount = l;
    }

    public final long getIntervalTime() {
        return this.intervalTime;
    }

    public final void setIntervalTime$net_release(long l) {
        this.intervalTime = l;
    }

    public final boolean getFinish() {
        return this.finish;
    }

    public final void setFinish$net_release(boolean bl) {
        this.finish = bl;
    }

    public final long getStartElapsedRealtime() {
        return this.startElapsedRealtime;
    }

    public final long getSpeedBytes() {
        return this.intervalTime <= 0L || this.intervalByteCount <= 0L ? this.speedBytes : (this.speedBytes = this.intervalByteCount * (long)1000 / this.intervalTime);
    }

    public final void setSpeedBytes(long l) {
        this.speedBytes = l;
    }

    @NotNull
    public String toString() {
        return "Progress(currentByteCount=" + this.currentByteCount + ", totalByteCount=" + this.totalByteCount + ", finish=" + this.finish + ')';
    }

    @NotNull
    public final String totalSize() {
        long totalBytes = this.totalByteCount <= 0L ? 0L : this.totalByteCount;
        String string2 = Formatter.formatFileSize((Context)NetConfig.INSTANCE.getApp(), (long)totalBytes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(NetConfig.app, totalBytes)");
        return string2;
    }

    @NotNull
    public final String currentSize() {
        String string2 = Formatter.formatFileSize((Context)NetConfig.INSTANCE.getApp(), (long)this.currentByteCount);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(NetConfig.app, currentByteCount)");
        return string2;
    }

    @NotNull
    public final String remainSize() {
        long remain = this.totalByteCount <= 0L ? 0L : this.totalByteCount - this.currentByteCount;
        String string2 = Formatter.formatFileSize((Context)NetConfig.INSTANCE.getApp(), (long)remain);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(NetConfig.app, remain)");
        return string2;
    }

    @NotNull
    public final String speedSize() {
        String string2 = Formatter.formatFileSize((Context)NetConfig.INSTANCE.getApp(), (long)this.getSpeedBytes());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(NetConfig.app, speedBytes)");
        return string2;
    }

    public final int progress() {
        return this.finish || this.currentByteCount == this.totalByteCount ? 100 : (this.totalByteCount <= 0L ? 0 : (int)(this.currentByteCount * (long)100 / this.totalByteCount));
    }

    @NotNull
    public final String useTime() {
        String string2 = DateUtils.formatElapsedTime((long)((SystemClock.elapsedRealtime() - this.startElapsedRealtime) / (long)1000));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatElapsedTime((Syste\u2026tElapsedRealtime) / 1000)");
        return string2;
    }

    public final long useTimeSeconds() {
        return (SystemClock.elapsedRealtime() - this.startElapsedRealtime) / (long)1000;
    }

    @NotNull
    public final String remainTime() {
        long speedBytes = this.getSpeedBytes();
        long remainSeconds = this.totalByteCount <= 0L || speedBytes <= 0L ? 0L : (this.totalByteCount - this.currentByteCount) / speedBytes;
        String string2 = DateUtils.formatElapsedTime((long)remainSeconds);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatElapsedTime(remainSeconds)");
        return string2;
    }

    public final long remainTimeSeconds() {
        long speedBytes = this.getSpeedBytes();
        return this.totalByteCount <= 0L || speedBytes <= 0L ? 0L : (this.totalByteCount - this.currentByteCount) / speedBytes;
    }
}

