/*
 * Decompiled with CFR 0.152.
 */
package com.drake.net.interceptor;

import com.drake.net.NetConfig;
import com.drake.net.body.BodyExtensionKt;
import com.drake.net.body.NetRequestBody;
import com.drake.net.body.NetResponseBody;
import com.drake.net.cache.CacheMode;
import com.drake.net.cache.ForceCache;
import com.drake.net.exception.HttpFailureException;
import com.drake.net.exception.NetConnectException;
import com.drake.net.exception.NetException;
import com.drake.net.exception.NetSocketTimeoutException;
import com.drake.net.exception.NetUnknownHostException;
import com.drake.net.exception.NoCacheException;
import com.drake.net.tag.NetTag;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/drake/net/interceptor/NetOkHttpInterceptor;", "Lokhttp3/Interceptor;", "()V", "appendRunningCall", "", "chain", "Lokhttp3/Interceptor$Chain;", "intercept", "Lokhttp3/Response;", "removeRunningCall", "net_release"})
public final class NetOkHttpInterceptor
implements Interceptor {
    @NotNull
    public static final NetOkHttpInterceptor INSTANCE = new NetOkHttpInterceptor();

    private NetOkHttpInterceptor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Response response2;
        NetRequestBody netRequestBody;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        RequestBody requestBody = request.body();
        if (requestBody != null) {
            Request $this$tagOf$iv = request;
            boolean $i$f$tagOf = false;
            netRequestBody = BodyExtensionKt.toNetRequestBody(requestBody, (ConcurrentLinkedQueue)$this$tagOf$iv.tag(NetTag.UploadListeners.class));
        } else {
            netRequestBody = null;
        }
        NetRequestBody reqBody = netRequestBody;
        Request $this$tagOf$iv = request;
        boolean $i$f$tagOf = false;
        ForceCache forceCache = (ForceCache)$this$tagOf$iv.tag(ForceCache.class);
        if (forceCache == null) {
            forceCache = NetConfig.INSTANCE.getForceCache$net_release();
        }
        ForceCache cache = forceCache;
        $this$tagOf$iv = request;
        $i$f$tagOf = false;
        CacheMode cacheMode = (CacheMode)((Object)$this$tagOf$iv.tag(CacheMode.class));
        Request $this$intercept_u24lambda_u2d0 = $this$tagOf$iv = request.newBuilder();
        boolean bl = false;
        if (cache != null && cacheMode != null) {
            $this$intercept_u24lambda_u2d0.cacheControl(new CacheControl.Builder().noCache().noStore().build());
        }
        request = $this$tagOf$iv.method(request.method(), (RequestBody)reqBody).build();
        Response response3 = null;
        try {
            NetResponseBody netResponseBody;
            Response response4;
            this.appendRunningCall(chain);
            if (cache != null) {
                CacheMode cacheMode2 = cacheMode;
                switch (cacheMode2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cacheMode2.ordinal()]) {
                    case 1: {
                        response4 = cache.get$net_release(request);
                        if (response4 != null) break;
                        throw new NoCacheException(request, null, null, 6, null);
                    }
                    case 2: {
                        response4 = cache.get$net_release(request);
                        if (response4 != null) break;
                        Response $this$intercept_u24lambda_u2d1 = chain.proceed(request);
                        boolean bl2 = false;
                        response4 = cache.put$net_release($this$intercept_u24lambda_u2d1);
                        break;
                    }
                    case 3: {
                        Response response5;
                        try {
                            Response $this$intercept_u24lambda_u2d2 = chain.proceed(request);
                            boolean bl3 = false;
                            response5 = cache.put$net_release($this$intercept_u24lambda_u2d2);
                        }
                        catch (Exception e) {
                            Response response6 = cache.get$net_release(request);
                            if (response6 == null) {
                                throw new NoCacheException(request, null, null, 6, null);
                            }
                            response5 = response6;
                        }
                        response4 = response5;
                        break;
                    }
                    case 4: {
                        Response $this$intercept_u24lambda_u2d3 = chain.proceed(request);
                        boolean bl4 = false;
                        response4 = cache.put$net_release($this$intercept_u24lambda_u2d3);
                        break;
                    }
                    default: {
                        response4 = chain.proceed(request);
                        break;
                    }
                }
            } else {
                response4 = chain.proceed(request);
            }
            response3 = response4;
            ResponseBody responseBody = response3.body();
            if (responseBody != null) {
                Request $this$tagOf$iv2 = request;
                boolean $i$f$tagOf2 = false;
                netResponseBody = BodyExtensionKt.toNetResponseBody(responseBody, (ConcurrentLinkedQueue)$this$tagOf$iv2.tag(NetTag.DownloadListeners.class), (Function0<Unit>)((Function0)new Function0<Unit>(chain){
                    final /* synthetic */ Interceptor.Chain $chain;
                    {
                        this.$chain = $chain;
                        super(0);
                    }

                    public final void invoke() {
                        NetOkHttpInterceptor.access$removeRunningCall(NetOkHttpInterceptor.INSTANCE, this.$chain);
                    }
                }));
            } else {
                netResponseBody = null;
            }
            NetResponseBody respBody2 = netResponseBody;
            response2 = response3 = response3.newBuilder().body((ResponseBody)respBody2).build();
            response = response3;
        }
        catch (SocketTimeoutException e) {
            try {
                throw new NetSocketTimeoutException(request, e.getMessage(), e);
                catch (ConnectException e2) {
                    throw new NetConnectException(request, null, e2, 2, null);
                }
                catch (UnknownHostException e3) {
                    throw new NetUnknownHostException(request, e3.getMessage(), null, 4, null);
                }
                catch (NetException e4) {
                    throw e4;
                }
                catch (Throwable e5) {
                    throw new HttpFailureException(request, null, e5, 2, null);
                }
            }
            catch (Throwable throwable) {
                Response response7 = response3;
                if ((response7 != null ? response7.body() : null) == null) {
                    this.removeRunningCall(chain);
                }
                throw throwable;
            }
        }
        if ((response != null ? response.body() : null) == null) {
            this.removeRunningCall(chain);
        }
        return response2;
    }

    private final void appendRunningCall(Interceptor.Chain chain) {
        NetConfig.INSTANCE.getRunningCalls().add(new WeakReference<Call>(chain.call()));
    }

    private final void removeRunningCall(Interceptor.Chain chain) {
        Iterator<WeakReference<Call>> iterator = NetConfig.INSTANCE.getRunningCalls().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"NetConfig.runningCalls.iterator()");
        Iterator<WeakReference<Call>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Call call = (Call)iterator2.next().get();
            if (call == null) {
                iterator2.remove();
                continue;
            }
            if (!Intrinsics.areEqual((Object)call, (Object)chain.call())) continue;
            iterator2.remove();
            return;
        }
    }

    public static final /* synthetic */ void access$removeRunningCall(NetOkHttpInterceptor $this, Interceptor.Chain chain) {
        $this.removeRunningCall(chain);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CacheMode.values().length];
            nArray[CacheMode.READ.ordinal()] = 1;
            nArray[CacheMode.READ_THEN_REQUEST.ordinal()] = 2;
            nArray[CacheMode.REQUEST_THEN_READ.ordinal()] = 3;
            nArray[CacheMode.WRITE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

