/*
 * MIT License
 *
 * Copyright (c) 2023 劉強東 https://github.com/liangjingkanji
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.drake.brv.utils

object BRV {

    /**
     * 即item的layout布局中的<variable>标签内定义变量名称
     * 示例:
     * ```
     * <variable
     *      name="m"
     *      type="com.drake.brv.sample.model.CheckModel" />
     * ```
     * 则应在Application中的onCreate函数内设置:
     * `BRV.modelId = BR.m`
     */
    var modelId: Int = -1

    /**
     * 防抖动点击事件默认的间隔时间, 单位毫秒
     * @see com.drake.brv.BindingAdapter.onClick
     */
    var debounceClickInterval: Long = 500

    @Deprecated("命名规范", ReplaceWith("BRV.debounceClickInterval"), DeprecationLevel.ERROR)
    var clickThrottle: Long = 500

    /**
     * 启用item所有view点击事件共享防抖动间隔, BRV默认防抖动仅针对单个view
     * @see com.drake.brv.BindingAdapter.onClick
     */
    var debounceGlobalEnabled: Boolean = false

    /**
     * 此变量用于支持全局控件防抖动
     * @see com.drake.brv.BindingAdapter.onClick
     * @see debounceGlobalEnabled 要求先启用全局共享防抖动
     */
    var lastDebounceClickTime: Long = 0
}