/*
 * Decompiled with CFR 0.152.
 */
package com.drake.brv.listener;

import android.graphics.Canvas;
import android.view.View;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.drake.brv.BindingAdapter;
import com.drake.brv.item.ItemDrag;
import com.drake.brv.item.ItemSwipe;
import com.drake.brv.utils.RecyclerUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J@\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\n2\n\u0010\u001b\u001a\u00060\u0006R\u00020\u00072\n\u0010\u001c\u001a\u00060\u0006R\u00020\u0007H\u0016J \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u001a\u0010\u001e\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0018\u00010\u0006R\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/drake/brv/listener/DefaultItemTouchCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$Callback;", "()V", "lastActionState", "", "sourceViewHolder", "Lcom/drake/brv/BindingAdapter$BindingViewHolder;", "Lcom/drake/brv/BindingAdapter;", "targetViewHolder", "clearView", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getMovementFlags", "getSwipeThreshold", "", "onChildDraw", "c", "Landroid/graphics/Canvas;", "dX", "dY", "actionState", "isCurrentlyActive", "", "onDrag", "source", "target", "onMove", "onSelectedChanged", "onSwiped", "direction", "brv_release"})
public class DefaultItemTouchCallback
extends ItemTouchHelper.Callback {
    private int lastActionState;
    @Nullable
    private BindingAdapter.BindingViewHolder sourceViewHolder;
    @Nullable
    private BindingAdapter.BindingViewHolder targetViewHolder;

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        int headerCount;
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        RecyclerView.Adapter adapter = viewHolder.getBindingAdapter();
        BindingAdapter bindingAdapter = adapter instanceof BindingAdapter ? (BindingAdapter)adapter : null;
        if (bindingAdapter == null) {
            return;
        }
        BindingAdapter adapter2 = bindingAdapter;
        int layoutPosition = viewHolder.getLayoutPosition();
        if (layoutPosition < (headerCount = adapter2.getHeaderCount())) {
            adapter2.removeHeader(layoutPosition, true);
        } else {
            List<Object> models;
            List<Object> list = adapter2.getModels();
            List<Object> list2 = models = TypeIntrinsics.isMutableList(list) ? list : null;
            if (models != null) {
                models.remove(layoutPosition - headerCount);
                adapter2.notifyItemRemoved(layoutPosition);
            }
        }
    }

    public int getMovementFlags(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        int drag = 0;
        int swipe = 0;
        if (viewHolder instanceof BindingAdapter.BindingViewHolder) {
            Object model = ((BindingAdapter.BindingViewHolder)viewHolder).getModel();
            if (model instanceof ItemDrag) {
                drag = ((ItemDrag)model).getItemOrientationDrag();
            }
            if (model instanceof ItemSwipe) {
                swipe = ((ItemSwipe)model).getItemOrientationSwipe();
            }
        }
        return ItemTouchHelper.Callback.makeMovementFlags((int)drag, (int)swipe);
    }

    public void onChildDraw(@NotNull Canvas c, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        if (actionState == 1) {
            View swipeView = viewHolder.itemView.findViewWithTag((Object)"swipe");
            if (swipeView != null) {
                swipeView.setTranslationX(dX);
            } else {
                super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
            }
        } else {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }
    }

    public float getSwipeThreshold(@NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        return 1.0f;
    }

    public void clearView(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        super.clearView(recyclerView, viewHolder);
        View view = viewHolder.itemView.findViewWithTag((Object)"swipe");
        if (view != null) {
            view.setTranslationX(0.0f);
        }
    }

    public void onDrag(@NotNull BindingAdapter.BindingViewHolder source, @NotNull BindingAdapter.BindingViewHolder target) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
    }

    public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState == 0) {
            if (this.lastActionState == 2 && this.sourceViewHolder != null && this.targetViewHolder != null) {
                BindingAdapter.BindingViewHolder bindingViewHolder = this.sourceViewHolder;
                Intrinsics.checkNotNull((Object)((Object)bindingViewHolder));
                BindingAdapter.BindingViewHolder bindingViewHolder2 = this.targetViewHolder;
                Intrinsics.checkNotNull((Object)((Object)bindingViewHolder2));
                this.onDrag(bindingViewHolder, bindingViewHolder2);
            }
        } else {
            this.lastActionState = actionState;
        }
    }

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder source, @NotNull RecyclerView.ViewHolder target) {
        List<Object> models;
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        BindingAdapter bindingAdapter = RecyclerUtilsKt.getBindingAdapter(recyclerView);
        BindingAdapter bindingAdapter2 = bindingAdapter instanceof BindingAdapter ? bindingAdapter : null;
        if (bindingAdapter2 == null) {
            return false;
        }
        BindingAdapter adapter = bindingAdapter2;
        int currentPosition = recyclerView.getChildLayoutPosition(source.itemView);
        int targetPosition = recyclerView.getChildLayoutPosition(target.itemView);
        List<Object> list = adapter.getModels();
        List<Object> list2 = models = TypeIntrinsics.isMutableList(list) ? list : null;
        if (models != null && source instanceof BindingAdapter.BindingViewHolder && target instanceof BindingAdapter.BindingViewHolder) {
            int fromPosition = currentPosition - adapter.getHeaderCount();
            int toPosition = targetPosition - adapter.getHeaderCount();
            Object fromItem = models.get(fromPosition);
            models.remove(fromPosition);
            models.add(toPosition, fromItem);
            adapter.notifyItemMoved(currentPosition, targetPosition);
            this.sourceViewHolder = (BindingAdapter.BindingViewHolder)source;
            this.targetViewHolder = (BindingAdapter.BindingViewHolder)target;
        }
        return false;
    }
}

