/*
 * Decompiled with CFR 0.152.
 */
package com.drake.brv.layoutmanager;

import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.drake.brv.BindingAdapter;
import com.drake.brv.listener.OnHoverAttachListener;
import java.util.ArrayList;
import java.util.List;

public class HoverStaggeredGridLayoutManager
extends StaggeredGridLayoutManager {
    private BindingAdapter mAdapter;
    private float mTranslationX;
    private float mTranslationY;
    private List<Integer> mHeaderPositions = new ArrayList<Integer>(0);
    private RecyclerView.AdapterDataObserver mHeaderPositionsObserver = new HeaderPositionsAdapterDataObserver();
    private static final int INVALID_OFFSET = Integer.MIN_VALUE;
    private View mHover;
    private int mHoverPosition = -1;
    private int mPendingScrollPosition = -1;
    private int mPendingScrollOffset = 0;
    private boolean scrollEnabled = true;

    public HoverStaggeredGridLayoutManager(int spanCount, int orientation) {
        super(spanCount, orientation);
    }

    public HoverStaggeredGridLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public HoverStaggeredGridLayoutManager setScrollEnabled(boolean enabled) {
        this.scrollEnabled = enabled;
        return this;
    }

    public boolean canScrollHorizontally() {
        return super.canScrollHorizontally() && this.scrollEnabled;
    }

    public boolean canScrollVertically() {
        return super.canScrollVertically() && this.scrollEnabled;
    }

    public void setHoverTranslationY(float translationY) {
        this.mTranslationY = translationY;
        this.requestLayout();
    }

    public void setHoverTranslationX(float translationX) {
        this.mTranslationX = translationX;
        this.requestLayout();
    }

    public boolean isHover(View view) {
        return view == this.mHover;
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.setAdapter(view.getAdapter());
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        super.onAdapterChanged(oldAdapter, newAdapter);
        this.setAdapter(newAdapter);
    }

    private void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterAdapterDataObserver(this.mHeaderPositionsObserver);
        }
        if (adapter instanceof BindingAdapter) {
            this.mAdapter = (BindingAdapter)adapter;
            this.mAdapter.registerAdapterDataObserver(this.mHeaderPositionsObserver);
            this.mHeaderPositionsObserver.onChanged();
        } else {
            this.mAdapter = null;
            this.mHeaderPositions.clear();
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState();
        ss.superState = super.onSaveInstanceState();
        ss.pendingScrollPosition = this.mPendingScrollPosition;
        ss.pendingScrollOffset = this.mPendingScrollOffset;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState ss = (SavedState)state;
            this.mPendingScrollPosition = ss.pendingScrollPosition;
            this.mPendingScrollOffset = ss.pendingScrollOffset;
            state = ss.superState;
        }
        super.onRestoreInstanceState(state);
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachHover();
        int scrolled = super.scrollVerticallyBy(dy, recycler, state);
        this.attachHover();
        if (scrolled != 0) {
            this.updateHover(recycler, false);
        }
        return scrolled;
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachHover();
        int scrolled = super.scrollHorizontallyBy(dx, recycler, state);
        this.attachHover();
        if (scrolled != 0) {
            this.updateHover(recycler, false);
        }
        return scrolled;
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachHover();
        super.onLayoutChildren(recycler, state);
        this.attachHover();
        if (!state.isPreLayout()) {
            this.updateHover(recycler, true);
        }
    }

    public void scrollToPosition(int position) {
        this.scrollToPositionWithOffset(position, Integer.MIN_VALUE);
    }

    public void scrollToPositionWithOffset(int position, int offset) {
        this.scrollToPositionWithOffset(position, offset, true);
    }

    private void scrollToPositionWithOffset(int position, int offset, boolean adjustForHover) {
        this.setPendingScroll(-1, Integer.MIN_VALUE);
        if (!adjustForHover) {
            super.scrollToPositionWithOffset(position, offset);
            return;
        }
        int headerIndex = this.findHeaderIndexOrBefore(position);
        if (headerIndex == -1 || this.findHeaderIndex(position) != -1) {
            super.scrollToPositionWithOffset(position, offset);
            return;
        }
        if (this.findHeaderIndex(position - 1) != -1) {
            super.scrollToPositionWithOffset(position - 1, offset);
            return;
        }
        if (this.mHover != null && headerIndex == this.findHeaderIndex(this.mHoverPosition)) {
            int adjustedOffset = (offset != Integer.MIN_VALUE ? offset : 0) + this.mHover.getHeight();
            super.scrollToPositionWithOffset(position, adjustedOffset);
            return;
        }
        this.setPendingScroll(position, offset);
        super.scrollToPositionWithOffset(position, offset);
    }

    public int computeVerticalScrollExtent(RecyclerView.State state) {
        this.detachHover();
        int extent = super.computeVerticalScrollExtent(state);
        this.attachHover();
        return extent;
    }

    public int computeVerticalScrollOffset(RecyclerView.State state) {
        this.detachHover();
        int offset = super.computeVerticalScrollOffset(state);
        this.attachHover();
        return offset;
    }

    public int computeVerticalScrollRange(RecyclerView.State state) {
        this.detachHover();
        int range = super.computeVerticalScrollRange(state);
        this.attachHover();
        return range;
    }

    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        this.detachHover();
        int extent = super.computeHorizontalScrollExtent(state);
        this.attachHover();
        return extent;
    }

    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        this.detachHover();
        int offset = super.computeHorizontalScrollOffset(state);
        this.attachHover();
        return offset;
    }

    public int computeHorizontalScrollRange(RecyclerView.State state) {
        this.detachHover();
        int range = super.computeHorizontalScrollRange(state);
        this.attachHover();
        return range;
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        this.detachHover();
        PointF vector = super.computeScrollVectorForPosition(targetPosition);
        this.attachHover();
        return vector;
    }

    public View onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.detachHover();
        View view = super.onFocusSearchFailed(focused, focusDirection, recycler, state);
        this.attachHover();
        return view;
    }

    private void detachHover() {
        if (this.mHover != null) {
            this.detachView(this.mHover);
        }
    }

    private void attachHover() {
        if (this.mHover != null) {
            this.attachView(this.mHover);
        }
    }

    private void updateHover(RecyclerView.Recycler recycler, boolean layout) {
        int headerCount = this.mHeaderPositions.size();
        int childCount = this.getChildCount();
        if (headerCount > 0 && childCount > 0) {
            View anchorView = null;
            int anchorIndex = -1;
            int anchorPos = -1;
            for (int i = 0; i < childCount; ++i) {
                RecyclerView.LayoutParams params;
                View child = this.getChildAt(i);
                if (!this.isViewValidAnchor(child, params = (RecyclerView.LayoutParams)child.getLayoutParams())) continue;
                anchorView = child;
                anchorIndex = i;
                anchorPos = params.getViewAdapterPosition();
                break;
            }
            if (anchorView != null && anchorPos != -1) {
                int nextHeaderPos;
                int headerIndex = this.findHeaderIndexOrBefore(anchorPos);
                int headerPos = headerIndex != -1 ? this.mHeaderPositions.get(headerIndex) : -1;
                int n = nextHeaderPos = headerCount > headerIndex + 1 ? this.mHeaderPositions.get(headerIndex + 1) : -1;
                if (headerPos != -1 && (headerPos != anchorPos || this.isViewOnBoundary(anchorView)) && nextHeaderPos != headerPos + 1) {
                    if (this.mHover != null && this.getItemViewType(this.mHover) != this.mAdapter.getItemViewType(headerPos)) {
                        this.scrapHover(recycler);
                    }
                    if (this.mHover == null) {
                        this.createHover(recycler, headerPos);
                    }
                    if (layout || this.getPosition(this.mHover) != headerPos) {
                        this.bindHover(recycler, headerPos);
                    }
                    View nextHeaderView = null;
                    if (nextHeaderPos != -1 && (nextHeaderView = this.getChildAt(anchorIndex + (nextHeaderPos - anchorPos))) == this.mHover) {
                        nextHeaderView = null;
                    }
                    this.mHover.setTranslationX(this.getX(this.mHover, nextHeaderView));
                    this.mHover.setTranslationY(this.getY(this.mHover, nextHeaderView));
                    return;
                }
            }
        }
        if (this.mHover != null) {
            this.scrapHover(recycler);
        }
    }

    private void createHover(@NonNull RecyclerView.Recycler recycler, int position) {
        View hoverHeader = recycler.getViewForPosition(position);
        OnHoverAttachListener onHoverAttachListener = this.mAdapter.getOnHoverAttachListener();
        if (onHoverAttachListener != null) {
            onHoverAttachListener.attachHover(hoverHeader);
        }
        this.addView(hoverHeader);
        this.measureAndLayout(hoverHeader);
        this.ignoreView(hoverHeader);
        this.mHover = hoverHeader;
        this.mHoverPosition = position;
    }

    private void bindHover(@NonNull RecyclerView.Recycler recycler, int position) {
        recycler.bindViewToPosition(this.mHover, position);
        this.mHoverPosition = position;
        this.measureAndLayout(this.mHover);
        if (this.mPendingScrollPosition != -1) {
            final ViewTreeObserver vto = this.mHover.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    if (HoverStaggeredGridLayoutManager.this.mPendingScrollPosition != -1) {
                        HoverStaggeredGridLayoutManager.this.scrollToPositionWithOffset(HoverStaggeredGridLayoutManager.this.mPendingScrollPosition, HoverStaggeredGridLayoutManager.this.mPendingScrollOffset);
                        HoverStaggeredGridLayoutManager.this.setPendingScroll(-1, Integer.MIN_VALUE);
                    }
                }
            });
        }
    }

    private void measureAndLayout(View hoverHeader) {
        this.measureChildWithMargins(hoverHeader, 0, 0);
        if (this.getOrientation() == 1) {
            hoverHeader.layout(this.getPaddingLeft(), 0, this.getWidth() - this.getPaddingRight(), hoverHeader.getMeasuredHeight());
        } else {
            hoverHeader.layout(0, this.getPaddingTop(), hoverHeader.getMeasuredWidth(), this.getHeight() - this.getPaddingBottom());
        }
    }

    private void scrapHover(@Nullable RecyclerView.Recycler recycler) {
        View hoverHeader = this.mHover;
        this.mHover = null;
        this.mHoverPosition = -1;
        hoverHeader.setTranslationX(0.0f);
        hoverHeader.setTranslationY(0.0f);
        OnHoverAttachListener onHoverAttachListener = this.mAdapter.getOnHoverAttachListener();
        if (onHoverAttachListener != null) {
            onHoverAttachListener.detachHover(hoverHeader);
        }
        this.stopIgnoringView(hoverHeader);
        this.removeView(hoverHeader);
        if (recycler != null) {
            recycler.recycleView(hoverHeader);
        }
    }

    private boolean isViewValidAnchor(View view, RecyclerView.LayoutParams params) {
        if (!params.isItemRemoved() && !params.isViewInvalid()) {
            if (this.getOrientation() == 1) {
                if (this.getReverseLayout()) {
                    return (float)view.getTop() + view.getTranslationY() <= (float)this.getHeight() + this.mTranslationY;
                }
                return (float)view.getBottom() - view.getTranslationY() >= this.mTranslationY;
            }
            if (this.getReverseLayout()) {
                return (float)view.getLeft() + view.getTranslationX() <= (float)this.getWidth() + this.mTranslationX;
            }
            return (float)view.getRight() - view.getTranslationX() >= this.mTranslationX;
        }
        return false;
    }

    private boolean isViewOnBoundary(View view) {
        if (this.getOrientation() == 1) {
            if (this.getReverseLayout()) {
                return (float)view.getBottom() - view.getTranslationY() > (float)this.getHeight() + this.mTranslationY;
            }
            return (float)view.getTop() + view.getTranslationY() < this.mTranslationY;
        }
        if (this.getReverseLayout()) {
            return (float)view.getRight() - view.getTranslationX() > (float)this.getWidth() + this.mTranslationX;
        }
        return (float)view.getLeft() + view.getTranslationX() < this.mTranslationX;
    }

    private float getY(View headerView, View nextHeaderView) {
        if (this.getOrientation() == 1) {
            float y = this.mTranslationY;
            if (this.getReverseLayout()) {
                y += (float)(this.getHeight() - headerView.getHeight());
            }
            if (nextHeaderView != null) {
                y = this.getReverseLayout() ? Math.max((float)nextHeaderView.getBottom(), y) : Math.min((float)(nextHeaderView.getTop() - headerView.getHeight()), y);
            }
            return y;
        }
        return this.mTranslationY;
    }

    private float getX(View headerView, View nextHeaderView) {
        if (this.getOrientation() != 1) {
            float x = this.mTranslationX;
            if (this.getReverseLayout()) {
                x += (float)(this.getWidth() - headerView.getWidth());
            }
            if (nextHeaderView != null) {
                x = this.getReverseLayout() ? Math.max((float)nextHeaderView.getRight(), x) : Math.min((float)(nextHeaderView.getLeft() - headerView.getWidth()), x);
            }
            return x;
        }
        return this.mTranslationX;
    }

    private int findHeaderIndex(int position) {
        int low = 0;
        int high = this.mHeaderPositions.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (this.mHeaderPositions.get(middle) > position) {
                high = middle - 1;
                continue;
            }
            if (this.mHeaderPositions.get(middle) < position) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private int findHeaderIndexOrBefore(int position) {
        int low = 0;
        int high = this.mHeaderPositions.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (this.mHeaderPositions.get(middle) > position) {
                high = middle - 1;
                continue;
            }
            if (middle < this.mHeaderPositions.size() - 1 && this.mHeaderPositions.get(middle + 1) <= position) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private int findHeaderIndexOrNext(int position) {
        int low = 0;
        int high = this.mHeaderPositions.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (middle > 0 && this.mHeaderPositions.get(middle - 1) >= position) {
                high = middle - 1;
                continue;
            }
            if (this.mHeaderPositions.get(middle) < position) {
                low = middle + 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private void setPendingScroll(int position, int offset) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollOffset = offset;
    }

    public static class SavedState
    implements Parcelable {
        private Parcelable superState;
        private int pendingScrollPosition;
        private int pendingScrollOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState() {
        }

        public SavedState(Parcel in) {
            this.superState = in.readParcelable(SavedState.class.getClassLoader());
            this.pendingScrollPosition = in.readInt();
            this.pendingScrollOffset = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable(this.superState, flags);
            dest.writeInt(this.pendingScrollPosition);
            dest.writeInt(this.pendingScrollOffset);
        }
    }

    private class HeaderPositionsAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private HeaderPositionsAdapterDataObserver() {
        }

        public void onChanged() {
            HoverStaggeredGridLayoutManager.this.mHeaderPositions.clear();
            int itemCount = HoverStaggeredGridLayoutManager.this.mAdapter.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                if (!HoverStaggeredGridLayoutManager.this.mAdapter.isHover(i)) continue;
                HoverStaggeredGridLayoutManager.this.mHeaderPositions.add(i);
            }
            if (HoverStaggeredGridLayoutManager.this.mHover != null && !HoverStaggeredGridLayoutManager.this.mHeaderPositions.contains(HoverStaggeredGridLayoutManager.this.mHoverPosition)) {
                HoverStaggeredGridLayoutManager.this.scrapHover(null);
            }
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            int i;
            int headerCount = HoverStaggeredGridLayoutManager.this.mHeaderPositions.size();
            if (headerCount > 0) {
                for (i = HoverStaggeredGridLayoutManager.this.findHeaderIndexOrNext(positionStart); i != -1 && i < headerCount; ++i) {
                    HoverStaggeredGridLayoutManager.this.mHeaderPositions.set(i, (Integer)HoverStaggeredGridLayoutManager.this.mHeaderPositions.get(i) + itemCount);
                }
            }
            for (i = positionStart; i < positionStart + itemCount; ++i) {
                if (!HoverStaggeredGridLayoutManager.this.mAdapter.isHover(i)) continue;
                int headerIndex = HoverStaggeredGridLayoutManager.this.findHeaderIndexOrNext(i);
                if (headerIndex != -1) {
                    HoverStaggeredGridLayoutManager.this.mHeaderPositions.add(headerIndex, i);
                    continue;
                }
                HoverStaggeredGridLayoutManager.this.mHeaderPositions.add(i);
            }
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            int headerCount = HoverStaggeredGridLayoutManager.this.mHeaderPositions.size();
            if (headerCount > 0) {
                int i;
                for (i = positionStart + itemCount - 1; i >= positionStart; --i) {
                    int index = HoverStaggeredGridLayoutManager.this.findHeaderIndex(i);
                    if (index == -1) continue;
                    HoverStaggeredGridLayoutManager.this.mHeaderPositions.remove(index);
                    --headerCount;
                }
                if (HoverStaggeredGridLayoutManager.this.mHover != null && !HoverStaggeredGridLayoutManager.this.mHeaderPositions.contains(HoverStaggeredGridLayoutManager.this.mHoverPosition)) {
                    HoverStaggeredGridLayoutManager.this.scrapHover(null);
                }
                for (i = HoverStaggeredGridLayoutManager.this.findHeaderIndexOrNext(positionStart + itemCount); i != -1 && i < headerCount; ++i) {
                    HoverStaggeredGridLayoutManager.this.mHeaderPositions.set(i, (Integer)HoverStaggeredGridLayoutManager.this.mHeaderPositions.get(i) - itemCount);
                }
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            block8: {
                int headerCount = HoverStaggeredGridLayoutManager.this.mHeaderPositions.size();
                if (headerCount <= 0) break block8;
                if (fromPosition < toPosition) {
                    for (int i = HoverStaggeredGridLayoutManager.this.findHeaderIndexOrNext(fromPosition); i != -1 && i < headerCount; ++i) {
                        int headerPos = (Integer)HoverStaggeredGridLayoutManager.this.mHeaderPositions.get(i);
                        if (headerPos >= fromPosition && headerPos < fromPosition + itemCount) {
                            HoverStaggeredGridLayoutManager.this.mHeaderPositions.set(i, headerPos - (toPosition - fromPosition));
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        if (headerPos >= fromPosition + itemCount && headerPos <= toPosition) {
                            HoverStaggeredGridLayoutManager.this.mHeaderPositions.set(i, headerPos - itemCount);
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (int i = HoverStaggeredGridLayoutManager.this.findHeaderIndexOrNext(toPosition); i != -1 && i < headerCount; ++i) {
                        int headerPos = (Integer)HoverStaggeredGridLayoutManager.this.mHeaderPositions.get(i);
                        if (headerPos >= fromPosition && headerPos < fromPosition + itemCount) {
                            HoverStaggeredGridLayoutManager.this.mHeaderPositions.set(i, headerPos + (toPosition - fromPosition));
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        if (headerPos >= toPosition && headerPos <= fromPosition) {
                            HoverStaggeredGridLayoutManager.this.mHeaderPositions.set(i, headerPos + itemCount);
                            this.sortHeaderAtIndex(i);
                            continue;
                        }
                        break;
                    }
                }
            }
        }

        private void sortHeaderAtIndex(int index) {
            int headerPos = (Integer)HoverStaggeredGridLayoutManager.this.mHeaderPositions.remove(index);
            int headerIndex = HoverStaggeredGridLayoutManager.this.findHeaderIndexOrNext(headerPos);
            if (headerIndex != -1) {
                HoverStaggeredGridLayoutManager.this.mHeaderPositions.add(headerIndex, headerPos);
            } else {
                HoverStaggeredGridLayoutManager.this.mHeaderPositions.add(headerPos);
            }
        }
    }
}

