/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.OvershootInterpolator;
import android.widget.EditText;
import android.widget.Toast;
import androidx.annotation.FloatRange;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.core.BottomPopupView;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.core.DrawerPopupView;
import com.lxj.xpopup.core.PositionPopupView;
import com.lxj.xpopup.enums.ImageType;
import com.lxj.xpopup.impl.FullScreenPopupView;
import com.lxj.xpopup.impl.PartShadowPopupView;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.util.ImageHeaderParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class XPopupUtils {
    private static int sDecorViewDelta = 0;
    private static int correctKeyboardHeight = 0;
    private static Context mContext;

    public static int getWindowWidth(Context context) {
        return ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getWidth();
    }

    public static int getAppHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        wm.getDefaultDisplay().getSize(point);
        return point.y;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            wm.getDefaultDisplay().getRealSize(point);
        } else {
            wm.getDefaultDisplay().getSize(point);
        }
        return point.y;
    }

    public static int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static void setWidthHeight(View target, int width, int height) {
        if (width <= 0 && height <= 0) {
            return;
        }
        ViewGroup.LayoutParams params = target.getLayoutParams();
        if (width > 0) {
            params.width = width;
        }
        if (height > 0) {
            params.height = height;
        }
        target.setLayoutParams(params);
    }

    public static void applyPopupSize(final ViewGroup content, final int maxWidth, final int maxHeight, final int popupWidth, final int popupHeight, final Runnable afterApplySize) {
        content.post(new Runnable(){

            @Override
            public void run() {
                ViewGroup.LayoutParams params = content.getLayoutParams();
                View implView = content.getChildAt(0);
                ViewGroup.LayoutParams implParams = implView.getLayoutParams();
                int w = content.getMeasuredWidth();
                if (maxWidth > 0) {
                    params.width = Math.min(w, maxWidth);
                    if (popupWidth > 0) {
                        params.width = Math.min(popupWidth, maxWidth);
                        implParams.width = Math.min(popupWidth, maxWidth);
                    }
                } else if (popupWidth > 0) {
                    params.width = popupWidth;
                    implParams.width = popupWidth;
                }
                int h = content.getMeasuredHeight();
                if (maxHeight > 0) {
                    params.height = Math.min(h, maxHeight);
                    if (popupHeight > 0) {
                        params.height = Math.min(popupHeight, maxHeight);
                        implParams.height = Math.min(popupHeight, maxHeight);
                    }
                } else if (popupHeight > 0) {
                    params.height = popupHeight;
                    implParams.height = popupHeight;
                }
                implView.setLayoutParams(implParams);
                content.setLayoutParams(params);
                content.post(new Runnable(){

                    @Override
                    public void run() {
                        if (afterApplySize != null) {
                            afterApplySize.run();
                        }
                    }
                });
            }
        });
    }

    public static void setCursorDrawableColor(EditText et, int color2) {
    }

    public static BitmapDrawable createBitmapDrawable(Resources resources, int width, int color2) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)20, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setColor(color2);
        canvas.drawRect(0.0f, 0.0f, (float)bitmap.getWidth(), 4.0f, paint);
        paint.setColor(0);
        canvas.drawRect(0.0f, 4.0f, (float)bitmap.getWidth(), 20.0f, paint);
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
        bitmapDrawable.setGravity(80);
        return bitmapDrawable;
    }

    public static StateListDrawable createSelector(Drawable defaultDrawable, Drawable focusDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842908}, focusDrawable);
        stateListDrawable.addState(new int[0], defaultDrawable);
        return stateListDrawable;
    }

    public static boolean isInRect(float x, float y, Rect rect) {
        return x >= (float)rect.left && x <= (float)rect.right && y >= (float)rect.top && y <= (float)rect.bottom;
    }

    public static int getDecorViewInvisibleHeight(Window window) {
        View decorView = window.getDecorView();
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (delta <= XPopupUtils.getNavBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public static void moveUpToKeyboard(int keyboardHeight, final BasePopupView pv) {
        if (correctKeyboardHeight == 0) {
            correctKeyboardHeight = keyboardHeight;
        } else if (keyboardHeight != 0) {
            correctKeyboardHeight = Math.min(correctKeyboardHeight, keyboardHeight);
        }
        pv.post(new Runnable(){

            @Override
            public void run() {
                XPopupUtils.moveUpToKeyboardInternal(correctKeyboardHeight, pv);
            }
        });
    }

    private static void moveUpToKeyboardInternal(int keyboardHeight, BasePopupView pv) {
        if (pv.popupInfo == null || !pv.popupInfo.isMoveUpToKeyboard.booleanValue()) {
            return;
        }
        if (pv instanceof PositionPopupView || pv instanceof AttachPopupView && !(pv instanceof PartShadowPopupView)) {
            return;
        }
        ArrayList<EditText> allEts = new ArrayList<EditText>();
        XPopupUtils.findAllEditText(allEts, (ViewGroup)pv);
        EditText focusEt = null;
        for (EditText et : allEts) {
            if (!et.isFocused()) continue;
            focusEt = et;
            break;
        }
        int dy = 0;
        int popupHeight = pv.getPopupContentView().getHeight();
        int popupWidth = pv.getPopupContentView().getWidth();
        if (pv.getPopupImplView() != null) {
            popupHeight = Math.min(popupHeight, pv.getPopupImplView().getMeasuredHeight());
            popupWidth = Math.min(popupWidth, pv.getPopupImplView().getMeasuredWidth());
        }
        int screenHeight = pv.getMeasuredHeight();
        int focusEtTop = 0;
        int focusBottom = 0;
        if (focusEt != null) {
            int[] locations = new int[2];
            focusEt.getLocationInWindow(locations);
            focusEtTop = locations[1];
            focusBottom = focusEtTop + focusEt.getMeasuredHeight();
        }
        if ((pv instanceof FullScreenPopupView || popupWidth == XPopupUtils.getWindowWidth(pv.getContext()) && popupHeight == screenHeight) && focusBottom + keyboardHeight < screenHeight) {
            return;
        }
        if (pv instanceof FullScreenPopupView) {
            int overflowHeight = focusBottom + keyboardHeight - screenHeight;
            if (focusEt != null && overflowHeight > 0) {
                dy = overflowHeight;
            }
        } else if (pv instanceof CenterPopupView) {
            int popupBottom = (screenHeight + popupHeight) / 2;
            int targetY = popupBottom + keyboardHeight - screenHeight;
            if (focusEt != null && focusEtTop - targetY < 0) {
                targetY += focusEtTop - targetY - XPopupUtils.getStatusBarHeight();
            }
            dy = Math.max(0, targetY);
        } else if (pv instanceof BottomPopupView) {
            dy = keyboardHeight;
            if (focusEt != null && focusEtTop - dy < 0) {
                dy += focusEtTop - dy - XPopupUtils.getStatusBarHeight();
            }
        } else if (XPopupUtils.isBottomPartShadow(pv) || pv instanceof DrawerPopupView) {
            int overflowHeight = focusBottom + keyboardHeight - screenHeight;
            if (focusEt != null && overflowHeight > 0) {
                dy = overflowHeight;
            }
        } else if (XPopupUtils.isTopPartShadow(pv)) {
            int overflowHeight = focusBottom + keyboardHeight - screenHeight;
            if (focusEt != null && overflowHeight > 0) {
                dy = overflowHeight;
            }
            if (dy != 0) {
                pv.getPopupImplView().animate().translationY((float)(-dy)).setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.0f)).start();
            }
            return;
        }
        if (dy == 0 && pv.getPopupContentView().getTranslationY() != 0.0f) {
            return;
        }
        pv.getPopupContentView().animate().translationY((float)(-dy)).setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.0f)).start();
    }

    private static boolean isAppHeightContainStatusBar(Context context) {
        int appHeight = XPopupUtils.getAppHeight(context);
        int screenHeight = XPopupUtils.getScreenHeight(context);
        int statusBarHeight = XPopupUtils.getStatusBarHeight();
        int navHeight = XPopupUtils.getNavBarHeight();
        return screenHeight != appHeight + statusBarHeight && screenHeight != appHeight + navHeight + statusBarHeight;
    }

    private static boolean isBottomPartShadow(BasePopupView pv) {
        return pv instanceof PartShadowPopupView && ((PartShadowPopupView)pv).isShowUp;
    }

    private static boolean isTopPartShadow(BasePopupView pv) {
        return pv instanceof PartShadowPopupView && !((PartShadowPopupView)pv).isShowUp;
    }

    public static void moveDown(BasePopupView pv) {
        if (pv instanceof PositionPopupView) {
            return;
        }
        if (!(pv instanceof PartShadowPopupView) && pv instanceof AttachPopupView) {
            return;
        }
        if (pv instanceof PartShadowPopupView && !XPopupUtils.isBottomPartShadow(pv)) {
            pv.getPopupImplView().animate().translationY(0.0f).setDuration(100L).start();
        } else {
            pv.getPopupContentView().animate().translationY(0.0f).setDuration(100L).start();
        }
    }

    public static boolean isNavBarVisible(Window window) {
        boolean isVisible = false;
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        int count = decorView.getChildCount();
        for (int i = 0; i < count; ++i) {
            String resourceEntryName;
            View child = decorView.getChildAt(i);
            int id2 = child.getId();
            if (id2 == -1 || !"navigationBarBackground".equals(resourceEntryName = decorView.getContext().getResources().getResourceEntryName(id2)) || child.getVisibility() != 0) continue;
            isVisible = true;
            break;
        }
        if (isVisible) {
            int visibility = decorView.getSystemUiVisibility();
            isVisible = (visibility & 2) == 0;
        }
        return isVisible;
    }

    public static void findAllEditText(ArrayList<EditText> list, ViewGroup group) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            View v = group.getChildAt(i);
            if (v instanceof EditText && v.getVisibility() == 0) {
                list.add((EditText)v);
                continue;
            }
            if (!(v instanceof ViewGroup)) continue;
            XPopupUtils.findAllEditText(list, (ViewGroup)v);
        }
    }

    public static void saveBmpToAlbum(Context context, final XPopupImageLoader imageLoader, final Object uri) {
        final Handler mainHandler = new Handler(Looper.getMainLooper());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        mContext = context;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                File source = imageLoader.getImageFile(mContext, uri);
                if (source == null) {
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)mContext, (CharSequence)"\u56fe\u7247\u4e0d\u5b58\u5728\uff01", (int)0).show();
                            mContext = null;
                        }
                    });
                    return;
                }
                String dirPath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + Environment.DIRECTORY_PICTURES;
                File dirFile = new File(dirPath);
                if (!dirFile.exists()) {
                    dirFile.mkdirs();
                }
                try {
                    ImageType type = ImageHeaderParser.getImageType(new FileInputStream(source));
                    String ext = XPopupUtils.getFileExt(type);
                    File target = new File(dirPath, System.currentTimeMillis() + "." + ext);
                    if (target.exists()) {
                        target.delete();
                    }
                    target.createNewFile();
                    XPopupUtils.writeFileFromIS(target, new FileInputStream(source));
                    MediaScannerConnection.scanFile((Context)mContext, (String[])new String[]{target.getAbsolutePath()}, (String[])new String[]{"image/" + ext}, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                        public void onScanCompleted(String path, Uri uri) {
                            mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (mContext != null) {
                                        Toast.makeText((Context)mContext, (CharSequence)"\u5df2\u4fdd\u5b58\u5230\u76f8\u518c\uff01", (int)0).show();
                                        mContext = null;
                                    }
                                }
                            });
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)mContext, (CharSequence)"\u6ca1\u6709\u4fdd\u5b58\u6743\u9650\uff0c\u4fdd\u5b58\u529f\u80fd\u65e0\u6cd5\u4f7f\u7528\uff01", (int)0).show();
                            mContext = null;
                        }
                    });
                }
            }
        });
    }

    private static String getFileExt(ImageType type) {
        switch (type) {
            case GIF: {
                return "gif";
            }
            case PNG: 
            case PNG_A: {
                return "png";
            }
            case WEBP: 
            case WEBP_A: {
                return "webp";
            }
            case JPEG: {
                return "jpeg";
            }
        }
        return "jpeg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileFromIS(File file, InputStream is) {
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file));
            byte[] data = new byte[8192];
            while ((len = is.read(data, 0, 8192)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap renderScriptBlur(Context context, Bitmap src, @FloatRange(from=0.0, to=25.0, fromInclusive=false) float radius, boolean recycle) {
        RenderScript rs = null;
        Bitmap ret = recycle ? src : src.copy(src.getConfig(), true);
        try {
            rs = RenderScript.create((Context)context);
            rs.setMessageHandler(new RenderScript.RSMessageHandler());
            Allocation input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)ret, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Allocation output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            blurScript.setInput(input);
            blurScript.setRadius(radius);
            blurScript.forEach(output);
            output.copyTo(ret);
        }
        finally {
            if (rs != null) {
                rs.destroy();
            }
        }
        return ret;
    }

    public static Bitmap view2Bitmap(View view) {
        Bitmap bitmap;
        if (view == null) {
            return null;
        }
        boolean drawingCacheEnabled = view.isDrawingCacheEnabled();
        boolean willNotCacheDrawing = view.willNotCacheDrawing();
        view.setDrawingCacheEnabled(true);
        view.setWillNotCacheDrawing(false);
        Bitmap drawingCache = view.getDrawingCache();
        if (null == drawingCache) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            view.buildDrawingCache();
            drawingCache = view.getDrawingCache();
            if (drawingCache != null) {
                bitmap = Bitmap.createBitmap((Bitmap)drawingCache);
            } else {
                bitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
            }
        } else {
            bitmap = Bitmap.createBitmap((Bitmap)drawingCache);
        }
        view.destroyDrawingCache();
        view.setWillNotCacheDrawing(willNotCacheDrawing);
        view.setDrawingCacheEnabled(drawingCacheEnabled);
        return bitmap;
    }

    public static boolean isLayoutRtl(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            Locale primaryLocale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
            return TextUtils.getLayoutDirectionFromLocale((Locale)primaryLocale) == 1;
        }
        return false;
    }

    public static Activity context2Activity(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static Drawable createDrawable(int color2, float radius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setColor(color2);
        drawable.setCornerRadius(radius);
        return drawable;
    }

    public static Drawable createDrawable(int color2, float tlRadius, float trRadius, float brRadius, float blRadius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setColor(color2);
        drawable.setCornerRadii(new float[]{tlRadius, tlRadius, trRadius, trRadius, brRadius, brRadius, blRadius, blRadius});
        return drawable;
    }
}

