/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatEditText;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.impl.ConfirmPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.lxj.xpopup.interfaces.OnInputConfirmListener;
import com.lxj.xpopup.util.XPopupUtils;

public class InputConfirmPopupView
extends ConfirmPopupView
implements View.OnClickListener {
    AppCompatEditText et_input;
    public CharSequence inputContent;
    OnCancelListener cancelListener;
    OnInputConfirmListener inputConfirmListener;

    public InputConfirmPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    public InputConfirmPopupView bindLayout(int layoutId) {
        this.bindLayoutId = layoutId;
        return this;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.et_input = (AppCompatEditText)this.findViewById(R.id.et_input);
        this.et_input.setVisibility(0);
        if (!TextUtils.isEmpty((CharSequence)this.hint)) {
            this.et_input.setHint(this.hint);
        }
        if (!TextUtils.isEmpty((CharSequence)this.inputContent)) {
            this.et_input.setText(this.inputContent);
            this.et_input.setSelection(this.inputContent.length());
        }
        this.applyPrimary();
    }

    public AppCompatEditText getEditText() {
        return this.et_input;
    }

    protected void applyPrimary() {
        super.applyPrimaryColor();
        XPopupUtils.setCursorDrawableColor((EditText)this.et_input, XPopup.getPrimaryColor());
        this.et_input.post(new Runnable(){

            @Override
            public void run() {
                BitmapDrawable defaultDrawable = XPopupUtils.createBitmapDrawable(InputConfirmPopupView.this.getResources(), InputConfirmPopupView.this.et_input.getMeasuredWidth(), Color.parseColor((String)"#888888"));
                BitmapDrawable focusDrawable = XPopupUtils.createBitmapDrawable(InputConfirmPopupView.this.getResources(), InputConfirmPopupView.this.et_input.getMeasuredWidth(), XPopup.getPrimaryColor());
                InputConfirmPopupView.this.et_input.setBackgroundDrawable((Drawable)XPopupUtils.createSelector((Drawable)defaultDrawable, (Drawable)focusDrawable));
            }
        });
    }

    public void setListener(OnInputConfirmListener inputConfirmListener, OnCancelListener cancelListener) {
        this.cancelListener = cancelListener;
        this.inputConfirmListener = inputConfirmListener;
    }

    @Override
    public void onClick(View v) {
        if (v == this.tv_cancel) {
            if (this.cancelListener != null) {
                this.cancelListener.onCancel();
            }
            this.dismiss();
        } else if (v == this.tv_confirm) {
            if (this.inputConfirmListener != null) {
                this.inputConfirmListener.onConfirm(this.et_input.getText().toString().trim());
            }
            if (this.popupInfo.autoDismiss.booleanValue()) {
                this.dismiss();
            }
        }
    }
}

