/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.BubbleAttachPopupView;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.BubbleLayout;

public class BubbleHorizontalAttachPopupView
extends BubbleAttachPopupView {
    float translationX = 0.0f;
    float translationY = 0.0f;

    public BubbleHorizontalAttachPopupView(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void initPopupContent() {
        this.bubbleContainer.setLook(BubbleLayout.Look.LEFT);
        super.initPopupContent();
        this.defaultOffsetY = this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX == 0 ? XPopupUtils.dp2px(this.getContext(), 2.0f) : this.popupInfo.offsetX;
    }

    @Override
    public void doAttach() {
        final boolean isRTL = XPopupUtils.isLayoutRtl(this.getContext());
        if (this.popupInfo.touchPoint != null) {
            if (XPopup.longClickPoint != null) {
                this.popupInfo.touchPoint = XPopup.longClickPoint;
            }
            this.popupInfo.touchPoint.x -= (float)this.getActivityContentLeft();
            this.isShowLeft = this.popupInfo.touchPoint.x > (float)XPopupUtils.getAppWidth(this.getContext()) / 2.0f;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxWidth = (int)((float)XPopupUtils.getAppWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow);
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = Math.max(maxWidth, this.getPopupWidth());
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (BubbleHorizontalAttachPopupView.this.popupInfo == null) {
                        return;
                    }
                    BubbleHorizontalAttachPopupView.this.translationX = isRTL ? (BubbleHorizontalAttachPopupView.this.isShowLeft ? -((float)XPopupUtils.getAppWidth(BubbleHorizontalAttachPopupView.this.getContext()) - BubbleHorizontalAttachPopupView.this.popupInfo.touchPoint.x + (float)BubbleHorizontalAttachPopupView.this.defaultOffsetX) : -((float)XPopupUtils.getAppWidth(BubbleHorizontalAttachPopupView.this.getContext()) - BubbleHorizontalAttachPopupView.this.popupInfo.touchPoint.x - (float)BubbleHorizontalAttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)BubbleHorizontalAttachPopupView.this.defaultOffsetX)) : (BubbleHorizontalAttachPopupView.this.isShowLeftToTarget() ? BubbleHorizontalAttachPopupView.this.popupInfo.touchPoint.x - (float)BubbleHorizontalAttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)BubbleHorizontalAttachPopupView.this.defaultOffsetX : BubbleHorizontalAttachPopupView.this.popupInfo.touchPoint.x + (float)BubbleHorizontalAttachPopupView.this.defaultOffsetX);
                    BubbleHorizontalAttachPopupView.this.translationY = BubbleHorizontalAttachPopupView.this.popupInfo.touchPoint.y - (float)BubbleHorizontalAttachPopupView.this.getPopupContentView().getMeasuredHeight() * 0.5f + (float)BubbleHorizontalAttachPopupView.this.defaultOffsetY;
                    BubbleHorizontalAttachPopupView.this.doBubble();
                }
            });
        } else {
            int maxWidth;
            final Rect rect = this.popupInfo.getAtViewRect();
            rect.left -= this.getActivityContentLeft();
            rect.right -= this.getActivityContentLeft();
            final int centerX = (rect.left + rect.right) / 2;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int n = maxWidth = this.isShowLeft ? XPopupUtils.getAppWidth(this.getContext()) - rect.left - this.overflow : XPopupUtils.getAppWidth(this.getContext()) - rect.right - this.overflow;
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = Math.max(maxWidth, this.getPopupWidth());
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    boolean bl = BubbleHorizontalAttachPopupView.this.isShowLeft = centerX > XPopupUtils.getAppWidth(BubbleHorizontalAttachPopupView.this.getContext()) / 2;
                    BubbleHorizontalAttachPopupView.this.translationX = isRTL ? (BubbleHorizontalAttachPopupView.this.isShowLeft ? (float)(-(XPopupUtils.getAppWidth(BubbleHorizontalAttachPopupView.this.getContext()) - rect.left + BubbleHorizontalAttachPopupView.this.defaultOffsetX)) : (float)(-(XPopupUtils.getAppWidth(BubbleHorizontalAttachPopupView.this.getContext()) - rect.right - BubbleHorizontalAttachPopupView.this.getPopupContentView().getMeasuredWidth() - BubbleHorizontalAttachPopupView.this.defaultOffsetX))) : (BubbleHorizontalAttachPopupView.this.isShowLeftToTarget() ? (float)(rect.left - BubbleHorizontalAttachPopupView.this.getPopupContentView().getMeasuredWidth() - BubbleHorizontalAttachPopupView.this.defaultOffsetX) : (float)(rect.right + BubbleHorizontalAttachPopupView.this.defaultOffsetX));
                    BubbleHorizontalAttachPopupView.this.translationY = (float)rect.top + (float)(rect.height() - BubbleHorizontalAttachPopupView.this.getPopupContentView().getMeasuredHeight() - BubbleHorizontalAttachPopupView.this.bubbleContainer.getShadowRadius() * 2) / 2.0f + (float)BubbleHorizontalAttachPopupView.this.defaultOffsetY;
                    BubbleHorizontalAttachPopupView.this.doBubble();
                }
            });
        }
    }

    private void doBubble() {
        if (this.isShowLeftToTarget()) {
            this.bubbleContainer.setLook(BubbleLayout.Look.RIGHT);
        } else {
            this.bubbleContainer.setLook(BubbleLayout.Look.LEFT);
        }
        if (this.defaultOffsetY == 0) {
            this.bubbleContainer.setLookPositionCenter(true);
        } else {
            this.bubbleContainer.setLookPosition(Math.max(0, (int)((float)this.bubbleContainer.getMeasuredHeight() / 2.0f - (float)this.defaultOffsetY - (float)(this.bubbleContainer.mLookLength / 2))));
        }
        this.bubbleContainer.invalidate();
        this.getPopupContentView().setTranslationX(this.translationX);
        this.getPopupContentView().setTranslationY(this.translationY);
        this.initAndStartAnimation();
    }

    private boolean isShowLeftToTarget() {
        return (this.isShowLeft || this.popupInfo.popupPosition == PopupPosition.Left) && this.popupInfo.popupPosition != PopupPosition.Right;
    }
}

