/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.interfaces.OnClickOutsideListener;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public abstract class PartShadowPopupView
extends BasePopupView {
    protected PartShadowContainer attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);
    public boolean isShowUp;

    public PartShadowPopupView(@NonNull Context context) {
        super(context);
        this.attachPopupContainer.popupView = this;
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_partshadow_popup_view;
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
    }

    @Override
    protected void initPopupContent() {
        if (this.attachPopupContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.targetView = this.getPopupContentView();
        }
        this.getPopupImplView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupImplView().setTranslationY((float)this.popupInfo.offsetY);
        this.getPopupImplView().setAlpha(0.0f);
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), new Runnable(){

            @Override
            public void run() {
                PartShadowPopupView.this.doAttach();
            }
        });
    }

    private void initAndStartAnimation() {
        this.initAnimator();
        this.doShowAnimation();
        this.doAfterShow();
    }

    public void doAttach() {
        if (this.popupInfo.atView == null) {
            throw new IllegalArgumentException("atView() must be called before show()\uff01");
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getPopupContentView().getLayoutParams();
        params.width = this.getActivityContentView().getWidth();
        Rect rect = this.popupInfo.getAtViewRect();
        int centerY = rect.top + rect.height() / 2;
        View implView = this.getPopupImplView();
        FrameLayout.LayoutParams implParams = (FrameLayout.LayoutParams)implView.getLayoutParams();
        if ((centerY > this.getMeasuredHeight() / 2 || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom) {
            params.height = rect.top;
            this.isShowUp = true;
            implParams.gravity = 80;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
        } else {
            params.height = this.getMeasuredHeight() - rect.bottom;
            this.isShowUp = false;
            params.topMargin = rect.bottom;
            implParams.gravity = 48;
            if (this.getMaxHeight() != 0) {
                implParams.height = Math.min(implView.getMeasuredHeight(), this.getMaxHeight());
            }
        }
        this.getPopupContentView().setLayoutParams((ViewGroup.LayoutParams)params);
        implView.setLayoutParams((ViewGroup.LayoutParams)implParams);
        this.getPopupContentView().post(new Runnable(){

            @Override
            public void run() {
                PartShadowPopupView.this.initAndStartAnimation();
                PartShadowPopupView.this.getPopupImplView().setAlpha(1.0f);
            }
        });
        this.attachPopupContainer.notDismissArea = this.popupInfo.notDismissWhenTouchInArea;
        this.attachPopupContainer.setOnClickOutsideListener(new OnClickOutsideListener(){

            @Override
            public void onClickOutside() {
                if (PartShadowPopupView.this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                    PartShadowPopupView.this.dismiss();
                }
            }
        });
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new TranslateAnimator(this.getPopupImplView(), this.getAnimationDuration(), this.isShowUp ? PopupAnimation.TranslateFromBottom : PopupAnimation.TranslateFromTop);
    }
}

