/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PopupDrawerLayout;

public abstract class DrawerPopupView
extends BasePopupView {
    protected PopupDrawerLayout drawerLayout;
    protected FrameLayout drawerContentContainer;
    float mFraction = 0.0f;
    Paint paint = new Paint();
    Rect shadowRect;
    public ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    int currColor = 0;
    int defaultColor = 0;

    public DrawerPopupView(@NonNull Context context) {
        super(context);
        this.drawerLayout = (PopupDrawerLayout)this.findViewById(R.id.drawerLayout);
        this.drawerContentContainer = (FrameLayout)this.findViewById(R.id.drawerContentContainer);
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.drawerContentContainer, false);
        this.drawerContentContainer.addView(contentView);
    }

    @Override
    public View getPopupImplView() {
        return this.drawerContentContainer.getChildAt(0);
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_drawer_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.drawerLayout.isDismissOnTouchOutside = this.popupInfo.isDismissOnTouchOutside;
        this.drawerLayout.setOnCloseListener(new PopupDrawerLayout.OnCloseListener(){

            @Override
            public void onClose() {
                DrawerPopupView.this.beforeDismiss();
                if (DrawerPopupView.this.popupInfo != null && DrawerPopupView.this.popupInfo.xPopupCallback != null) {
                    DrawerPopupView.this.popupInfo.xPopupCallback.beforeDismiss(DrawerPopupView.this);
                }
                DrawerPopupView.this.doAfterDismiss();
            }

            @Override
            public void onOpen() {
            }

            @Override
            public void onDrag(int x, float fraction, boolean isToLeft) {
                if (DrawerPopupView.this.popupInfo == null) {
                    return;
                }
                if (DrawerPopupView.this.popupInfo.xPopupCallback != null) {
                    DrawerPopupView.this.popupInfo.xPopupCallback.onDrag(DrawerPopupView.this, x, fraction, isToLeft);
                }
                DrawerPopupView.this.mFraction = fraction;
                if (DrawerPopupView.this.popupInfo.hasShadowBg.booleanValue()) {
                    DrawerPopupView.this.shadowBgAnimator.applyColorValue(fraction);
                }
                DrawerPopupView.this.postInvalidate();
            }
        });
        this.getPopupImplView().setTranslationX((float)this.popupInfo.offsetX);
        this.getPopupImplView().setTranslationY((float)this.popupInfo.offsetY);
        this.drawerLayout.setDrawerPosition(this.popupInfo.popupPosition == null ? PopupPosition.Left : this.popupInfo.popupPosition);
        this.drawerLayout.enableDrag = this.popupInfo.enableDrag;
        this.drawerLayout.getChildAt(0).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DrawerPopupView.this.popupInfo != null) {
                    if (DrawerPopupView.this.popupInfo.xPopupCallback != null) {
                        DrawerPopupView.this.popupInfo.xPopupCallback.onClickOutside(DrawerPopupView.this);
                    }
                    if (DrawerPopupView.this.popupInfo.isDismissOnTouchOutside != null) {
                        DrawerPopupView.this.dismiss();
                    }
                }
            }
        });
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.popupInfo != null && this.popupInfo.hasStatusBarShadow.booleanValue()) {
            if (this.shadowRect == null) {
                this.shadowRect = new Rect(0, 0, this.getMeasuredWidth(), XPopupUtils.getStatusBarHeight());
            }
            this.paint.setColor(((Integer)this.argbEvaluator.evaluate(this.mFraction, (Object)this.defaultColor, (Object)this.getStatusBarBgColor())).intValue());
            canvas.drawRect(this.shadowRect, this.paint);
        }
    }

    public void doStatusBarColorTransform(boolean isShow) {
        if (this.popupInfo != null && this.popupInfo.hasStatusBarShadow.booleanValue()) {
            ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)this.argbEvaluator, (Object[])new Object[]{isShow ? 0 : this.getStatusBarBgColor(), isShow ? this.getStatusBarBgColor() : 0});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    DrawerPopupView.this.currColor = (Integer)animation.getAnimatedValue();
                    DrawerPopupView.this.postInvalidate();
                }
            });
            animator.setDuration((long)this.getAnimationDuration()).start();
        }
    }

    @Override
    public void doShowAnimation() {
        this.drawerLayout.open();
        this.doStatusBarColorTransform(true);
    }

    @Override
    public void doDismissAnimation() {
    }

    @Override
    protected void doAfterDismiss() {
        if (this.popupInfo != null && this.popupInfo.autoOpenSoftInput.booleanValue()) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.handler.removeCallbacks(this.doAfterDismissTask);
        this.handler.postDelayed(this.doAfterDismissTask, 0L);
    }

    @Override
    public void dismiss() {
        if (this.popupInfo == null) {
            return;
        }
        if (this.popupStatus == PopupStatus.Dismissing) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.clearFocus();
        this.doStatusBarColorTransform(false);
        this.drawerLayout.close();
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return null;
    }
}

