/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.BlurAnimator;
import com.lxj.xpopup.animator.EmptyAnimator;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.animator.ShadowBgAnimator;
import com.lxj.xpopup.animator.TranslateAlphaAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.core.BubbleAttachPopupView;
import com.lxj.xpopup.core.FullScreenDialog;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.core.PositionPopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.impl.FullScreenPopupView;
import com.lxj.xpopup.impl.PartShadowPopupView;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.util.XPopupUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePopupView
extends FrameLayout
implements LifecycleObserver {
    public PopupInfo popupInfo;
    protected PopupAnimator popupContentAnimator;
    protected ShadowBgAnimator shadowBgAnimator;
    protected BlurAnimator blurAnimator;
    private final int touchSlop;
    public PopupStatus popupStatus = PopupStatus.Dismiss;
    protected boolean isCreated = false;
    private boolean hasModifySoftMode = false;
    private int preSoftMode = -1;
    private boolean hasMoveUp = false;
    protected Handler handler = new Handler(Looper.getMainLooper());
    private final Runnable attachTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.attachToHost();
            KeyboardUtils.registerSoftInputChangedListener(BasePopupView.this.getHostWindow(), BasePopupView.this, new KeyboardUtils.OnSoftInputChangedListener(){

                @Override
                public void onSoftInputChanged(int height) {
                    BasePopupView.this.onKeyboardHeightChange(height);
                    if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                        BasePopupView.this.popupInfo.xPopupCallback.onKeyBoardStateChanged(BasePopupView.this, height);
                    }
                    if (height == 0) {
                        XPopupUtils.moveDown(BasePopupView.this);
                        BasePopupView.this.hasMoveUp = false;
                    } else {
                        if (BasePopupView.this.hasMoveUp) {
                            return;
                        }
                        if (BasePopupView.this instanceof FullScreenPopupView && BasePopupView.this.popupStatus == PopupStatus.Showing) {
                            return;
                        }
                        if (BasePopupView.this instanceof PartShadowPopupView && BasePopupView.this.popupStatus == PopupStatus.Showing) {
                            return;
                        }
                        XPopupUtils.moveUpToKeyboard(height, BasePopupView.this);
                        BasePopupView.this.hasMoveUp = true;
                    }
                }
            });
            BasePopupView.this.init();
        }
    };
    public FullScreenDialog dialog;
    private final Runnable initTask = new Runnable(){

        @Override
        public void run() {
            if (BasePopupView.this.getHostWindow() == null) {
                return;
            }
            if (BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.beforeShow(BasePopupView.this);
            }
            BasePopupView.this.beforeShow();
            if (!(BasePopupView.this instanceof FullScreenPopupView)) {
                BasePopupView.this.focusAndProcessBackPress();
            }
            if (!(BasePopupView.this instanceof AttachPopupView || BasePopupView.this instanceof BubbleAttachPopupView || BasePopupView.this instanceof PositionPopupView || BasePopupView.this instanceof PartShadowPopupView)) {
                BasePopupView.this.initAnimator();
                BasePopupView.this.doShowAnimation();
                BasePopupView.this.doAfterShow();
            }
        }
    };
    protected Runnable doAfterShowTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.popupStatus = PopupStatus.Show;
            BasePopupView.this.onShow();
            if (BasePopupView.this instanceof FullScreenPopupView) {
                BasePopupView.this.focusAndProcessBackPress();
            }
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onShow(BasePopupView.this);
            }
            if (BasePopupView.this.getHostWindow() != null && XPopupUtils.getDecorViewInvisibleHeight(BasePopupView.this.getHostWindow()) > 0 && !BasePopupView.this.hasMoveUp) {
                XPopupUtils.moveUpToKeyboard(XPopupUtils.getDecorViewInvisibleHeight(BasePopupView.this.getHostWindow()), BasePopupView.this);
            }
        }
    };
    private ShowSoftInputTask showSoftInputTask;
    protected Runnable doAfterDismissTask = new Runnable(){

        @Override
        public void run() {
            View needFocusView;
            BasePopupView.this.popupStatus = PopupStatus.Dismiss;
            if (BasePopupView.this.popupInfo == null) {
                return;
            }
            if (BasePopupView.this.popupInfo.autoOpenSoftInput.booleanValue() && BasePopupView.this instanceof PartShadowPopupView) {
                KeyboardUtils.hideSoftInput((View)BasePopupView.this);
            }
            BasePopupView.this.onDismiss();
            XPopup.longClickPoint = null;
            if (BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onDismiss(BasePopupView.this);
            }
            if (BasePopupView.this.dismissWithRunnable != null) {
                BasePopupView.this.dismissWithRunnable.run();
                BasePopupView.this.dismissWithRunnable = null;
            }
            if (BasePopupView.this.popupInfo.isRequestFocus && BasePopupView.this.popupInfo.isViewMode && BasePopupView.this.getWindowDecorView() != null && (needFocusView = BasePopupView.this.getWindowDecorView().findViewById(0x1020002)) != null) {
                needFocusView.setFocusable(true);
                needFocusView.setFocusableInTouchMode(true);
            }
            BasePopupView.this.detachFromHost();
        }
    };
    Runnable dismissWithRunnable;
    private float x;
    private float y;

    public BasePopupView(@NonNull Context context) {
        super(context);
        if (context instanceof Application) {
            throw new IllegalArgumentException("XPopup\u7684Context\u5fc5\u987b\u662fActivity\u7c7b\u578b\uff01");
        }
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        View contentView = LayoutInflater.from((Context)context).inflate(this.getInnerLayoutId(), (ViewGroup)this, false);
        contentView.setAlpha(0.0f);
        this.addView(contentView);
    }

    public BasePopupView show() {
        Activity activity = XPopupUtils.context2Activity((View)this);
        if (activity == null || activity.isFinishing() || this.popupInfo == null) {
            return this;
        }
        if (this.popupStatus == PopupStatus.Showing || this.popupStatus == PopupStatus.Dismissing) {
            return this;
        }
        this.popupStatus = PopupStatus.Showing;
        if (this.popupInfo.isRequestFocus) {
            KeyboardUtils.hideSoftInput(activity.getWindow());
        }
        if (!this.popupInfo.isViewMode && this.dialog != null && this.dialog.isShowing()) {
            return this;
        }
        this.handler.post(this.attachTask);
        return this;
    }

    private void attachToHost() {
        if (this.getContext() instanceof FragmentActivity) {
            ((FragmentActivity)this.getContext()).getLifecycle().addObserver((LifecycleObserver)this);
        }
        if (this.popupInfo.isViewMode) {
            ViewGroup decorView = (ViewGroup)((Activity)this.getContext()).getWindow().getDecorView();
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            decorView.addView((View)this);
        } else {
            if (this.dialog == null) {
                this.dialog = new FullScreenDialog(this.getContext()).setContent(this);
            }
            this.dialog.show();
        }
        if (this.popupInfo == null) {
            throw new IllegalArgumentException("\u5982\u679c\u5f39\u7a97\u5bf9\u8c61\u662f\u590d\u7528\u7684\uff0c\u5219\u4e0d\u8981\u8bbe\u7f6eisDestroyOnDismiss(true)");
        }
    }

    protected View getWindowDecorView() {
        if (this.getHostWindow() == null) {
            return null;
        }
        return (ViewGroup)this.getHostWindow().getDecorView();
    }

    protected void init() {
        if (this.shadowBgAnimator == null) {
            this.shadowBgAnimator = new ShadowBgAnimator((View)this, this.getAnimationDuration(), this.getShadowBgColor());
        }
        if (this.popupInfo.hasBlurBg.booleanValue()) {
            this.blurAnimator = new BlurAnimator((View)this, this.getShadowBgColor());
            this.blurAnimator.hasShadowBg = this.popupInfo.hasShadowBg;
            this.blurAnimator.decorBitmap = XPopupUtils.view2Bitmap(XPopupUtils.context2Activity((View)this).getWindow().getDecorView());
        }
        if (this instanceof AttachPopupView || this instanceof BubbleAttachPopupView || this instanceof PartShadowPopupView || this instanceof PositionPopupView) {
            this.initPopupContent();
        } else if (!this.isCreated) {
            this.initPopupContent();
        }
        if (!this.isCreated) {
            this.isCreated = true;
            this.onCreate();
            if (this.popupInfo.xPopupCallback != null) {
                this.popupInfo.xPopupCallback.onCreated(this);
            }
        }
        this.handler.postDelayed(this.initTask, 10L);
    }

    protected void initAnimator() {
        this.getPopupContentView().setAlpha(1.0f);
        if (this.popupInfo.customAnimator != null) {
            this.popupContentAnimator = this.popupInfo.customAnimator;
            this.popupContentAnimator.targetView = this.getPopupContentView();
        } else {
            this.popupContentAnimator = this.genAnimatorByPopupType();
            if (this.popupContentAnimator == null) {
                this.popupContentAnimator = this.getPopupAnimator();
            }
        }
        if (this.popupInfo.hasShadowBg.booleanValue()) {
            this.shadowBgAnimator.initAnimator();
        }
        if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.initAnimator();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.initAnimator();
        }
    }

    private void detachFromHost() {
        if (this.popupInfo != null && this.popupInfo.isViewMode) {
            ViewGroup decorView = (ViewGroup)this.getParent();
            if (decorView != null) {
                decorView.removeView((View)this);
            }
        } else if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    public Window getHostWindow() {
        if (this.popupInfo != null && this.popupInfo.isViewMode) {
            return ((Activity)this.getContext()).getWindow();
        }
        return this.dialog == null ? null : this.dialog.getWindow();
    }

    protected void doAfterShow() {
        this.handler.removeCallbacks(this.doAfterShowTask);
        this.handler.postDelayed(this.doAfterShowTask, (long)this.getAnimationDuration());
    }

    public void focusAndProcessBackPress() {
        if (this.popupInfo != null && this.popupInfo.isRequestFocus) {
            this.setFocusableInTouchMode(true);
            this.setFocusable(true);
            this.requestFocus();
            if (Build.VERSION.SDK_INT >= 28) {
                this.addOnUnhandledKeyEventListener(new View.OnUnhandledKeyEventListener(){

                    public boolean onUnhandledKeyEvent(View v, KeyEvent event) {
                        return BasePopupView.this.processKeyEvent(event.getKeyCode(), event);
                    }
                });
            } else {
                this.setOnKeyListener(new BackPressListener());
            }
            ArrayList<EditText> list = new ArrayList<EditText>();
            XPopupUtils.findAllEditText(list, (ViewGroup)this.getPopupContentView());
            if (list.size() > 0) {
                if (this.popupInfo.isViewMode) {
                    this.preSoftMode = this.getHostWindow().getAttributes().softInputMode;
                    this.getHostWindow().setSoftInputMode(16);
                    this.hasModifySoftMode = true;
                }
                for (int i = 0; i < list.size(); ++i) {
                    EditText et = list.get(i);
                    if (Build.VERSION.SDK_INT >= 28) {
                        et.addOnUnhandledKeyEventListener(new View.OnUnhandledKeyEventListener(){

                            public boolean onUnhandledKeyEvent(View v, KeyEvent event) {
                                return BasePopupView.this.processKeyEvent(event.getKeyCode(), event);
                            }
                        });
                    } else {
                        boolean hasSetKeyListener = XPopupUtils.hasSetKeyListener((View)et);
                        if (!hasSetKeyListener) {
                            et.setOnKeyListener((View.OnKeyListener)new BackPressListener());
                        }
                    }
                    if (i != 0) continue;
                    if (this.popupInfo.autoFocusEditText) {
                        et.setFocusable(true);
                        et.setFocusableInTouchMode(true);
                        et.requestFocus();
                        if (!this.popupInfo.autoOpenSoftInput.booleanValue()) continue;
                        this.showSoftInput((View)et);
                        continue;
                    }
                    if (!this.popupInfo.autoOpenSoftInput.booleanValue()) continue;
                    this.showSoftInput((View)this);
                }
            } else if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
                this.showSoftInput((View)this);
            }
        }
    }

    protected void showSoftInput(View focusView) {
        if (this.popupInfo != null) {
            if (this.showSoftInputTask == null) {
                this.showSoftInputTask = new ShowSoftInputTask(focusView);
            } else {
                this.handler.removeCallbacks((Runnable)this.showSoftInputTask);
            }
            this.handler.postDelayed((Runnable)this.showSoftInputTask, 10L);
        }
    }

    public void dismissOrHideSoftInput() {
        if (KeyboardUtils.sDecorViewInvisibleHeightPre == 0) {
            this.dismiss();
        } else {
            KeyboardUtils.hideSoftInput((View)this);
        }
    }

    protected boolean processKeyEvent(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && this.popupInfo != null) {
            if (this.popupInfo.isDismissOnBackPressed.booleanValue() && (this.popupInfo.xPopupCallback == null || !this.popupInfo.xPopupCallback.onBackPressed(this))) {
                this.dismissOrHideSoftInput();
            }
            return true;
        }
        return false;
    }

    protected PopupAnimator genAnimatorByPopupType() {
        if (this.popupInfo == null || this.popupInfo.popupAnimation == null) {
            return null;
        }
        switch (this.popupInfo.popupAnimation) {
            case ScaleAlphaFromCenter: 
            case ScaleAlphaFromLeftTop: 
            case ScaleAlphaFromRightTop: 
            case ScaleAlphaFromLeftBottom: 
            case ScaleAlphaFromRightBottom: {
                return new ScaleAlphaAnimator(this.getPopupContentView(), this.getAnimationDuration(), this.popupInfo.popupAnimation);
            }
            case TranslateAlphaFromLeft: 
            case TranslateAlphaFromTop: 
            case TranslateAlphaFromRight: 
            case TranslateAlphaFromBottom: {
                return new TranslateAlphaAnimator(this.getPopupContentView(), this.getAnimationDuration(), this.popupInfo.popupAnimation);
            }
            case TranslateFromLeft: 
            case TranslateFromTop: 
            case TranslateFromRight: 
            case TranslateFromBottom: {
                return new TranslateAnimator(this.getPopupContentView(), this.getAnimationDuration(), this.popupInfo.popupAnimation);
            }
            case ScrollAlphaFromLeft: 
            case ScrollAlphaFromLeftTop: 
            case ScrollAlphaFromTop: 
            case ScrollAlphaFromRightTop: 
            case ScrollAlphaFromRight: 
            case ScrollAlphaFromRightBottom: 
            case ScrollAlphaFromBottom: 
            case ScrollAlphaFromLeftBottom: {
                return new ScrollScaleAnimator(this.getPopupContentView(), this.getAnimationDuration(), this.popupInfo.popupAnimation);
            }
            case NoAnimation: {
                return new EmptyAnimator(this.getPopupContentView(), this.getAnimationDuration());
            }
        }
        return null;
    }

    protected abstract int getInnerLayoutId();

    protected int getImplLayoutId() {
        return -1;
    }

    protected PopupAnimator getPopupAnimator() {
        return null;
    }

    protected void initPopupContent() {
    }

    protected void onCreate() {
    }

    protected void applyDarkTheme() {
    }

    protected void applyLightTheme() {
    }

    protected void doShowAnimation() {
        if (this.popupInfo == null) {
            return;
        }
        if (this.popupInfo.hasShadowBg.booleanValue() && !this.popupInfo.hasBlurBg.booleanValue() && this.shadowBgAnimator != null) {
            this.shadowBgAnimator.animateShow();
        } else if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.animateShow();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateShow();
        }
    }

    protected void doDismissAnimation() {
        if (this.popupInfo == null) {
            return;
        }
        if (this.popupInfo.hasShadowBg.booleanValue() && !this.popupInfo.hasBlurBg.booleanValue() && this.shadowBgAnimator != null) {
            this.shadowBgAnimator.animateDismiss();
        } else if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.animateDismiss();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateDismiss();
        }
    }

    public View getPopupContentView() {
        return this.getChildAt(0);
    }

    public View getPopupImplView() {
        return ((ViewGroup)this.getPopupContentView()).getChildAt(0);
    }

    public int getAnimationDuration() {
        if (this.popupInfo == null) {
            return 0;
        }
        if (this.popupInfo.popupAnimation == PopupAnimation.NoAnimation) {
            return 1;
        }
        return this.popupInfo.animationDuration >= 0 ? this.popupInfo.animationDuration : XPopup.getAnimationDuration() + 1;
    }

    public int getShadowBgColor() {
        return this.popupInfo != null && this.popupInfo.shadowBgColor != 0 ? this.popupInfo.shadowBgColor : XPopup.getShadowBgColor();
    }

    public int getStatusBarBgColor() {
        return this.popupInfo != null && this.popupInfo.statusBarBgColor != 0 ? this.popupInfo.statusBarBgColor : XPopup.getStatusBarBgColor();
    }

    protected int getMaxWidth() {
        return this.popupInfo.maxWidth;
    }

    protected int getMaxHeight() {
        return this.popupInfo.maxHeight;
    }

    protected int getPopupWidth() {
        return this.popupInfo.popupWidth;
    }

    protected int getPopupHeight() {
        return this.popupInfo.popupHeight;
    }

    public void dismiss() {
        this.handler.removeCallbacks(this.attachTask);
        this.handler.removeCallbacks(this.initTask);
        if (this.popupStatus == PopupStatus.Dismissing || this.popupStatus == PopupStatus.Dismiss) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.clearFocus();
        if (this.popupInfo != null && this.popupInfo.xPopupCallback != null) {
            this.popupInfo.xPopupCallback.beforeDismiss(this);
        }
        this.beforeDismiss();
        this.doDismissAnimation();
        this.doAfterDismiss();
    }

    public void smartDismiss() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.delayDismiss(BasePopupView.this.getAnimationDuration() + 50);
            }
        });
    }

    public void delayDismiss(long delay) {
        if (delay < 0L) {
            delay = 0L;
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.dismiss();
            }
        }, delay);
    }

    public void delayDismissWith(long delay, Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.delayDismiss(delay);
    }

    protected void doAfterDismiss() {
        if (this.popupInfo != null && this.popupInfo.autoOpenSoftInput.booleanValue() && !(this instanceof PartShadowPopupView)) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.handler.removeCallbacks(this.doAfterDismissTask);
        this.handler.postDelayed(this.doAfterDismissTask, (long)this.getAnimationDuration());
    }

    public void dismissWith(Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.dismiss();
    }

    public boolean isShow() {
        return this.popupStatus != PopupStatus.Dismiss;
    }

    public boolean isDismiss() {
        return this.popupStatus == PopupStatus.Dismiss;
    }

    public void toggle() {
        if (this.isShow()) {
            this.dismiss();
        } else {
            this.show();
        }
    }

    protected void tryRemoveFragments() {
        if (this.getContext() instanceof FragmentActivity) {
            FragmentManager manager = ((FragmentActivity)this.getContext()).getSupportFragmentManager();
            List fragments = manager.getFragments();
            List<String> internalFragmentNames = this.getInternalFragmentNames();
            if (fragments != null && fragments.size() > 0 && internalFragmentNames != null) {
                for (int i = 0; i < fragments.size(); ++i) {
                    String name = ((Fragment)fragments.get(i)).getClass().getSimpleName();
                    if (!internalFragmentNames.contains(name)) continue;
                    manager.beginTransaction().remove((Fragment)fragments.get(i)).commitAllowingStateLoss();
                }
            }
        }
    }

    protected List<String> getInternalFragmentNames() {
        return null;
    }

    protected void onDismiss() {
    }

    protected void beforeDismiss() {
    }

    protected void beforeShow() {
    }

    protected void onShow() {
    }

    protected void onKeyboardHeightChange(int height) {
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.onDetachedFromWindow();
        this.detachFromHost();
        this.destroy();
    }

    public void destroy() {
        if (this.popupInfo != null) {
            this.popupInfo.atView = null;
            this.popupInfo.watchView = null;
            this.popupInfo.xPopupCallback = null;
            if (this.popupInfo.customAnimator != null && this.popupInfo.customAnimator.targetView != null) {
                this.popupInfo.customAnimator.targetView.animate().cancel();
            }
            if (this.popupInfo.isViewMode) {
                this.tryRemoveFragments();
            }
            if (this.popupInfo.isDestroyOnDismiss) {
                this.popupInfo = null;
            }
        }
        if (this.dialog != null) {
            this.dialog.contentView = null;
            this.dialog = null;
        }
        if (this.shadowBgAnimator != null && this.shadowBgAnimator.targetView != null) {
            this.shadowBgAnimator.targetView.animate().cancel();
        }
        if (this.blurAnimator != null && this.blurAnimator.targetView != null) {
            this.blurAnimator.targetView.animate().cancel();
            if (this.blurAnimator.decorBitmap != null && !this.blurAnimator.decorBitmap.isRecycled()) {
                this.blurAnimator.decorBitmap.recycle();
                this.blurAnimator.decorBitmap = null;
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.handler.removeCallbacksAndMessages(null);
        if (this.popupInfo != null) {
            if (this.getWindowDecorView() != null) {
                KeyboardUtils.removeLayoutChangeListener(this.getWindowDecorView(), this);
            }
            if (this.popupInfo.isViewMode && this.hasModifySoftMode) {
                this.getHostWindow().setSoftInputMode(this.preSoftMode);
                this.hasModifySoftMode = false;
            }
            if (this.popupInfo.isDestroyOnDismiss) {
                this.destroy();
            }
        }
        if (this.getContext() != null && this.getContext() instanceof FragmentActivity) {
            ((FragmentActivity)this.getContext()).getLifecycle().removeObserver((LifecycleObserver)this);
        }
        this.popupStatus = PopupStatus.Dismiss;
        this.showSoftInputTask = null;
        this.hasMoveUp = false;
    }

    private void passClickThrough(MotionEvent event) {
        if (this.popupInfo != null && this.popupInfo.isClickThrough) {
            if (this.popupInfo.isViewMode) {
                ViewGroup decorView = (ViewGroup)((Activity)this.getContext()).getWindow().getDecorView();
                for (int i = 0; i < decorView.getChildCount(); ++i) {
                    View view = decorView.getChildAt(i);
                    if (view == this) continue;
                    view.dispatchTouchEvent(event);
                }
            } else {
                ((Activity)this.getContext()).dispatchTouchEvent(event);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        this.getPopupContentView().getGlobalVisibleRect(rect);
        if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    this.passClickThrough(event);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect2)) {
                        this.passClickThrough(event);
                    }
                    if (distance < (float)this.touchSlop && this.popupInfo != null && this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                        this.dismiss();
                        this.getPopupImplView().getGlobalVisibleRect(rect2);
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                }
            }
        }
        return true;
    }

    class BackPressListener
    implements View.OnKeyListener {
        BackPressListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            return BasePopupView.this.processKeyEvent(keyCode, event);
        }
    }

    static class ShowSoftInputTask
    implements Runnable {
        View focusView;

        public ShowSoftInputTask(View focusView) {
            this.focusView = focusView;
        }

        @Override
        public void run() {
            if (this.focusView != null) {
                KeyboardUtils.showSoftInput(this.focusView);
            }
        }
    }
}

